/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.block.hopper;

import com.abdelaziz.canary.common.hopper.CanaryStackList;
import com.abdelaziz.canary.common.hopper.StorableItemStack;
import com.abdelaziz.canary.common.util.tuples.RefIntPair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements StorableItemStack {
    @Shadow
    private int f_41587_;
    private int mySlot;
    @Nullable
    private Object myLocation;

    @Override
    public void registerToInventory(CanaryStackList itemStacks, int mySlot) {
        if (this.myLocation != null) {
            this.canaryRegisterMultipleInventories(itemStacks, mySlot);
        } else {
            this.myLocation = itemStacks;
            this.mySlot = mySlot;
        }
    }

    @Override
    public void unregisterFromInventory(CanaryStackList stackList) {
        this.unregisterFromInventory(stackList, -1);
    }

    @Override
    public void unregisterFromInventory(CanaryStackList myInventoryList, int index) {
        if (this.myLocation == myInventoryList) {
            this.myLocation = null;
            this.mySlot = -1;
        } else if (this.myLocation instanceof Set) {
            this.canaryUnregisterMultipleInventories(myInventoryList, index);
        } else {
            this.myLocation = null;
        }
    }

    @ModifyVariable(method={"setCount(I)V"}, at=@At(value="HEAD"))
    public int updateInventory(int count) {
        if (this.myLocation != null && this.f_41587_ != count) {
            Object object = this.myLocation;
            if (object instanceof CanaryStackList) {
                CanaryStackList stackList = (CanaryStackList)object;
                stackList.beforeSlotCountChange(this.mySlot, count);
            } else {
                this.canaryUpdateMultipleInventories();
            }
        }
        return count;
    }

    private void canaryRegisterMultipleInventories(CanaryStackList itemStacks, int mySlot) {
        RefIntPair<CanaryStackList> pair;
        Set stackLists;
        if (this.myLocation instanceof Set) {
            stackLists = (Set)this.myLocation;
        } else {
            stackLists = new ObjectOpenHashSet();
            if (this.myLocation != null) {
                pair = new RefIntPair<CanaryStackList>((CanaryStackList)this.myLocation, this.mySlot);
                stackLists.add(pair);
                this.myLocation = stackLists;
                this.mySlot = -1;
            }
        }
        pair = new RefIntPair<CanaryStackList>(itemStacks, mySlot);
        stackLists.add(pair);
    }

    private void canaryUnregisterMultipleInventories(CanaryStackList itemStacks, int mySlot) {
        Object object = this.myLocation;
        if (object instanceof Set) {
            Set set;
            Set stackLists = set = (Set)object;
            if (mySlot >= 0) {
                stackLists.remove(new RefIntPair<CanaryStackList>(itemStacks, mySlot));
            } else {
                stackLists.removeIf(stackListSlotPair -> stackListSlotPair.left() == itemStacks);
            }
        }
    }

    private void canaryUpdateMultipleInventories() {
        Object object = this.myLocation;
        if (object instanceof Set) {
            Set set;
            Set stackLists = set = (Set)object;
            for (RefIntPair stackListLocationPair : stackLists) {
                ((CanaryStackList)stackListLocationPair.left()).beforeSlotCountChange(stackListLocationPair.right(), this.f_41587_);
            }
        }
    }
}

