/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.pattern;

import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.collect.Range;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.blocks.base.WorkingTile;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalApothecary.BlockEntityApothecaryAdvanced;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalApothecary.BlockEntityApothecaryBase;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalApothecary.BlockEntityApothecaryUpgraded;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.lmor.botanicalextramachinery.config.LibXServerConfig;
import net.lmor.botanicalextramachinery.util.SettingPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ModSounds;

public class BlockEntityApothecaryPattern
extends WorkingTile<IPetalRecipe>
implements TickableBlock,
IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    public static final int WORKING_DURATION = LibXServerConfig.ApothecarySettings.workingDuration;
    public final int FLUID_CAPACITY;
    private final int SEEDS_SLOT;
    private final int FIRST_INPUT_SLOT;
    private final int LAST_INPUT_SLOT;
    private final int FIRST_OUTPUT_SLOT;
    private final int LAST_OUTPUT_SLOT;
    private int UPGRADE_SLOT_1 = -1;
    private int UPGRADE_SLOT_2 = -1;
    private final BaseItemStackHandler inventory;
    private final ApothecaryFluidTank fluidInventory;
    private final LazyOptional<IFluidHandler> fluidHandler;
    private ItemStack currentOutput;
    private int timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
    private final SettingPattern settingPattern;
    private boolean setChangedQueued;
    private final IManagedGridNode mainNode = this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy");

    public BlockEntityApothecaryPattern(BlockEntityType<?> type, BlockPos pos, BlockState state, int[] slots, int countCraft, SettingPattern settingPattern) {
        super(type, ModRecipeTypes.PETAL_TYPE, pos, state, 0, slots[1], slots[3], countCraft);
        this.currentOutput = ItemStack.f_41583_;
        this.SEEDS_SLOT = slots[0];
        this.FIRST_INPUT_SLOT = slots[1];
        this.LAST_INPUT_SLOT = slots[2];
        this.FIRST_OUTPUT_SLOT = slots[3];
        this.LAST_OUTPUT_SLOT = slots[4];
        if (slots.length >= 6) {
            this.UPGRADE_SLOT_1 = slots[5];
        }
        if (slots.length >= 7) {
            this.UPGRADE_SLOT_2 = slots[6];
        }
        this.settingPattern = settingPattern;
        this.FLUID_CAPACITY = settingPattern.getConfigInt("fluidStorage");
        this.fluidInventory = new ApothecaryFluidTank(this.FLUID_CAPACITY, fluidStack -> Fluids.f_76193_.m_6212_(fluidStack.getFluid()));
        this.fluidHandler = LazyOptional.of(() -> this.fluidInventory);
        this.inventory = this.UPGRADE_SLOT_1 != -1 && this.UPGRADE_SLOT_2 == -1 ? BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> stack.m_204117_(Tags.Items.SEEDS), new int[]{this.SEEDS_SLOT}).validator(stack -> stack.m_41720_() == ModItems.catalystSeedInfinity.m_5456_(), new int[]{this.UPGRADE_SLOT_1}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.PETAL_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).slotLimit(1, new int[]{this.UPGRADE_SLOT_1}).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build() : (this.UPGRADE_SLOT_1 != -1 ? BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> stack.m_204117_(Tags.Items.SEEDS), new int[]{this.SEEDS_SLOT}).validator(stack -> stack.m_41720_() == ModItems.catalystSeedInfinity.m_5456_() || stack.m_41720_() == ModItems.catalystWaterInfinity.m_5456_(), new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.PETAL_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).slotLimit(1, new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build() : BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> stack.m_204117_(Tags.Items.SEEDS), new int[]{this.SEEDS_SLOT}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.PETAL_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build());
        this.setChangedQueued = false;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            if (!this.getMainNode().isReady()) {
                this.getMainNode().create(this.f_58857_, this.m_58899_());
            }
            if (this.getMainNode() != null && this.getMainNode().getNode() != null && this.getMainNode().isOnline()) {
                if (this.timeCheckOutputSlot <= 0) {
                    if (this.checkOutputSlots()) {
                        this.exportResultsItemsME();
                    }
                    this.timeCheckOutputSlot = 20;
                } else {
                    --this.timeCheckOutputSlot;
                }
            }
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.runRecipeTick();
            if (this.recipe != null) {
                this.currentOutput = ((IPetalRecipe)this.recipe).m_8043_().m_41777_();
                this.m_6596_();
                this.setDispatchable();
            } else if (!this.currentOutput.m_41619_()) {
                this.currentOutput = ItemStack.f_41583_;
                this.m_6596_();
                this.setDispatchable();
            }
            this.upgradedCheck();
        } else if (this.f_58857_ != null && LibXClientConfig.RenderingVisualContent.all && this.settingPattern.getConfigBoolean("mechanicalApothecaryRender").booleanValue() && this.fluidInventory.getFluidAmount() > 0 && this.fluidInventory.getFluidAmount() > 0) {
            if (this.getMaxProgress() > 0 && this.getProgress() > this.getMaxProgress() - 5) {
                for (int i = 0; i < 5; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle((float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (int)10);
                    this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, (double)this.f_58858_.m_123342_() + 0.6, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, 0.0, 0.0, 0.0);
                }
                this.f_58857_.m_7785_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, ModSounds.altarCraft, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            } else {
                for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                    ItemStack stack = this.inventory.getStackInSlot(slot);
                    if (stack.m_41619_() || !(this.f_58857_.f_46441_.nextFloat() >= 0.97f)) continue;
                    int color = stack.m_41720_() instanceof ICustomApothecaryColor ? ((ICustomApothecaryColor)stack.m_41720_()).getParticleColor(stack) : 0x888888;
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color & 0xFF) / 255.0f;
                    if (Math.random() >= 0.75) {
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.1f, 10.0f);
                    }
                    SparkleParticleData data = SparkleParticleData.sparkle((float)this.f_58857_.f_46441_.nextFloat(), (float)red, (float)green, (float)blue, (int)10);
                    this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, (double)this.f_58858_.m_123342_() + 0.6, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private boolean checkOutputSlots() {
        for (int i = this.FIRST_OUTPUT_SLOT; i <= this.LAST_OUTPUT_SLOT; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getUpgrades() {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        if (this.UPGRADE_SLOT_1 != -1) {
            res.add(new ItemStack((ItemLike)ModItems.catalystSeedInfinity));
        }
        if (this.UPGRADE_SLOT_2 != -1) {
            res.add(new ItemStack((ItemLike)ModItems.catalystWaterInfinity));
        }
        return res;
    }

    public void upgradedCheck() {
        if (this.UPGRADE_SLOT_1 != -1 && this.UPGRADE_SLOT_2 == -1) {
            if (!this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41619_() && this.inventory.getStackInSlot(this.SEEDS_SLOT).m_41619_()) {
                ItemStack seed = Items.f_42404_.m_7968_();
                seed.m_41764_(64);
                this.inventory.setStackInSlot(this.SEEDS_SLOT, seed);
            }
        } else if (this.UPGRADE_SLOT_1 != -1 && this.UPGRADE_SLOT_2 != -1) {
            if ((!this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41619_() && this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41720_().m_5456_() == ModItems.catalystSeedInfinity.m_5456_() || !this.inventory.getStackInSlot(this.UPGRADE_SLOT_2).m_41619_() && this.inventory.getStackInSlot(this.UPGRADE_SLOT_2).m_41720_().m_5456_() == ModItems.catalystSeedInfinity.m_5456_()) && this.inventory.getStackInSlot(this.SEEDS_SLOT).m_41619_()) {
                ItemStack seed = Items.f_42404_.m_7968_();
                seed.m_41764_(64);
                this.inventory.setStackInSlot(this.SEEDS_SLOT, seed);
            }
            if ((!this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41619_() && this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41720_().m_5456_() == ModItems.catalystWaterInfinity.m_5456_() || !this.inventory.getStackInSlot(this.UPGRADE_SLOT_2).m_41619_() && this.inventory.getStackInSlot(this.UPGRADE_SLOT_2).m_41720_().m_5456_() == ModItems.catalystWaterInfinity.m_5456_()) && this.fluidInventory.getFluidAmount() != this.fluidInventory.getCapacity()) {
                FluidStack fluid = this.getFluidInventory().getFluid().copy();
                if (fluid.isEmpty()) {
                    fluid = new FluidStack((Fluid)Fluids.f_76193_, this.FLUID_CAPACITY);
                }
                fluid.setAmount(this.FLUID_CAPACITY);
                this.getFluidInventory().setFluid(fluid);
            }
        }
    }

    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot >= this.FIRST_OUTPUT_SLOT && slot <= this.LAST_OUTPUT_SLOT;
    }

    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    public FluidTank getFluidInventory() {
        return this.fluidInventory;
    }

    public boolean actAsMana() {
        return false;
    }

    @Override
    protected int getAndApplyProgressThisTick() {
        return 1;
    }

    @Override
    protected boolean canMatchRecipes() {
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            return false;
        }
        FluidStack fluid = this.getFluidInventory().getFluid();
        return !fluid.isEmpty() && fluid.getFluid() == Fluids.f_76193_ && fluid.getAmount() >= 1000;
    }

    @Override
    protected void onCrafted(IPetalRecipe recipe, int countItemCraft) {
        this.inventory.extractItem(0, 1, false);
        FluidStack fluid = this.getFluidInventory().getFluid().copy();
        if (fluid.getFluid() == Fluids.f_76193_) {
            int newAmount = Math.max(0, fluid.getAmount() - 1000);
            fluid.setAmount(newAmount);
            this.fluidInventory.setFluid(fluid);
        }
    }

    @Override
    protected int getMaxProgress(IPetalRecipe recipe) {
        return WORKING_DURATION * this.settingPattern.getConfigInt("craftTime");
    }

    @Override
    public int getMaxManaPerTick() {
        return 1;
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    @Nonnull
    public <X> LazyOptional<X> getCapability(@Nonnull Capability<X> cap, @Nullable Direction side) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.fluidHandler.cast() : super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidInventory.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
        this.currentOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentOutput"));
        this.m_6596_();
        this.setDispatchable();
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag tankTag = new CompoundTag();
        this.getFluidInventory().getFluid().writeToNBT(tankTag);
        nbt.m_128365_("fluid", (Tag)tankTag);
        nbt.m_128365_("currentOutput", (Tag)this.currentOutput.serializeNBT());
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.fluidInventory.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
            this.currentOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentOutput"));
        }
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        CompoundTag tankTag = new CompoundTag();
        this.getFluidInventory().getFluid().writeToNBT(tankTag);
        nbt.m_128365_("fluid", (Tag)tankTag);
        nbt.m_128365_("currentOutput", (Tag)this.currentOutput.serializeNBT());
        return nbt;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getMainNode() != null) {
            this.getMainNode().destroy();
        }
    }

    public void drops() {
        IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected Item getItemFromBlockEntity() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityApothecaryBase) {
            return ModBlocks.baseApothecary.m_5456_();
        }
        if (blockEntity instanceof BlockEntityApothecaryUpgraded) {
            return ModBlocks.upgradedApothecary.m_5456_();
        }
        if (blockEntity instanceof BlockEntityApothecaryAdvanced) {
            return ModBlocks.advancedApothecary.m_5456_();
        }
        return ModBlocks.ultimateApothecary.m_5456_();
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        return this.getMainNode().getNode();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public void saveChanges() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.m_6596_();
            } else {
                this.f_58857_.m_151543_(this.f_58858_);
                if (!this.setChangedQueued) {
                    TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                    this.setChangedQueued = true;
                }
            }
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    private void exportResultsItemsME() {
        for (int slot = this.FIRST_OUTPUT_SLOT; slot <= this.LAST_OUTPUT_SLOT; ++slot) {
            int getCountExport;
            ItemStack stackInSlot = this.inventory.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || (getCountExport = Math.toIntExact(this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stackInSlot), (long)stackInSlot.m_41613_(), Actionable.MODULATE, IActionSource.empty()))) <= 0) continue;
            stackInSlot.m_41774_(getCountExport);
            this.inventory.setStackInSlot(slot, stackInSlot);
        }
    }

    private class ApothecaryFluidTank
    extends FluidTank {
        public ApothecaryFluidTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            BlockEntityApothecaryPattern.this.m_6596_();
            BlockEntityApothecaryPattern.this.setDispatchable();
            BlockEntityApothecaryPattern.this.needsRecipeUpdate();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

