/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.pattern;

import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.collect.Range;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.blocks.base.WorkingTile;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalIndustrialAgglomerationFactory.BlockEntityIndustrialAgglomerationFactoryAdvanced;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalIndustrialAgglomerationFactory.BlockEntityIndustrialAgglomerationFactoryBase;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalIndustrialAgglomerationFactory.BlockEntityIndustrialAgglomerationFactoryUpgraded;
import net.lmor.botanicalextramachinery.config.LibXServerConfig;
import net.lmor.botanicalextramachinery.util.SettingPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class BlockEntityIndustrialAgglomerationFactoryPattern
extends WorkingTile<ITerraPlateRecipe>
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    public static final int MAX_MANA_PER_TICK = LibXServerConfig.IndustrialAgglomerationFactorySettings.workingDuration;
    private final int FIRST_INPUT_SLOT;
    private final int LAST_INPUT_SLOT;
    private final int FIRST_OUTPUT_SLOT;
    private final int LAST_OUTPUT_SLOT;
    private int UPGRADE_SLOT_1 = -1;
    private int UPGRADE_SLOT_2 = -1;
    private final SettingPattern settingPattern;
    private final BaseItemStackHandler inventory;
    private int timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
    protected int speedMulti = 1;
    private boolean setChangedQueued;
    private final IManagedGridNode mainNode = this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy");

    public BlockEntityIndustrialAgglomerationFactoryPattern(BlockEntityType<?> type, BlockPos pos, BlockState state, int manaCapacity, int countCraft, int[] slots, SettingPattern settingPattern) {
        super(type, ModRecipeTypes.TERRA_PLATE_TYPE, pos, state, manaCapacity, slots[0], slots[2], countCraft);
        this.FIRST_INPUT_SLOT = slots[0];
        this.LAST_INPUT_SLOT = slots[1];
        this.FIRST_OUTPUT_SLOT = slots[2];
        this.LAST_OUTPUT_SLOT = slots[3];
        if (slots.length >= 5) {
            this.UPGRADE_SLOT_1 = slots[4];
            this.UPGRADE_SLOT_2 = slots[5];
        }
        this.settingPattern = settingPattern;
        this.inventory = this.UPGRADE_SLOT_1 != -1 && this.UPGRADE_SLOT_2 != -1 ? BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.TERRA_PLATE_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).validator(stack -> stack.m_41720_() == ModItems.catalystSpeed.m_5456_() || stack.m_41720_() == ModItems.catalystManaInfinity.m_5456_(), new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).slotLimit(1, new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build() : BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.TERRA_PLATE_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build();
        this.setChangedQueued = false;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.getMainNode().isReady()) {
                this.getMainNode().create(this.f_58857_, this.m_58899_());
            }
            this.runRecipeTick();
            if (this.getMainNode() != null && this.getMainNode().getNode() != null && this.getMainNode().isOnline()) {
                if (this.timeCheckOutputSlot <= 0) {
                    if (this.checkOutputSlots()) {
                        this.exportResultsItemsME();
                    }
                    this.timeCheckOutputSlot = 20;
                } else {
                    --this.timeCheckOutputSlot;
                }
            }
            if (this.getManaCap() != this.getCurrentMana() && (this.UPGRADE_SLOT_1 != -1 && this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41720_().m_5456_() == ModItems.catalystManaInfinity || this.UPGRADE_SLOT_2 != -1 && this.inventory.getStackInSlot(this.UPGRADE_SLOT_2).m_41720_().m_5456_() == ModItems.catalystManaInfinity)) {
                this.receiveMana(this.getManaCap());
            }
            this.speedMulti = this.speedMulti == 1 && (this.UPGRADE_SLOT_1 != -1 && this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41720_().m_5456_() == ModItems.catalystSpeed || this.UPGRADE_SLOT_2 != -1 && this.inventory.getStackInSlot(this.UPGRADE_SLOT_2).m_41720_().m_5456_() == ModItems.catalystSpeed) ? 4 : 1;
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.m_6596_();
        this.setDispatchable();
    }

    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot >= this.FIRST_OUTPUT_SLOT && slot <= this.LAST_OUTPUT_SLOT;
    }

    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected int getMaxProgress(ITerraPlateRecipe recipe) {
        return recipe.getMana();
    }

    @Override
    public int getMaxManaPerTick() {
        return MAX_MANA_PER_TICK * this.settingPattern.getConfigInt("craftTime") * this.speedMulti;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    private boolean checkOutputSlots() {
        for (int i = this.FIRST_OUTPUT_SLOT; i <= this.LAST_OUTPUT_SLOT; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getMainNode() != null) {
            this.getMainNode().destroy();
        }
    }

    public void drops() {
        IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected Item getItemFromBlockEntity() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityIndustrialAgglomerationFactoryBase) {
            return ModBlocks.baseIndustrialAgglomerationFactory.m_5456_();
        }
        if (blockEntity instanceof BlockEntityIndustrialAgglomerationFactoryUpgraded) {
            return ModBlocks.upgradedIndustrialAgglomerationFactory.m_5456_();
        }
        if (blockEntity instanceof BlockEntityIndustrialAgglomerationFactoryAdvanced) {
            return ModBlocks.advancedIndustrialAgglomerationFactory.m_5456_();
        }
        return ModBlocks.ultimateIndustrialAgglomerationFactory.m_5456_();
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        return this.getMainNode().getNode();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public void saveChanges() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.m_6596_();
            } else {
                this.f_58857_.m_151543_(this.f_58858_);
                if (!this.setChangedQueued) {
                    TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                    this.setChangedQueued = true;
                }
            }
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    private void exportResultsItemsME() {
        for (int slot = this.FIRST_OUTPUT_SLOT; slot <= this.LAST_OUTPUT_SLOT; ++slot) {
            int getCountExport;
            ItemStack stackInSlot = this.inventory.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || (getCountExport = Math.toIntExact(this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stackInSlot), (long)stackInSlot.m_41613_(), Actionable.MODULATE, IActionSource.empty()))) <= 0) continue;
            stackInSlot.m_41774_(getCountExport);
            this.inventory.setStackInSlot(slot, stackInSlot);
        }
    }
}

