/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.pattern;

import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.blocks.base.WorkingTile;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalRunicAltar.BlockEntityRunicAltarAdvanced;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalRunicAltar.BlockEntityRunicAltarBase;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalRunicAltar.BlockEntityRunicAltarUpgraded;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.lmor.botanicalextramachinery.config.LibXServerConfig;
import net.lmor.botanicalextramachinery.util.SettingPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.lib.ModTags;

public class BlockEntityRunicAltarPattern
extends WorkingTile<IRuneAltarRecipe>
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    public static final int MAX_MANA_PER_TICK = LibXServerConfig.RunicAltarSettings.manaCost;
    private final int LIVINGROCK_SLOT_1;
    private final int LIVINGROCK_SLOT_2;
    private final int LIVINGROCK_SLOT_3;
    private final int UPGRADE_SLOT_1;
    private final int UPGRADE_SLOT_2;
    private final int FIRST_INPUT_SLOT;
    private final int LAST_INPUT_SLOT;
    private final int FIRST_OUTPUT_SLOT;
    private final int LAST_OUTPUT_SLOT;
    private final BaseItemStackHandler inventory;
    private final SettingPattern settingPattern;
    private final boolean[] isUpgrade;
    private final List<Integer> slotsUsed = new ArrayList<Integer>();
    private int timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
    private List<Integer> slotsLivingRock = new ArrayList<Integer>();
    private boolean setChangedQueued;
    private final IManagedGridNode mainNode = this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy");

    public BlockEntityRunicAltarPattern(BlockEntityType<?> type, BlockPos pos, BlockState state, int manaCap, int[] slots, boolean[] isUpgrade, int countCraft, SettingPattern config) {
        super(type, ModRecipeTypes.RUNE_TYPE, pos, state, manaCap, slots[1], slots[3], countCraft);
        this.LIVINGROCK_SLOT_1 = this.addLivingRockSlotsArray(slots[0]);
        this.FIRST_INPUT_SLOT = slots[1];
        this.LAST_INPUT_SLOT = slots[2];
        this.FIRST_OUTPUT_SLOT = slots[3];
        this.LAST_OUTPUT_SLOT = slots[4];
        this.UPGRADE_SLOT_1 = slots[5];
        this.UPGRADE_SLOT_2 = slots[6];
        this.LIVINGROCK_SLOT_2 = this.addLivingRockSlotsArray(slots[7]);
        this.LIVINGROCK_SLOT_3 = this.addLivingRockSlotsArray(slots[8]);
        this.inventory = isUpgrade[0] && isUpgrade[1] ? BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> stack.m_41720_() == vazkii.botania.common.block.ModBlocks.livingrock.m_5456_(), new int[]{this.LIVINGROCK_SLOT_1, this.LIVINGROCK_SLOT_2, this.LIVINGROCK_SLOT_3}).validator(stack -> stack.m_41720_() == ModItems.catalystManaInfinity.m_5456_() || stack.m_41720_() == ModItems.catalystLivingRockInfinity.m_5456_(), new int[]{this.UPGRADE_SLOT_1}).validator(stack -> stack.m_41720_() == ModItems.catalystManaInfinity.m_5456_() || stack.m_41720_() == ModItems.catalystLivingRockInfinity.m_5456_(), new int[]{this.UPGRADE_SLOT_2}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.RUNE_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).slotLimit(1, new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build() : (isUpgrade[0] ? BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> stack.m_41720_() == vazkii.botania.common.block.ModBlocks.livingrock.m_5456_(), new int[]{this.LIVINGROCK_SLOT_1, this.LIVINGROCK_SLOT_2, this.LIVINGROCK_SLOT_3}).validator(stack -> stack.m_41720_() == ModItems.catalystManaInfinity.m_5456_() || stack.m_41720_() == ModItems.catalystLivingRockInfinity.m_5456_(), new int[]{this.UPGRADE_SLOT_1}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.RUNE_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).slotLimit(1, new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build() : BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> stack.m_41720_() == vazkii.botania.common.block.ModBlocks.livingrock.m_5456_(), new int[]{this.LIVINGROCK_SLOT_1, this.LIVINGROCK_SLOT_2, this.LIVINGROCK_SLOT_3}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.RUNE_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).slotLimit(1, new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build());
        this.settingPattern = config;
        this.isUpgrade = isUpgrade;
        this.setChangedQueued = false;
    }

    public int addLivingRockSlotsArray(int index) {
        this.slotsLivingRock.add(index);
        return this.slotsLivingRock.get(index);
    }

    public List<ItemStack> getUpgrades() {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        res.add(new ItemStack((ItemLike)ModItems.catalystManaInfinity));
        res.add(new ItemStack((ItemLike)ModItems.catalystLivingRockInfinity));
        return res;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.getMainNode().isReady()) {
                this.getMainNode().create(this.f_58857_, this.m_58899_());
            }
            if (this.getMainNode() != null && this.getMainNode().getNode() != null && this.getMainNode().isOnline()) {
                if (this.timeCheckOutputSlot <= 0) {
                    if (this.checkOutputSlots()) {
                        this.exportResultsItemsME();
                    }
                    this.timeCheckOutputSlot = 20;
                } else {
                    --this.timeCheckOutputSlot;
                }
            }
            if (this.isUpgrade[0] && this.getManaCap() != this.getCurrentMana() && (!this.getSlotUpgrade1().m_41619_() && this.getSlotUpgrade1().m_41720_() == ModItems.catalystManaInfinity || this.isUpgrade[1] && !this.getSlotUpgrade2().m_41619_() && this.getSlotUpgrade2().m_41720_() == ModItems.catalystManaInfinity)) {
                this.receiveMana(this.getManaCap());
            }
            if (this.isUpgrade[0] && (this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_1).m_41619_() || this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_2).m_41619_() || this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_3).m_41619_()) && (!this.getSlotUpgrade1().m_41619_() && this.getSlotUpgrade1().m_41720_() == ModItems.catalystLivingRockInfinity.m_5456_() || this.isUpgrade[1] && !this.getSlotUpgrade2().m_41619_() && this.getSlotUpgrade2().m_41720_() == ModItems.catalystLivingRockInfinity.m_5456_())) {
                this.addLivingRockSlots();
            }
            List<Integer> slotsUsed = this.slotsUsed;
            this.runRecipeTick(slotsUsed::clear, (stack, slot) -> this.slotsUsed.add((Integer)slot), (stack, slot) -> {});
        } else if (this.f_58857_ != null && LibXClientConfig.RenderingVisualContent.all && this.settingPattern.getConfigBoolean("mechanicalRunicAltarRender").booleanValue() && this.getMaxProgress() > 0 && this.getProgress() >= this.getMaxProgress() - 5 * this.getMaxManaPerTick()) {
            for (int i = 0; i < 5; ++i) {
                SparkleParticleData data = SparkleParticleData.sparkle((float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (int)10);
                this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, 0.0, 0.0, 0.0);
            }
        }
    }

    public ItemStack getSlotUpgrade1() {
        if (this.UPGRADE_SLOT_1 == -1) {
            return null;
        }
        return this.inventory.getStackInSlot(this.UPGRADE_SLOT_1);
    }

    public ItemStack getSlotUpgrade2() {
        if (this.UPGRADE_SLOT_2 == -1) {
            return null;
        }
        return this.inventory.getStackInSlot(this.UPGRADE_SLOT_2);
    }

    public void addLivingRockSlots() {
        ItemStack livingrock = new ItemStack((ItemLike)vazkii.botania.common.block.ModBlocks.livingrock.m_5456_());
        livingrock.m_41764_(64);
        if (this.LIVINGROCK_SLOT_1 == this.LIVINGROCK_SLOT_2 && this.LIVINGROCK_SLOT_2 == this.LIVINGROCK_SLOT_3 && this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_1).m_41619_()) {
            this.inventory.setStackInSlot(this.LIVINGROCK_SLOT_1, livingrock);
        } else if (this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_1).m_41619_()) {
            this.inventory.setStackInSlot(this.LIVINGROCK_SLOT_1, livingrock);
        } else if (this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_2).m_41619_()) {
            this.inventory.setStackInSlot(this.LIVINGROCK_SLOT_2, livingrock);
        } else if (this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_3).m_41619_()) {
            this.inventory.setStackInSlot(this.LIVINGROCK_SLOT_3, livingrock);
        }
    }

    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot >= this.FIRST_OUTPUT_SLOT && slot <= this.LAST_OUTPUT_SLOT;
    }

    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canMatchRecipes() {
        return !this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_1).m_41619_() || !this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_2).m_41619_() || !this.inventory.getStackInSlot(this.LIVINGROCK_SLOT_3).m_41619_();
    }

    @Override
    protected void onCrafted(IRuneAltarRecipe recipe, int countCraft) {
        int renaming = countCraft;
        for (int slot : this.slotsLivingRock) {
            if (this.inventory.getStackInSlot(slot).m_41619_()) continue;
            int extractCount = Math.min(renaming, countCraft);
            ItemStack extract = this.inventory.extractItem(slot, extractCount, false);
            if (extract.m_41619_()) break;
            renaming -= extractCount;
        }
    }

    @Override
    protected List<ItemStack> resultItems(IRuneAltarRecipe recipe, @NotNull List<ItemStack> stacks) {
        List<ItemStack> res = Streams.concat((Stream[])new Stream[]{stacks.stream().filter(s -> s.m_204117_(ModTags.Items.RUNES)).map(s -> {
            ItemStack copy = s.m_41777_();
            copy.m_41764_(1);
            return copy;
        }), super.resultItems(recipe, stacks).stream()}).toList();
        return res;
    }

    @Override
    protected int getMaxProgress(@NotNull IRuneAltarRecipe recipe) {
        return recipe.getManaUsage();
    }

    private boolean checkOutputSlots() {
        for (int i = this.FIRST_OUTPUT_SLOT; i < this.LAST_OUTPUT_SLOT + 1; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxManaPerTick() {
        return MAX_MANA_PER_TICK * this.settingPattern.getConfigInt("craftTime");
    }

    public boolean isSlotUsedCurrently(int slot) {
        return this.slotsUsed.contains(slot);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.slotsUsed.clear();
        this.slotsUsed.addAll(Arrays.stream(nbt.m_128465_("slotsUsed")).boxed().toList());
        this.m_6596_();
        this.setDispatchable();
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128408_("slotsUsed", this.slotsUsed);
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.slotsUsed.clear();
            this.slotsUsed.addAll(Arrays.stream(nbt.m_128465_("slotsUsed")).boxed().toList());
        }
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128408_("slotsUsed", this.slotsUsed);
        return nbt;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public void drops() {
        IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected Item getItemFromBlockEntity() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityRunicAltarBase) {
            return ModBlocks.baseRunicAltar.m_5456_();
        }
        if (blockEntity instanceof BlockEntityRunicAltarUpgraded) {
            return ModBlocks.upgradedRunicAltar.m_5456_();
        }
        if (blockEntity instanceof BlockEntityRunicAltarAdvanced) {
            return ModBlocks.advancedRunicAltar.m_5456_();
        }
        return ModBlocks.ultimateRunicAltar.m_5456_();
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getMainNode() != null) {
            this.getMainNode().destroy();
        }
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        return this.getMainNode().getNode();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public void saveChanges() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.m_6596_();
            } else {
                this.f_58857_.m_151543_(this.f_58858_);
                if (!this.setChangedQueued) {
                    TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                    this.setChangedQueued = true;
                }
            }
        }
    }

    private void exportResultsItemsME() {
        for (int slot = this.FIRST_OUTPUT_SLOT; slot <= this.LAST_OUTPUT_SLOT; ++slot) {
            int getCountExport;
            ItemStack stackInSlot = this.inventory.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || (getCountExport = Math.toIntExact(this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stackInSlot), (long)stackInSlot.m_41613_(), Actionable.MODULATE, IActionSource.empty()))) <= 0) continue;
            stackInSlot.m_41774_(getCountExport);
            this.inventory.setStackInSlot(slot, stackInSlot);
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }
}

