/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.client;

import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lmor.botanicalextramachinery.ModEntities;
import net.lmor.botanicalextramachinery.client.EntityRenderers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.integration.ears.EarsIntegration;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.xplat.IXplatAbstractions;

@Mod.EventBusSubscriber(modid="botanicalextramachinery", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeClientInitializer {
    private static final Supplier<Map<EntityType<?>, Function<Entity, IWandHUD>>> ENTITY_WAND_HUD = Suppliers.memoize(() -> {
        IdentityHashMap ret = new IdentityHashMap();
        ModEntities.registerWandHudCaps((factory, types) -> {
            for (EntityType type : types) {
                ret.put(type, factory);
            }
        });
        return Collections.unmodifiableMap(ret);
    });

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent evt) {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        ClientProxy.initSeasonal();
        bus.addGenericListener(Entity.class, ForgeClientInitializer::attachEntityCapabilities);
        if (IXplatAbstractions.INSTANCE.isModLoaded("ears")) {
            EarsIntegration.register();
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        EntityRenderers.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerEntityRenderer(arg_0, arg_1));
    }

    private static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> e) {
        Entity entity = (Entity)e.getObject();
        Function<Entity, IWandHUD> makeWandHud = ENTITY_WAND_HUD.get().get(entity.m_6095_());
        if (makeWandHud != null) {
            e.addCapability(ResourceLocationHelper.prefix((String)"wand_hud"), CapabilityUtil.makeProvider((Capability)BotaniaForgeClientCapabilities.WAND_HUD, (Object)makeWandHud.apply(entity)));
        }
    }
}

