/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.events;

import java.util.ArrayList;
import java.util.List;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.util.NumberFormatter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="botanicalextramachinery", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipHandler {
    public static final List<Item> tooltipManaAllBlocks = new ArrayList<Item>();
    public static final List<Item> tooltipWaterAllBlocks = new ArrayList<Item>();

    private static void addItem() {
        tooltipManaAllBlocks.add(ModBlocks.baseManaPool.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.upgradedManaPool.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.advancedManaPool.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateManaPool.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.baseRunicAltar.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.upgradedRunicAltar.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.advancedRunicAltar.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateRunicAltar.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.baseIndustrialAgglomerationFactory.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.upgradedIndustrialAgglomerationFactory.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.advancedIndustrialAgglomerationFactory.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateIndustrialAgglomerationFactory.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.baseAlfheimMarket.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateAlfheimMarket.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateAlfheimMarket.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateAlfheimMarket.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.baseOrechid.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateOrechid.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateOrechid.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateOrechid.m_5456_());
        tooltipWaterAllBlocks.add(ModBlocks.baseApothecary.m_5456_());
        tooltipWaterAllBlocks.add(ModBlocks.upgradedApothecary.m_5456_());
        tooltipWaterAllBlocks.add(ModBlocks.advancedApothecary.m_5456_());
        tooltipWaterAllBlocks.add(ModBlocks.ultimateApothecary.m_5456_());
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack;
        if (tooltipManaAllBlocks.size() == 0) {
            TooltipHandler.addItem();
        }
        if (!(stack = event.getItemStack()).m_41619_()) {
            CompoundTag tag = stack.m_41783_();
            if (tooltipManaAllBlocks.contains(stack.m_41720_()) && stack.m_41782_()) {
                if (tag.m_128469_("BlockEntityTag").m_128441_("mana")) {
                    int mana = tag.m_128469_("BlockEntityTag").m_128451_("mana");
                    event.getToolTip().add(new TranslatableComponent("botanicalextramachinery.tooltip.item.mana", new Object[]{NumberFormatter.formatInteger(mana)}));
                }
            } else if (tooltipWaterAllBlocks.contains(stack.m_41720_()) && stack.m_41782_() && tag.m_128469_("BlockEntityTag").m_128441_("fluid")) {
                int water = tag.m_128469_("BlockEntityTag").m_128469_("fluid").m_128451_("Amount");
                event.getToolTip().add(new TranslatableComponent("botanicalextramachinery.tooltip.item.water", new Object[]{NumberFormatter.formatIntegerWater(water)}));
            }
        }
        if (stack.m_41720_().m_5456_() == ModItems.catalystSpeed.m_5456_()) {
            event.getToolTip().add(new TranslatableComponent("botanicalextramachinery.tooltip.item.upgrade_speed_1"));
            event.getToolTip().add(new TranslatableComponent("botanicalextramachinery.tooltip.item.upgrade_speed_2"));
        }
    }
}

