/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.lmor.botanicalextramachinery.core.LibResources;
import net.lmor.botanicalextramachinery.util.NumberFormatter;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class WaterBar {
    private final Screen parent;
    public static int x;
    public static int y;
    public final int capacity;
    private static int width;
    private static int height;
    public int guiLeft;
    public int guiTop;

    public WaterBar(Screen parent, int capacity, int x, int y) {
        this.parent = parent;
        this.capacity = capacity;
        WaterBar.x = x;
        WaterBar.y = y;
    }

    public void setGuiCoord(int x, int y) {
        this.guiLeft = x;
        this.guiTop = y;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.guiLeft + x < mouseX && mouseX < this.guiLeft + x + width + 2 && this.guiTop + y < mouseY && mouseY < this.guiTop + y + height + 2;
    }

    public void draw(PoseStack poseStack, float fluid) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)LibResources.WATER_BAR_CURRENT);
        float pctFluid = Math.min(fluid / (float)this.capacity, 1.0f);
        int relWidth = (int)(129.0f * pctFluid);
        Screen.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + x), (int)(this.guiTop + y), (float)0.0f, (float)0.0f, (int)relWidth, (int)5, (int)129, (int)5);
    }

    public void renderHoveredToolTip(PoseStack ms, int mouseX, int mouseY, int countFluid) {
        if (this.isMouseOver(mouseX, mouseY) && LibXClientConfig.numericalFluid) {
            TextComponent fluid = new TextComponent(countFluid + " / " + NumberFormatter.formatIntegerWater(this.capacity));
            this.parent.m_96602_(ms, (Component)fluid, mouseX, mouseY);
        }
    }

    static {
        width = 129;
        height = 5;
    }
}

