/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.builtinpacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.cristellib.CristelLib;
import net.cristellib.builtinpacks.UnsafeByteArrayOutputStream;
import net.cristellib.config.ConfigUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimePack
implements PackResources {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    public final int packVersion;
    private final String name;
    private final Lock waiting = new ReentrantLock();
    private final Map<ResourceLocation, Supplier<byte[]>> data = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<String, Supplier<byte[]>> root = new ConcurrentHashMap<String, Supplier<byte[]>>();

    public RuntimePack(String name, int version, @Nullable Path imageFile) {
        byte[] image;
        this.packVersion = version;
        this.name = name;
        if (imageFile != null && (image = RuntimePack.extractImageBytes(imageFile)) != null) {
            this.addRootResource("pack.png", image);
        }
    }

    public byte[] addStructureSet(ResourceLocation identifier, JsonObject set) {
        return this.addDataForJsonLocation("worldgen/structure_set", identifier, set);
    }

    public byte[] addBiome(ResourceLocation identifier, JsonObject biome) {
        return this.addDataForJsonLocation("worldgen/biome", identifier, biome);
    }

    public byte[] addStructure(ResourceLocation identifier, JsonObject structure) {
        return this.addDataForJsonLocation("worldgen/structure", identifier, structure);
    }

    public byte[] addLootTable(ResourceLocation identifier, JsonObject table) {
        return this.addDataForJsonLocation("loot_tables", identifier, table);
    }

    public byte @Nullable [] addDataForJsonLocationFromPath(String prefix, ResourceLocation identifier, String fromSubPath, String fromModID) {
        JsonElement jsonElement = ConfigUtil.getElement(fromModID, fromSubPath);
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            return this.addDataForJsonLocation(prefix, identifier, object);
        }
        return null;
    }

    public byte[] addDataForJsonLocation(String prefix, ResourceLocation identifier, JsonObject object) {
        return this.addAndSerializeDataForLocation(prefix, "json", identifier, object);
    }

    public byte[] addAndSerializeDataForLocation(String prefix, String end, ResourceLocation identifier, JsonObject object) {
        return this.addData(new ResourceLocation(identifier.m_135827_(), prefix + "/" + identifier.m_135815_() + "." + end), RuntimePack.serializeJson(object));
    }

    public byte[] addData(ResourceLocation path, byte[] data) {
        this.data.put(path, () -> data);
        return data;
    }

    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(path, () -> data);
        return data;
    }

    public static byte @Nullable [] extractImageBytes(Path imageName) {
        try {
            InputStream stream = Files.newInputStream(imageName.toAbsolutePath(), new OpenOption[0]);
            BufferedImage bufferedImage = ImageIO.read(stream);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            CristelLib.LOGGER.warn("Couldn't get image for path: " + imageName, (Throwable)e);
            return null;
        }
    }

    public static byte[] serializeJson(JsonObject object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos, StandardCharsets.UTF_8);
        GSON.toJson((JsonElement)object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    public void dumpDirect(Path output) {
        CristelLib.LOGGER.info("dumping " + this.name + "'s assets and data");
        try {
            for (Map.Entry<String, Supplier<byte[]>> e : this.root.entrySet()) {
                Path root = output.resolve(e.getKey());
                Files.createDirectories(root.getParent(), new FileAttribute[0]);
                Files.write(root, e.getValue().get(), new OpenOption[0]);
            }
            Path data = output.resolve("data");
            Files.createDirectories(data, new FileAttribute[0]);
            for (Map.Entry<ResourceLocation, Supplier<byte[]>> entry : this.data.entrySet()) {
                this.write(data, entry.getKey(), entry.getValue().get());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nullable
    public InputStream m_5542_(String fileName) {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            this.lock();
            Supplier<byte[]> supplier = this.root.get(fileName);
            if (supplier == null) {
                this.waiting.unlock();
                return null;
            }
            this.waiting.unlock();
            return new ByteArrayInputStream(supplier.get());
        }
        throw new IllegalArgumentException("File name can't be a path");
    }

    public InputStream m_8031_(PackType packType, @NotNull ResourceLocation id) {
        if (packType.equals((Object)PackType.CLIENT_RESOURCES)) {
            return null;
        }
        this.lock();
        Supplier<byte[]> supplier = this.data.get(id);
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return new ByteArrayInputStream(supplier.get());
    }

    @Nullable
    public JsonObject getResource(ResourceLocation location) {
        InputStream stream = this.m_8031_(PackType.SERVER_DATA, location);
        return GsonHelper.m_13859_((Reader)new BufferedReader(new InputStreamReader(stream)));
    }

    public Collection<ResourceLocation> m_7466_(PackType packType, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        HashSet<ResourceLocation> resourceLocations = new HashSet<ResourceLocation>();
        if (packType.equals((Object)PackType.CLIENT_RESOURCES)) {
            return resourceLocations;
        }
        this.lock();
        for (ResourceLocation ResourceLocation2 : this.data.keySet()) {
            if (!ResourceLocation2.m_135827_().equals(namespace) || !ResourceLocation2.m_135815_().startsWith(prefix) || !pathFilter.test(ResourceLocation2.m_135815_())) continue;
            resourceLocations.add(ResourceLocation2);
        }
        this.waiting.unlock();
        return resourceLocations;
    }

    public boolean m_7211_(PackType packType, ResourceLocation id) {
        if (packType.equals((Object)PackType.CLIENT_RESOURCES)) {
            return false;
        }
        this.lock();
        boolean contains = this.data.containsKey(id);
        this.waiting.unlock();
        return contains;
    }

    public Set<String> m_5698_(PackType packType) {
        HashSet<String> namespaces = new HashSet<String>();
        if (packType.equals((Object)PackType.CLIENT_RESOURCES)) {
            return namespaces;
        }
        this.lock();
        for (ResourceLocation ResourceLocation2 : this.data.keySet()) {
            namespaces.add(ResourceLocation2.m_135827_());
        }
        this.waiting.unlock();
        return namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        if (metaReader.m_7991_().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)this.packVersion);
            object.addProperty("description", this.name);
            return (T)metaReader.m_6322_(object);
        }
        return (T)metaReader.m_6322_(new JsonObject());
    }

    public String m_8017_() {
        return this.name;
    }

    public void close() {
        CristelLib.LOGGER.debug("Closing RDP: " + this.name);
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            this.waiting.lock();
        }
    }

    private void write(Path dir, ResourceLocation ResourceLocation2, byte[] data) {
        try {
            Path file = dir.resolve(ResourceLocation2.m_135827_()).resolve(ResourceLocation2.m_135815_());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

