/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.config;

import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.cristellib.CristelLib;
import net.cristellib.CristelLibExpectPlatform;
import net.cristellib.StructureConfig;
import net.cristellib.config.Placement;
import net.cristellib.shadow.blue.endless.jankson.Jankson;
import net.cristellib.shadow.blue.endless.jankson.JsonArray;
import net.cristellib.shadow.blue.endless.jankson.JsonElement;
import net.cristellib.shadow.blue.endless.jankson.JsonGrammar;
import net.cristellib.shadow.blue.endless.jankson.JsonObject;
import net.cristellib.shadow.blue.endless.jankson.JsonPrimitive;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ConfigUtil {
    public static final Path CONFIG_DIR = CristelLibExpectPlatform.getConfigDirectory();
    public static final Path CONFIG_LIB = CONFIG_DIR.resolve("cristellib");
    public static final Jankson JANKSON = Jankson.builder().build();
    public static final Supplier<JsonGrammar.Builder> JSON_GRAMMAR_BUILDER = () -> new JsonGrammar.Builder().withComments(true).bareSpecialNumerics(true).printCommas(true);
    public static final JsonGrammar JSON_GRAMMAR = JSON_GRAMMAR_BUILDER.get().build();

    public static void createConfig(StructureConfig config) {
        Path path = config.getPath();
        if (path.toFile().exists()) {
            return;
        }
        Map<ResourceLocation, List<String>> sets = config.getStructures();
        JsonObject object = new JsonObject();
        JsonPrimitive jsonBoolean = JsonPrimitive.of(true);
        for (ResourceLocation location : sets.keySet()) {
            JsonObject inObjectObject = new JsonObject();
            HashMap<String, JsonObject> l = new HashMap<String, JsonObject>();
            for (String s : sets.get(location)) {
                String sWN = s.split(":")[1];
                if (sWN.contains("/")) {
                    String key = sWN.split("/")[0];
                    String value = sWN.split("/")[1];
                    if (!l.containsKey(key)) {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.put(value, jsonBoolean);
                        l.put(key, jsonObject);
                        continue;
                    }
                    ((JsonObject)l.get(key)).put(value, jsonBoolean);
                    continue;
                }
                inObjectObject.put(sWN, jsonBoolean);
            }
            for (String s : l.keySet()) {
                inObjectObject.put(s, (JsonElement)l.get(s));
            }
            object.put(location.toString().split(":")[1], inObjectObject);
        }
        ConfigUtil.addComments(config.getComments(), object, "");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String output = config.getHeader() + "\n" + object.toJson(JSON_GRAMMAR);
            Files.write(path, output.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            CristelLib.LOGGER.error("Couldn't create Enable Disable Config for Path {}", (Object)path, (Object)e);
        }
    }

    public static void createPlacementConfig(StructureConfig config) {
        Path path = config.getPath();
        if (path.toFile().exists()) {
            return;
        }
        Map<ResourceLocation, Placement> sets = config.getStructurePlacement();
        JsonObject object = new JsonObject();
        for (ResourceLocation location : sets.keySet()) {
            JsonObject object1;
            JsonElement element = JANKSON.toJson(sets.get(location));
            if (element instanceof JsonObject && (object1 = (JsonObject)element).getDouble("frequency", 0.0) == 0.0) {
                object1.remove("frequency");
            }
            object.put(location.toString().split(":")[1], element);
        }
        ConfigUtil.addComments(config.getComments(), object, "");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String output = config.getHeader() + "\n" + object.toJson(JSON_GRAMMAR);
            Files.write(path, output.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            CristelLib.LOGGER.error("Couldn't create Placement Config for Path {}", (Object)path, (Object)e);
        }
    }

    public static Map<String, Placement> readPlacementConfig(Path path) {
        try {
            JsonObject load = JANKSON.load(path.toFile());
            return ConfigUtil.stringPlacementMap(load);
        }
        catch (Exception errorMsg) {
            throw new IllegalArgumentException("Couldn't read " + path + ", crashing instead. Maybe try to delete the config files!");
        }
    }

    public static Map<String, Placement> stringPlacementMap(JsonObject object) {
        HashMap<String, Placement> map = new HashMap<String, Placement>();
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            JsonElement jsonElement = entry.getValue();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)jsonElement;
            map.put(entry.getKey(), JANKSON.fromJson(jsonObject, Placement.class));
        }
        return map;
    }

    public static Map<String, Boolean> readConfig(Path path) {
        try {
            JsonObject load = JANKSON.load(path.toFile());
            return ConfigUtil.newStringBooleanMap(load);
        }
        catch (Exception errorMsg) {
            throw new IllegalArgumentException("Couldn't read " + path + ", crashing instead. Maybe try to delete the config files!");
        }
    }

    public static Map<String, Boolean> stringBooleanMap(JsonObject object, String parent) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            JsonPrimitive primitive;
            Object object2;
            String key = parent.equals("") ? entry.getKey() : parent + "/" + entry.getKey();
            JsonElement e = entry.getValue();
            if (e instanceof JsonPrimitive && (object2 = (primitive = (JsonPrimitive)e).getValue()) instanceof Boolean) {
                Boolean bool = (Boolean)object2;
                map.put(key, bool);
                continue;
            }
            if (!(e instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)e;
            map.putAll(ConfigUtil.stringBooleanMap(jsonObject, entry.getKey()));
        }
        return map;
    }

    public static Map<String, Boolean> newStringBooleanMap(JsonObject object) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            JsonElement e = entry.getValue();
            if (!(e instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)e;
            map.putAll(ConfigUtil.stringBooleanMap(jsonObject, ""));
        }
        return map;
    }

    @Nullable
    public static com.google.gson.JsonElement getSetElement(String getDataFromModId, ResourceLocation location) {
        return ConfigUtil.getElement(getDataFromModId, "data/" + location.m_135827_() + "/worldgen/structure_set/" + location.m_135815_() + ".json");
    }

    @Nullable
    public static com.google.gson.JsonElement getElement(String getDataFromModId, String location) {
        com.google.gson.JsonElement jsonElement;
        InputStream im;
        Path pathC = CristelLibExpectPlatform.getResourceDirectory(getDataFromModId, location);
        if (pathC == null) {
            return null;
        }
        try {
            im = Files.newInputStream(pathC, new OpenOption[0]);
        }
        catch (IOException e) {
            CristelLib.LOGGER.warn("Couldn't create Input Stream for Path " + pathC, (Throwable)e);
            return null;
        }
        InputStreamReader reader = new InputStreamReader(im);
        try {
            jsonElement = JsonParser.parseReader((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                CristelLib.LOGGER.warn("Couldn't read " + location + " from mod: " + getDataFromModId, (Throwable)e);
                return null;
            }
        }
        reader.close();
        return jsonElement;
    }

    public static JsonObject addComments(Map<String, String> comments, JsonObject object, String parentKey) {
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            JsonElement value;
            String objectKey = entry.getKey();
            String commentsKey = parentKey + objectKey;
            String comment = object.getComment(entry.getKey());
            if (comments.containsKey(commentsKey) && comment == null) {
                String commentToAdd = comments.get(commentsKey);
                object.setComment(objectKey, commentToAdd);
                comment = commentToAdd;
            }
            if ((value = entry.getValue()) instanceof JsonArray) {
                JsonArray array = (JsonArray)value;
                JsonArray sortedJsonElements = new JsonArray();
                for (JsonElement element : array) {
                    if (element instanceof JsonObject) {
                        JsonObject nestedObject = (JsonObject)element;
                        sortedJsonElements.add(ConfigUtil.addComments(comments, nestedObject, entry.getKey() + "."));
                        continue;
                    }
                    if (!(element instanceof JsonArray)) continue;
                    JsonArray array1 = (JsonArray)element;
                    JsonArray arrayOfArrays = new JsonArray();
                    arrayOfArrays.addAll(array1);
                    sortedJsonElements.add(arrayOfArrays);
                }
                if (!sortedJsonElements.isEmpty()) {
                    object.put(objectKey, sortedJsonElements, comment);
                }
            }
            if (!(value instanceof JsonObject)) continue;
            JsonObject nestedObject = (JsonObject)value;
            object.put(objectKey, ConfigUtil.addComments(comments, nestedObject, entry.getKey() + "."), comment);
        }
        return object;
    }
}

