/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.forge.extrapackutil;

import com.google.common.base.Charsets;
import com.mojang.bridge.game.GameVersion;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.cristellib.CristelLibExpectPlatform;
import net.minecraft.ResourceLocationException;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModResourcePack
extends AbstractPackResources {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModResourcePack.class);
    private static final Pattern RESOURCE_PACK_PATH = Pattern.compile("[a-z0-9-_.]+");
    private static final FileSystem DEFAULT_FS = FileSystems.getDefault();
    private final String name;
    private final IModInfo modInfo;
    private final List<Path> basePaths;
    private final AutoCloseable closer;
    private final Map<PackType, Set<String>> namespaces;
    private static final String resPrefix = PackType.CLIENT_RESOURCES.m_10305_() + "/";
    private static final String dataPrefix = PackType.SERVER_DATA.m_10305_() + "/";

    public static ModResourcePack create(String name, IModInfo mod, String subPath) {
        List<Path> paths;
        List<Path> rootPaths = CristelLibExpectPlatform.getRootPaths(mod.getModId());
        if (subPath == null) {
            paths = rootPaths;
        } else {
            paths = new ArrayList<Path>(rootPaths.size());
            for (Path path : rootPaths) {
                Path childPath = (path = path.toAbsolutePath().normalize()).resolve(subPath.replace("/", path.getFileSystem().getSeparator())).normalize();
                if (!childPath.startsWith(path) || !ModResourcePack.exists(childPath)) continue;
                paths.add(childPath);
            }
        }
        if (paths.isEmpty()) {
            return null;
        }
        ModResourcePack ret = new ModResourcePack(name, mod, paths, null);
        return ret.m_5698_(PackType.SERVER_DATA).isEmpty() ? null : ret;
    }

    private ModResourcePack(String name, IModInfo modInfo, List<Path> paths, AutoCloseable closer) {
        super(null);
        this.name = name;
        this.modInfo = modInfo;
        this.basePaths = paths;
        this.closer = closer;
        this.namespaces = ModResourcePack.readNamespaces(paths, modInfo.getModId());
    }

    private static Map<PackType, Set<String>> readNamespaces(List<Path> paths, String modId) {
        EnumMap<PackType, Set<String>> ret = new EnumMap<PackType, Set<String>>(PackType.class);
        for (PackType type : PackType.values()) {
            Set namespaces = null;
            for (Path path : paths) {
                Path dir = path.resolve(type.m_10305_());
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                String separator = path.getFileSystem().getSeparator();
                try {
                    DirectoryStream<Path> ds = Files.newDirectoryStream(dir);
                    try {
                        for (Path p : ds) {
                            if (!Files.isDirectory(p, new LinkOption[0])) continue;
                            String s = p.getFileName().toString();
                            if (!RESOURCE_PACK_PATH.matcher(s = s.replace(separator, "")).matches()) {
                                LOGGER.warn("Fabric NioResourcePack: ignored invalid namespace: {} in mod ID {}", (Object)s, (Object)modId);
                                continue;
                            }
                            if (namespaces == null) {
                                namespaces = new HashSet();
                            }
                            namespaces.add(s);
                        }
                    }
                    finally {
                        if (ds == null) continue;
                        ds.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("getNamespaces in mod " + modId + " failed!", (Throwable)e);
                }
            }
            ret.put(type, namespaces != null ? namespaces : Collections.emptySet());
        }
        return ret;
    }

    private Path getPath(String filename) {
        if (this.hasAbsentNs(filename)) {
            return null;
        }
        for (Path basePath : this.basePaths) {
            Path childPath = basePath.resolve(filename.replace("/", basePath.getFileSystem().getSeparator())).toAbsolutePath().normalize();
            if (!childPath.startsWith(basePath) || !ModResourcePack.exists(childPath)) continue;
            return childPath;
        }
        return null;
    }

    private boolean hasAbsentNs(String filename) {
        PackType type;
        int prefixLen;
        if (filename.startsWith(resPrefix)) {
            prefixLen = resPrefix.length();
            type = PackType.CLIENT_RESOURCES;
        } else if (filename.startsWith(dataPrefix)) {
            prefixLen = dataPrefix.length();
            type = PackType.SERVER_DATA;
        } else {
            return false;
        }
        int nsEnd = filename.indexOf(47, prefixLen);
        if (nsEnd < 0) {
            return false;
        }
        return !this.namespaces.get(type).contains(filename.substring(prefixLen, nsEnd));
    }

    protected InputStream m_5541_(String filename) throws IOException {
        Path path = this.getPath(filename);
        if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        InputStream stream = ModResourcePack.openDefault(this.modInfo, filename);
        if (stream != null) {
            return stream;
        }
        throw new FileNotFoundException("\"" + filename + "\" in Fabric mod \"" + this.modInfo.getModId() + "\"");
    }

    protected boolean m_6105_(String filename) {
        if ("pack.mcmeta".equals(filename)) {
            return true;
        }
        Path path = this.getPath(filename);
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }

    public Collection<ResourceLocation> m_7466_(PackType type, final String namespace, String path, int depth, final Predicate<String> predicate) {
        if (type.equals((Object)PackType.CLIENT_RESOURCES) || !this.namespaces.getOrDefault(type, Collections.emptySet()).contains(namespace)) {
            return Collections.emptyList();
        }
        final ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (Path basePath : this.basePaths) {
            final String separator = basePath.getFileSystem().getSeparator();
            final Path nsPath = basePath.resolve(type.m_10305_()).resolve(namespace);
            Path searchPath = nsPath.resolve(path.replace("/", separator)).normalize();
            if (!ModResourcePack.exists(searchPath)) continue;
            try {
                Files.walkFileTree(searchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String fileName = file.getFileName().toString();
                        if (!fileName.endsWith(".mcmeta") && predicate.test(fileName)) {
                            try {
                                ids.add(new ResourceLocation(namespace, nsPath.relativize(file).toString().replace(separator, "/")));
                            }
                            catch (ResourceLocationException e) {
                                LOGGER.error(e.getMessage());
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("findResources at " + path + " in namespace " + namespace + ", mod " + this.modInfo.getModId() + " failed!", (Throwable)e);
            }
        }
        return ids;
    }

    public Set<String> m_5698_(PackType type) {
        return this.namespaces.getOrDefault(type, Collections.emptySet());
    }

    public void close() {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String m_8017_() {
        return this.name;
    }

    private static boolean exists(Path path) {
        return path.getFileSystem() == DEFAULT_FS ? path.toFile().exists() : Files.exists(path, new LinkOption[0]);
    }

    public static InputStream openDefault(IModInfo info, String filename) {
        switch (filename) {
            case "pack.mcmeta": {
                String description = info.getDisplayName();
                description = description == null ? "" : description.replaceAll("\"", "\\\"");
                String pack = String.format("{\"pack\":{\"pack_format\":" + PackType.SERVER_DATA.m_143756_((GameVersion)SharedConstants.m_183709_()) + ",\"description\":\"%s\"}}", description);
                return IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }
}

