/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.skinfighters.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.radimous.skinfighters.Config;
import com.radimous.skinfighters.RemoteNames;
import com.radimous.skinfighters.SkinFighters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class SFCommands {
    public SFCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skinfighters").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(player -> player.m_6761_(2))).then((CommandNode)((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(this::addSkin)).build()))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(player -> player.m_6761_(2))).then((CommandNode)((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(this::removeSkin)).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])Objects.requireNonNull(this.getSkinArr()), (SuggestionsBuilder)builder)).build()))).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"removeAll").requires(player -> player.m_6761_(2))).executes(this::removeAllSkins)).build())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"chance").requires(player -> player.m_6761_(2))).then((CommandNode)((RequiredArgumentBuilder)Commands.m_82129_((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::changeChance)).build()))).then((CommandNode)((LiteralArgumentBuilder)Commands.m_82127_((String)"info").executes(this::printInfo)).build())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"source").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"source", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(() -> Arrays.stream(SkinFighters.source.values()).map(Enum::name).iterator(), (SuggestionsBuilder)builder)).executes(this::setSource)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skinsFromURL").requires(player -> player.m_6761_(2))).then((CommandNode)((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").executes(this::reloadRemoteNames)).build())).then((CommandNode)((LiteralArgumentBuilder)Commands.m_82127_((String)"getURL").executes(this::getURL)).build())).then((CommandNode)((LiteralArgumentBuilder)Commands.m_82127_((String)"removeAll").executes(this::removeURLSkins)).build())).then(Commands.m_82127_((String)"setUrl").then((CommandNode)((RequiredArgumentBuilder)Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(this::setURL)).build()))));
    }

    private String[] getSkinArr() {
        if (Config.NAMES.get() != null) {
            return ((List)Config.NAMES.get()).toArray(new String[0]);
        }
        return new String[0];
    }

    private int addSkin(CommandContext<CommandSourceStack> command) {
        String name = StringArgumentType.getString(command, (String)"name");
        if (name.length() > 32) {
            ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent("Skin name is too long"));
            return 1;
        }
        List newSkinList = (List)Config.NAMES.get();
        newSkinList.add(name);
        Config.NAMES.set((Object)newSkinList);
        Config.NAMES.save();
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("Skin \"" + name + "\" added successfully"), true);
        return 0;
    }

    private int removeSkin(CommandContext<CommandSourceStack> command) {
        String name = StringArgumentType.getString(command, (String)"name");
        List newSkinList = (List)Config.NAMES.get();
        if (!newSkinList.remove(name)) {
            ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent("Skin \"" + name + "\" couldn't be removed"));
            return 1;
        }
        Config.NAMES.set((Object)newSkinList);
        Config.NAMES.save();
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("Skin \"" + name + "\" removed successfully"), true);
        return 0;
    }

    private int removeAllSkins(CommandContext<CommandSourceStack> command) {
        Config.NAMES.set(new ArrayList());
        Config.NAMES.save();
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("All skins were removed"), true);
        return 0;
    }

    private int removeURLSkins(CommandContext<CommandSourceStack> command) {
        RemoteNames.removeRemoteNames();
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("All skins from URL were removed"), true);
        return 0;
    }

    private int printInfo(CommandContext<CommandSourceStack> command) {
        List<? extends String> names = SkinFighters.getNames();
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("Getting skins from " + ((SkinFighters.source)((Object)Config.SOURCE.get())).name() + " \nThere is " + Config.SKIN_CHANCE.get() + "% chance to spawn fighter with one of those skins: \n" + (names.size() >= 10000 ? "[skin list is too long to display (" + names.size() + " skins)]" : names)).m_130940_(ChatFormatting.GRAY), false);
        return 0;
    }

    private int changeChance(CommandContext<CommandSourceStack> command) {
        Integer chance = IntegerArgumentType.getInteger(command, (String)"chance");
        Config.SKIN_CHANCE.set((Object)chance);
        Config.SKIN_CHANCE.save();
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("Chance to spawn fighter with skin changed to " + chance + "%"), true);
        return 0;
    }

    private int setSource(CommandContext<CommandSourceStack> command) {
        String strSource = StringArgumentType.getString(command, (String)"source");
        SkinFighters.source source2 = SkinFighters.source.valueOf(strSource);
        Config.SOURCE.set((Object)source2);
        Config.SOURCE.save();
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("Skin name source changed to " + strSource), true);
        return 0;
    }

    private int reloadRemoteNames(CommandContext<CommandSourceStack> command) {
        boolean invalidUsername;
        try {
            invalidUsername = RemoteNames.reloadRemoteNames();
        }
        catch (IOException e) {
            ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent("Fetching names from url failed, more info in log"));
            SkinFighters.logger.error("Fetching names from \"" + (String)Config.NAME_URL.get() + "\" failed. IOException: " + e);
            return 1;
        }
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("Successfully reloaded skins from url, received " + RemoteNames.getRemoteNames().size() + " skin" + (RemoteNames.getRemoteNames().size() == 1 ? "" : "s")), true);
        if (invalidUsername) {
            ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("At least 1 skin name was invalid, make sure your url is correct").m_130940_(ChatFormatting.RED), true);
        }
        return 0;
    }

    private int getURL(CommandContext<CommandSourceStack> command) {
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("Current url: \"" + (String)Config.NAME_URL.get() + "\""), false);
        return 0;
    }

    private int setURL(CommandContext<CommandSourceStack> command) {
        String url = StringArgumentType.getString(command, (String)"url");
        Config.NAME_URL.set((Object)url);
        Config.NAME_URL.save();
        ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent("Successfully changed the url to \"" + url + "\""), true);
        this.reloadRemoteNames(command);
        return 0;
    }
}

