/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.blockentity;

import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.IMPBaseEntityBlockEntity;
import dev.felnull.imp.blockentity.IMPBlockEntities;
import dev.felnull.imp.inventory.CassetteDeckMenu;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.imp.util.IMPNbtUtil;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassetteDeckBlockEntity
extends IMPBaseEntityBlockEntity
implements IMusicRinger {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final Map<UUID, UUID> playerSelectPlaylists = new HashMap<UUID, UUID>();
    private UUID myPlayerSelectPlaylist;
    private Music music = null;
    private MonitorType monitor = MonitorType.OFF;
    private ItemStack oldCassetteTape = ItemStack.f_41583_;
    private final UUID ringerUUID = UUID.randomUUID();
    private boolean changeCassetteTape;
    private boolean lidOpen;
    private int lidOpenProgressOld;
    private int lidOpenProgress;
    private int cassetteWriteProgress;
    private int volume = 150;
    private boolean mute;
    private boolean playing;
    private long position;
    private boolean loop;
    private boolean loadingMusic;

    public CassetteDeckBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)IMPBlockEntities.CASSETTE_DECK.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, CassetteDeckBlockEntity blockEntity) {
        blockEntity.lidOpenProgressOld = blockEntity.lidOpenProgress;
        if (blockEntity.lidOpen) {
            if (blockEntity.lidOpenProgress < blockEntity.getLidOpenProgressAll()) {
                ++blockEntity.lidOpenProgress;
            }
        } else if (blockEntity.lidOpenProgress > 0) {
            --blockEntity.lidOpenProgress;
        }
        if (!level.m_5776_()) {
            if (blockEntity.isPowered()) {
                if (blockEntity.monitor == MonitorType.OFF) {
                    blockEntity.setMonitor(MonitorType.MENU);
                }
            } else if (blockEntity.monitor != MonitorType.OFF) {
                blockEntity.setMonitor(MonitorType.OFF);
            }
            if ((blockEntity.getMusic() == null || blockEntity.getCassetteTape().m_41619_() || IMPItemUtil.isAntenna(blockEntity.getCassetteTape())) && blockEntity.monitor == MonitorType.WRITE_EXECUTION) {
                blockEntity.setMonitor(MonitorType.WRITE);
            }
            if (blockEntity.monitor == MonitorType.WRITE_EXECUTION) {
                if (blockEntity.getCassetteWriteProgress() >= blockEntity.getCassetteWriteProgressAll()) {
                    blockEntity.writeCassetteTape();
                    blockEntity.setMonitor(MonitorType.WRITE);
                    blockEntity.setCassetteWriteProgress(0);
                } else {
                    blockEntity.setCassetteWriteProgress(blockEntity.getCassetteWriteProgress() + 1);
                }
            } else if (blockEntity.getCassetteWriteProgress() != 0) {
                blockEntity.setCassetteWriteProgress(0);
            }
            if (blockEntity.monitor != MonitorType.PLAYBACK || !blockEntity.hasMusicCassetteTape()) {
                blockEntity.setRingerPosition(0L);
                if (blockEntity.isPlaying()) {
                    blockEntity.setPlaying(false);
                }
            }
            if (blockEntity.changeCassetteTape) {
                if (!blockEntity.isLidOpen()) {
                    blockEntity.startLidOpen(true);
                }
                if (blockEntity.lidOpenProgress >= blockEntity.getLidOpenProgressAll()) {
                    blockEntity.changeCassetteTape = false;
                    blockEntity.startLidOpen(false);
                }
            }
            blockEntity.loadingMusic = blockEntity.isRingerWait();
            blockEntity.ringerTick();
            blockEntity.sync();
        }
    }

    private boolean canWriteCassetteTape() {
        return this.getMusic() != null && !this.getCassetteTape().m_41619_() && IMPItemUtil.isCassetteTape(this.getCassetteTape());
    }

    private void writeCassetteTape() {
        if (this.canWriteCassetteTape()) {
            CassetteTapeItem.setMusic(this.getCassetteTape(), this.getMusic());
            this.m_6596_();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lidOpen = tag.m_128471_("LidOpen");
        if (this.lidOpen) {
            this.lidOpenProgress = this.getLidOpenProgressAll();
        }
        this.monitor = MonitorType.getByName(tag.m_128461_("Monitor"));
        IMPNbtUtil.readUUIDMap(tag, "PlayerSelectPlaylists", this.playerSelectPlaylists);
        if (tag.m_128441_("Music")) {
            this.music = (Music)OENbtUtil.readSerializable((CompoundTag)tag, (String)"Music", (ITAGSerializable)new Music());
        }
        this.cassetteWriteProgress = tag.m_128451_("CassetteWriteProgress");
        this.volume = tag.m_128451_("Volume");
        this.mute = tag.m_128471_("Mute");
        this.playing = tag.m_128471_("Playing");
        this.position = tag.m_128454_("Position");
        this.loop = tag.m_128471_("Loop");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("LidOpen", this.lidOpen);
        tag.m_128359_("Monitor", this.monitor.getName());
        IMPNbtUtil.writeUUIDMap(tag, "PlayerSelectPlaylists", this.playerSelectPlaylists);
        if (this.music != null) {
            OENbtUtil.writeSerializable((CompoundTag)tag, (String)"Music", (ITAGSerializable)this.music);
        }
        tag.m_128405_("CassetteWriteProgress", this.cassetteWriteProgress);
        tag.m_128405_("Volume", this.volume);
        tag.m_128379_("Mute", this.mute);
        tag.m_128379_("Playing", this.playing);
        tag.m_128356_("Position", this.position);
        tag.m_128379_("Loop", this.loop);
        tag.m_128379_("LoadingMusic", this.loadingMusic);
    }

    public CompoundTag getSyncData(ServerPlayer player, CompoundTag tag) {
        tag.m_128379_("LidOpen", this.lidOpen);
        tag.m_128365_("OldCassetteTape", (Tag)this.oldCassetteTape.m_41739_(new CompoundTag()));
        tag.m_128379_("ChangeCassetteTape", this.changeCassetteTape);
        tag.m_128359_("Monitor", this.monitor.getName());
        if (this.playerSelectPlaylists.containsKey(player.m_36316_().getId())) {
            tag.m_128362_("PlayerSelectPlaylist", this.playerSelectPlaylists.get(player.m_36316_().getId()));
        }
        if (this.music != null) {
            OENbtUtil.writeSerializable((CompoundTag)tag, (String)"Music", (ITAGSerializable)this.music);
        }
        tag.m_128405_("CassetteWriteProgress", this.cassetteWriteProgress);
        tag.m_128405_("Volume", this.volume);
        tag.m_128379_("Mute", this.mute);
        tag.m_128379_("Playing", this.playing);
        tag.m_128356_("Position", this.position);
        tag.m_128379_("Loop", this.loop);
        tag.m_128379_("LoadingMusic", this.loadingMusic);
        return super.getSyncData(player, tag);
    }

    public void m_6836_(int i, ItemStack stack) {
        if (i == 0) {
            this.onCassetteTapeChange(stack, this.getCassetteTape());
        }
        this.setItemNoChange(i, stack);
    }

    public void setItemNoChange(int i, ItemStack stack) {
        super.m_6836_(i, stack);
    }

    public boolean isLoadingMusic() {
        return this.loadingMusic;
    }

    public void onSync(CompoundTag tag) {
        super.onSync(tag);
        this.lidOpen = tag.m_128471_("LidOpen");
        this.oldCassetteTape = ItemStack.m_41712_((CompoundTag)tag.m_128469_("OldCassetteTape"));
        this.changeCassetteTape = tag.m_128471_("ChangeCassetteTape");
        this.monitor = MonitorType.getByName(tag.m_128461_("Monitor"));
        if (tag.m_128441_("PlayerSelectPlaylist")) {
            this.myPlayerSelectPlaylist = tag.m_128342_("PlayerSelectPlaylist");
        }
        this.music = tag.m_128441_("Music") ? (Music)OENbtUtil.readSerializable((CompoundTag)tag, (String)"Music", (ITAGSerializable)new Music()) : null;
        this.cassetteWriteProgress = tag.m_128451_("CassetteWriteProgress");
        this.volume = tag.m_128451_("Volume");
        this.mute = tag.m_128471_("Mute");
        this.playing = tag.m_128471_("Playing");
        this.position = tag.m_128454_("Position");
        this.loop = tag.m_128471_("Loop");
        this.loadingMusic = tag.m_128471_("LoadingMusic");
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        this.m_6596_();
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
        this.m_6596_();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
        this.m_6596_();
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        this.m_6596_();
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        if (this.volume != volume) {
            this.setMute(false);
        }
        this.volume = Mth.m_14045_((int)volume, (int)0, (int)300);
        this.m_6596_();
    }

    public UUID getMyPlayerSelectPlaylist() {
        return this.myPlayerSelectPlaylist;
    }

    public void setPlayerSelectPlayList(ServerPlayer player, UUID uuid) {
        if (uuid != null) {
            this.playerSelectPlaylists.put(player.m_36316_().getId(), uuid);
        } else {
            this.playerSelectPlaylists.remove(player.m_36316_().getId());
        }
        this.m_6596_();
    }

    public int getCassetteWriteProgress() {
        return this.cassetteWriteProgress;
    }

    public void setCassetteWriteProgress(int cassetteWriteProgress) {
        this.cassetteWriteProgress = cassetteWriteProgress;
        if (!this.getCassetteTape().m_41619_() && IMPItemUtil.isCassetteTape(this.getCassetteTape())) {
            CassetteTapeItem.setTapePercentage(this.getCassetteTape(), (float)cassetteWriteProgress / (float)this.getCassetteWriteProgressAll());
        }
        this.m_6596_();
    }

    public int getLidOpenProgressAll() {
        return 10;
    }

    public MonitorType getMonitor() {
        return this.monitor;
    }

    public float getLidOpenProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lidOpenProgressOld, (float)this.lidOpenProgress);
    }

    public void startLidOpen(boolean open) {
        this.setLidOpen(open);
        this.f_58857_.m_5594_(null, this.m_58899_(), this.isLidOpen() ? SoundEvents.f_12627_ : SoundEvents.f_12626_, SoundSource.BLOCKS, 0.5f, 0.4f / (this.f_58857_.m_5822_().nextFloat() * 0.4f + 0.8f));
    }

    public void setLidOpen(boolean lidOpen) {
        this.lidOpen = lidOpen;
        this.m_6596_();
    }

    public boolean isLidOpen() {
        return this.lidOpen;
    }

    public boolean isChangeCassetteTape() {
        return this.changeCassetteTape;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected Component m_6820_() {
        return ((Block)IMPBlocks.CASSETTE_DECK.get()).m_49954_();
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new CassetteDeckMenu(i, inventory, this.m_58899_(), (Container)this);
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        if (i == 0) {
            return IMPItemUtil.isCassetteTape(itemStack);
        }
        return super.m_7013_(i, itemStack);
    }

    public Music getMusic() {
        return this.music;
    }

    public ItemStack getCassetteTape() {
        return this.m_8020_(0);
    }

    public ItemStack getOldCassetteTape() {
        return this.oldCassetteTape;
    }

    protected void onCassetteTapeChange(ItemStack newItem, ItemStack oldItem) {
        if (this.monitor == MonitorType.WRITE_EXECUTION) {
            this.setMonitor(MonitorType.WRITE);
        }
        this.setRingerPosition(0L);
        this.setPlaying(false);
        this.oldCassetteTape = oldItem;
        this.changeCassetteTape = true;
    }

    public void setMusic(Music music) {
        this.music = music;
        this.m_6596_();
    }

    public int getCassetteWriteProgressAll() {
        return 200;
    }

    public void setMonitor(MonitorType monitor) {
        this.monitor = monitor;
        this.m_6596_();
    }

    @Override
    public CompoundTag onInstruction(ServerPlayer player, String name, int num, CompoundTag data) {
        if ("monitor".equals(name)) {
            this.monitor = MonitorType.getByName(data.m_128461_("name"));
            if (this.monitor == MonitorType.WRITE_EXECUTION && this.canWriteCassetteTape()) {
                IMPCriteriaTriggers.WRITE_CASSETTE_TAPE.trigger(player, this.getCassetteTape());
            }
            return null;
        }
        if ("select_playlist".equals(name)) {
            if (data.m_128441_("uuid")) {
                UUID uuid = data.m_128342_("uuid");
                MusicPlayList pl = MusicManager.getInstance().getSaveData().getPlayLists().get(uuid);
                if (pl != null && pl.getAuthority().getAuthorityType(player.m_36316_().getId()).isMoreReadOnly()) {
                    this.setPlayerSelectPlayList(player, uuid);
                }
            } else {
                this.setPlayerSelectPlayList(player, null);
            }
            return null;
        }
        if ("set_music".equals(name)) {
            MusicPlayList pl;
            MusicManager mm;
            Music m;
            if (data.m_128441_("music") && (m = (mm = MusicManager.getInstance()).getSaveData().getMusics().get(data.m_128342_("music"))) != null && (pl = mm.getPlaylistByMusic(m.getUuid())) != null && pl.getAuthority().getAuthorityType(player.m_36316_().getId()).isMoreReadOnly()) {
                this.setMusic(m);
            }
            return null;
        }
        if ("set_volume".equals(name)) {
            if (this.isPowered()) {
                this.setVolume(data.m_128451_("volume"));
            }
        } else if ("set_mute".equals(name)) {
            if (this.isPowered()) {
                this.setMute(data.m_128471_("mute"));
            }
        } else if ("set_playing".equals(name)) {
            if (this.isPowered()) {
                boolean pl = data.m_128471_("playing");
                this.setPlaying(pl);
                if (!pl) {
                    this.setRingerPosition(0L);
                }
            }
        } else if ("set_pause".equals(name)) {
            if (this.isPowered()) {
                this.setPlaying(false);
            }
        } else {
            if ("restat_and_set_position".equals(name)) {
                if (this.isPowered()) {
                    this.setMusicPositionAndRestart(data.m_128454_("position"));
                }
                return null;
            }
            if ("set_loop".equals(name) && this.isPowered()) {
                this.setLoop(data.m_128471_("loop"));
            }
        }
        return super.onInstruction(player, name, num, data);
    }

    public void setMusicPositionAndRestart(long position) {
        this.setRingerPosition(position);
        this.ringerRestart();
    }

    @Override
    public Component getRingerName() {
        return this.m_6820_();
    }

    @Override
    public ServerLevel getRingerLevel() {
        return (ServerLevel)this.f_58857_;
    }

    @Override
    public UUID getRingerUUID() {
        return this.ringerUUID;
    }

    @Override
    public boolean exists() {
        if (this.m_58904_() == null || this.f_58857_ != this.m_58904_()) {
            return false;
        }
        return this.m_58899_() != null && this.f_58857_.m_7702_(this.m_58899_()) == this;
    }

    @Override
    public boolean isRingerPlaying() {
        return this.isPlaying();
    }

    @Override
    public void setRingerPlaying(boolean playing) {
        this.setPlaying(playing);
    }

    private boolean hasCassetteTape() {
        return !this.getCassetteTape().m_41619_() && IMPItemUtil.isCassetteTape(this.getCassetteTape());
    }

    private boolean hasMusicCassetteTape() {
        return this.hasCassetteTape() && CassetteTapeItem.getMusic(this.getCassetteTape()) != null;
    }

    @Override
    @Nullable
    public MusicSource getRingerMusicSource() {
        return this.hasMusicCassetteTape() ? CassetteTapeItem.getMusic(this.getCassetteTape()).getSource() : null;
    }

    @Override
    public boolean isRingerLoop() {
        return this.isLoop();
    }

    @Override
    public long getRingerPosition() {
        return this.getPosition();
    }

    @Override
    public void setRingerPosition(long position) {
        MusicSource m;
        this.setPosition(position);
        if (this.hasMusicCassetteTape() && (m = this.getRingerMusicSource()) != null) {
            ItemStack nc = CassetteTapeItem.setTapePercentage(this.getCassetteTape().m_41777_(), (float)position / (float)m.getDuration());
            this.setItemNoChange(0, nc);
        }
        this.m_6596_();
    }

    @Override
    public MusicTrackerEntry getRingerTracker() {
        return IMPMusicTrackers.createFixedTracker(this.getRingerSpatialPosition(), this.getRingerVolume(), this.getRingerRange());
    }

    @Override
    @NotNull
    public Vec3 getRingerSpatialPosition() {
        return new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
    }

    public float getRawVolume() {
        return (float)this.getVolume() / 300.0f;
    }

    @Override
    public float getRingerVolume() {
        return this.getRawVolume();
    }

    @Override
    public float getRingerRange() {
        return 90.0f * this.getRawVolume();
    }

    @Override
    public boolean isRingerStream() {
        return false;
    }

    @Override
    public boolean isRingerMute() {
        return this.isMute();
    }

    public static enum MonitorType {
        OFF("off"),
        MENU("menu"),
        WRITE("write"),
        PLAYBACK("playback"),
        WRITE_EXECUTION("write_execution");

        private final String name;

        private MonitorType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : MonitorType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return OFF;
        }
    }
}

