/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.PowerButton;
import dev.felnull.imp.client.gui.screen.IMPBaseContainerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.IMPMusicTrackerFactory;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.MusicEntry;
import dev.felnull.imp.inventory.MusicManagerMenu;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MusicManagerScreen
extends IMPBaseContainerScreen<MusicManagerMenu> {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/music_manager/music_manager_base.png");
    private final Map<MusicManagerBlockEntity.MonitorType, MusicManagerMonitor> monitors = new HashMap<MusicManagerBlockEntity.MonitorType, MusicManagerMonitor>();
    private final UUID musicPlayerId = UUID.randomUUID();
    public boolean lastSearch;
    protected MusicManagerMonitor monitor;
    public byte[] musicFileImage;

    public MusicManagerScreen(MusicManagerMenu abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
        this.f_97726_ = 386;
        this.f_97727_ = 227;
        this.bgTextureWidth = 512;
        this.bgTextureHeight = 512;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new PowerButton(this, this.f_97735_ + 368, this.f_97736_ + 4, 12, 12, 386, 0, BG_TEXTURE, this.bgTextureWidth, this.bgTextureHeight));
        this.changeScreenMonitor(this.getBEMonitorType());
        this.insMonitor(this.getBEMonitorType());
    }

    public void insMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (this.monitor != null && this.monitor.getType() != type) {
            this.stopMusic();
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", type.getName());
        this.instruction("set_monitor", 0, tag);
    }

    public void insAddPlayList(UUID playListId) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("playlist", playListId);
        this.instruction("add_playlist", 0, tag);
    }

    private void changeScreenMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (this.monitor != null) {
            if (this.monitor.getType() != MusicManagerBlockEntity.MonitorType.UPLOAD_MUSIC || type != MusicManagerBlockEntity.MonitorType.ADD_MUSIC) {
                this.musicFileImage = null;
            }
            this.monitor.renderables.forEach(n -> {
                if (n instanceof GuiEventListener) {
                    GuiEventListener guiEventListener = (GuiEventListener)n;
                    this.m_169411_(guiEventListener);
                }
            });
            this.monitor.depose();
        }
        if (!this.monitors.containsKey((Object)type)) {
            this.monitors.put(type, MusicManagerMonitor.createdMusicMonitor(type, this));
        }
        this.monitor = this.monitors.get((Object)type);
        this.monitor.init(this.f_97735_, this.f_97736_);
        this.monitor.renderables.forEach(n -> {
            if (n instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)n;
                this.m_142416_((GuiEventListener)widget);
            }
        });
    }

    private MusicManagerBlockEntity.MonitorType getBEMonitorType() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return musicManagerBlockEntity.getMyMonitor((Player)MusicManagerScreen.mc.f_91074_);
        }
        return MusicManagerBlockEntity.MonitorType.OFF;
    }

    public void insImportPlayListMusicCount(int count) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("count", count);
        this.instruction("set_import_playlist_music_count", 0, tag);
    }

    public void insImportPlayListAuthor(String author) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("author", author);
        this.instruction("set_import_playlist_author", 0, tag);
    }

    public void insImportPlayListName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", name);
        this.instruction("set_import_playlist_name", 0, tag);
    }

    public void insImportIdentifier(String identifier) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", identifier);
        this.instruction("set_import_identifier", 0, tag);
    }

    public void insImageURL(String url) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("url", url);
        this.instruction("set_image_url", 0, tag);
    }

    public void insImage(ImageInfo image) {
        CompoundTag tag = new CompoundTag();
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"image", (ITAGSerializable)image);
        this.instruction("set_image", 0, tag);
    }

    public void insCreateName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", name);
        this.instruction("set_create_name", 0, tag);
    }

    public void insPublishing(String publishing) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("publishing", publishing);
        this.instruction("set_publishing", 0, tag);
    }

    public void insInitialAuthority(String initialAuthority) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("initial_authority", initialAuthority);
        this.instruction("set_initial_authority", 0, tag);
    }

    public void insInvitePlayerName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", name);
        this.instruction("set_invite_player_name", 0, tag);
    }

    public void insInvitePlayers(List<UUID> players) {
        CompoundTag tag = new CompoundTag();
        OENbtUtil.writeUUIDList((CompoundTag)tag, (String)"players", players);
        this.instruction("set_invite_players", 0, tag);
    }

    public void insSelectedPlayList(UUID selectedPlayList) {
        CompoundTag tag = new CompoundTag();
        if (selectedPlayList != null) {
            tag.m_128362_("playlist", selectedPlayList);
        }
        this.instruction("set_selected_playlist", 0, tag);
    }

    public void insSelectedMusic(@Nullable UUID selectedMusic) {
        CompoundTag tag = new CompoundTag();
        if (selectedMusic != null) {
            tag.m_128362_("music", selectedMusic);
        }
        this.instruction("set_selected_music", 0, tag);
    }

    public void insSelectedPlayer(@Nullable UUID selectedPlayer) {
        CompoundTag tag = new CompoundTag();
        if (selectedPlayer != null) {
            tag.m_128362_("player", selectedPlayer);
        }
        this.instruction("set_selected_player", 0, tag);
    }

    public void insMusicLoaderType(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", name);
        this.instruction("set_music_loader_type", 0, tag);
    }

    public void insMusicSourceName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", name);
        this.instruction("set_music_source_name", 0, tag);
    }

    public void insMusicSource(MusicSource source) {
        if (source == null) {
            source = MusicSource.EMPTY;
        }
        CompoundTag tag = new CompoundTag();
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"MusicSource", (ITAGSerializable)source);
        this.instruction("set_music_source", 0, tag);
    }

    public void insMusicSearchName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", name);
        this.instruction("set_music_search_name", 0, tag);
    }

    public void insMusicAuthor(String author) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("author", author);
        this.instruction("set_music_author", 0, tag);
    }

    public void onInstructionReturn(String name, int num, CompoundTag data) {
        super.onInstructionReturn(name, num, data);
        if ("add_playlist".equals(name)) {
            if (data.m_128441_("playlist")) {
                this.insSelectedPlayList(data.m_128342_("playlist"));
            }
        } else if ("set_selected_playlist".equals(name)) {
            if (data.m_128441_("playlist")) {
                this.monitor.onUpdateSelectedPlayList(data.m_128342_("playlist"));
            } else {
                this.monitor.onUpdateSelectedPlayList(null);
            }
        }
    }

    protected ResourceLocation getBackGrandTexture() {
        return BG_TEXTURE;
    }

    protected void m_7027_(PoseStack poseStack, int i, int j) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
    }

    protected void m_7286_(PoseStack poseStack, float f, int i, int j) {
        super.m_7286_(poseStack, f, i, j);
        if (this.monitor != null) {
            this.monitor.render(poseStack, f, i, j);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.monitor != null) {
            if (this.getBEMonitorType() != this.monitor.getType()) {
                this.changeScreenMonitor(this.getBEMonitorType());
            }
            this.monitor.tick();
        }
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.monitor != null) {
            this.monitor.depose();
        }
        this.stopMusic();
    }

    public void m_7400_(List<Path> list) {
        if (this.monitor != null) {
            this.monitor.onFilesDrop(list);
        }
    }

    public void playMusic(MusicSource source, long postion) {
        this.stopMusic();
        this.getMusicEngine().loadAndPlay(this.musicPlayerId, source, postion, false);
        this.getMusicEngine().addSpeaker(this.musicPlayerId, this.musicPlayerId, IMPMusicTrackerFactory.linked(IMPMusicTrackers.createPlayerTracker((Player)MusicManagerScreen.mc.f_91074_, 1.0f, 10.0f)));
    }

    public void stopMusic() {
        this.getMusicEngine().stop(this.musicPlayerId);
    }

    public boolean isMusicPlaying() {
        return this.getMusicEngine().isPlaying(this.musicPlayerId);
    }

    public boolean isMusicLoading() {
        return this.getMusicEngine().isLoading(this.musicPlayerId);
    }

    private MusicEngine getMusicEngine() {
        return MusicEngine.getInstance();
    }

    public MusicEntry getMusicPlayer() {
        return this.getMusicEngine().getMusicEntry(this.musicPlayerId);
    }
}

