/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportYoutubePlayListBaseMMMonitor;
import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.client.music.media.IMPMusicMedias;
import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.util.FlagThread;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;

public class ImportYoutubePlayListMusicsMMMonitor
extends ImportYoutubePlayListBaseMMMonitor {
    protected static final Component IMPORTING_TEXT = new TranslatableComponent("imp.text.importing");
    protected static final Component IMPORT_FAILURE_TEXT = new TranslatableComponent("imp.text.importFailure");
    private ImportMusicLoader importMusicLoader;
    private boolean failureImportPlayList;

    public ImportYoutubePlayListMusicsMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        Component ipTx = null;
        if (this.isImporting()) {
            ipTx = IMPORTING_TEXT;
        } else if (this.failureImportPlayList) {
            ipTx = IMPORT_FAILURE_TEXT;
        } else if (this.getImportPlayListMusicCount() > 0) {
            ipTx = new TranslatableComponent("imp.text.importMusicCount", new Object[]{this.getImportPlayListMusicCount()});
        }
        if (ipTx != null) {
            this.drawSmartText(poseStack, ipTx, this.getStartX() + this.width - 95 + 7, this.getStartY() + 184);
        }
    }

    @Override
    protected void onImport() {
        if (this.isImporting()) {
            return;
        }
        String ipl = this.getImportPlayList();
        if (this.getImportPlayListMusicCount() > 0 && !ipl.isEmpty()) {
            this.startImportMusicLoader(ipl);
        }
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.IMPORT_MUSICS_SELECT;
    }

    private boolean isImporting() {
        return this.importMusicLoader != null && this.importMusicLoader.isAlive();
    }

    private void startImportMusicLoader(String id) {
        this.stopImportMusicLoader();
        this.failureImportPlayList = false;
        this.importMusicLoader = new ImportMusicLoader(id);
        this.importMusicLoader.start();
    }

    private void stopImportMusicLoader() {
        if (this.importMusicLoader != null) {
            this.importMusicLoader.stopped();
            this.importMusicLoader = null;
        }
    }

    private class ImportMusicLoader
    extends FlagThread {
        private final String id;

        private ImportMusicLoader(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            if (this.isStopped()) {
                return;
            }
            try {
                ArrayList<Music> musics = new ArrayList<Music>();
                Pair<AudioPlaylist, List<AudioTrack>> pl = LavaPlayerManager.getInstance().loadTracks(this.id);
                if (this.isStopped()) {
                    return;
                }
                if (pl.getLeft() == null) {
                    throw new IllegalStateException("Not PlayList");
                }
                for (AudioTrack track : (List)pl.getRight()) {
                    if (!track.getInfo().isStream) {
                        MusicMediaResult ret = IMPMusicMedias.YOUTUBE.createResult(track);
                        ImportYoutubePlayListBaseMMMonitor.YoutubePlayListEntry en = new ImportYoutubePlayListBaseMMMonitor.YoutubePlayListEntry(ret.name(), ret.author(), ret.source(), ret.imageInfo());
                        Music music = new Music(UUID.randomUUID(), en.name(), en.artist(), en.source(), en.imageInfo(), IIMPSmartRender.mc.f_91074_.m_36316_().getId(), System.currentTimeMillis());
                        musics.add(music);
                    }
                    if (!this.isStopped()) continue;
                    return;
                }
                if (this.isStopped()) {
                    return;
                }
                IIMPSmartRender.mc.m_18707_(() -> {
                    BlockEntity patt4234$temp = ImportYoutubePlayListMusicsMMMonitor.this.getScreen().getBlockEntity();
                    if (patt4234$temp instanceof MusicManagerBlockEntity) {
                        MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)patt4234$temp;
                        NetworkManager.sendToServer((ResourceLocation)IMPPackets.MULTIPLE_MUSIC_ADD, (FriendlyByteBuf)new IMPPackets.MultipleMusicAddMessage(musicManagerBlock.getMySelectedPlayList(), musics, BlockEntityExistence.getByBlockEntity((BlockEntity)ImportYoutubePlayListMusicsMMMonitor.this.getScreen().getBlockEntity())).toFBB());
                    }
                    ImportYoutubePlayListMusicsMMMonitor.this.insMonitor(MusicManagerBlockEntity.MonitorType.PLAY_LIST);
                });
            }
            catch (Exception ex) {
                ImportYoutubePlayListMusicsMMMonitor.this.failureImportPlayList = true;
            }
        }
    }
}

