/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import dev.felnull.imp.music.tracker.EntityMusicTracker;
import dev.felnull.imp.music.tracker.FixedMusicTracker;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.imp.music.tracker.MusicTracker;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.music.tracker.PlayerMusicTracker;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class IMPMusicTrackerFactory {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Map<ResourceLocation, Supplier<? extends MusicTracker>> FACTORY_REGISTRY = new HashMap<ResourceLocation, Supplier<? extends MusicTracker>>();

    public static void init() {
        IMPMusicTrackerFactory.register(IMPMusicTrackers.FIXED_TRACKER, FixedMusicTracker::new);
        IMPMusicTrackerFactory.register(IMPMusicTrackers.ENTITY_TRACKER, () -> new EntityMusicTracker((Level)IMPMusicTrackerFactory.mc.f_91073_, OERenderUtil::getPartialTicks));
        IMPMusicTrackerFactory.register(IMPMusicTrackers.PLAYER_TRACKER, () -> new PlayerMusicTracker((Player)IMPMusicTrackerFactory.mc.f_91074_, (EntityGetter)IMPMusicTrackerFactory.mc.f_91073_, OERenderUtil::getPartialTicks));
    }

    public static void register(ResourceLocation location, Supplier<? extends MusicTracker> factory) {
        FACTORY_REGISTRY.put(location, factory);
    }

    public static MusicTracker create(ResourceLocation location) {
        return FACTORY_REGISTRY.get(location).get();
    }

    @Nullable
    public static MusicTracker loadByTag(CompoundTag tag) {
        if (tag.m_128456_()) {
            return null;
        }
        ResourceLocation id = new ResourceLocation(tag.m_128461_("trackerId"));
        return (MusicTracker)OENbtUtil.readSerializable((CompoundTag)tag, (String)"tracker", (ITAGSerializable)IMPMusicTrackerFactory.create(id));
    }

    public static MusicTracker linked(MusicTrackerEntry trackerEntry) {
        CompoundTag tag = IMPMusicTrackers.saveToTag(trackerEntry);
        return IMPMusicTrackerFactory.loadByTag(tag);
    }
}

