/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mp3;

import com.sedmelluq.discord.lavaplayer.natives.mp3.Mp3Decoder;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mp3.Mp3ConstantRateSeeker;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mp3.Mp3FrameReader;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mp3.Mp3Seeker;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mp3.Mp3StreamSeeker;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mp3.Mp3XingSeeker;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoProvider;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Mp3TrackProvider
implements AudioTrackInfoProvider {
    private static final byte[] IDV3_TAG = new byte[]{73, 68, 51};
    private static final int IDV3_FLAG_EXTENDED = 64;
    private static final String TITLE_TAG = "TIT2";
    private static final String ARTIST_TAG = "TPE1";
    private static final List<String> knownTextExtensions = Arrays.asList("TIT2", "TPE1");
    private final AudioProcessingContext context;
    private final SeekableInputStream inputStream;
    private final DataInputStream dataInput;
    private final Mp3Decoder mp3Decoder;
    private final ShortBuffer outputBuffer;
    private final ByteBuffer inputBuffer;
    private final byte[] frameBuffer;
    private final byte[] tagHeaderBuffer;
    private final Mp3FrameReader frameReader;
    private final Map<String, String> tags;
    private int sampleRate;
    private int channelCount;
    private AudioPipeline downstream;
    private Mp3Seeker seeker;

    public Mp3TrackProvider(AudioProcessingContext context, SeekableInputStream inputStream) {
        this.context = context;
        this.inputStream = inputStream;
        this.dataInput = new DataInputStream(inputStream);
        this.outputBuffer = ByteBuffer.allocateDirect(4608).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.inputBuffer = ByteBuffer.allocateDirect(Mp3Decoder.getMaximumFrameSize());
        this.frameBuffer = new byte[Mp3Decoder.getMaximumFrameSize()];
        this.tagHeaderBuffer = new byte[4];
        this.frameReader = new Mp3FrameReader(inputStream, this.frameBuffer);
        this.mp3Decoder = new Mp3Decoder();
        this.tags = new HashMap<String, String>();
    }

    public void parseHeaders() throws IOException {
        this.skipIdv3Tags();
        if (!this.frameReader.scanForFrame(2048, true)) {
            throw new IllegalStateException("File ended before the first frame was found.");
        }
        this.sampleRate = Mp3Decoder.getFrameSampleRate(this.frameBuffer, 0);
        this.channelCount = Mp3Decoder.getFrameChannelCount(this.frameBuffer, 0);
        this.downstream = this.context != null ? AudioPipelineFactory.create(this.context, new PcmFormat(this.channelCount, this.sampleRate)) : null;
        this.initialiseSeeker();
    }

    private void initialiseSeeker() throws IOException {
        long startPosition = this.frameReader.getFrameStartPosition();
        this.frameReader.fillFrameBuffer();
        this.seeker = Mp3XingSeeker.createFromFrame(startPosition, this.inputStream.getContentLength(), this.frameBuffer);
        if (this.seeker == null) {
            if (this.inputStream.getContentLength() == Long.MAX_VALUE) {
                this.seeker = new Mp3StreamSeeker();
            } else {
                if (this.context == null) {
                    for (int i = 0; Mp3ConstantRateSeeker.isMetaFrame(this.frameBuffer) && i < 2; ++i) {
                        this.frameReader.nextFrame();
                        this.frameReader.fillFrameBuffer();
                    }
                }
                this.seeker = Mp3ConstantRateSeeker.createFromFrame(startPosition, this.inputStream.getContentLength(), this.frameBuffer);
            }
        }
    }

    public void provideFrames() throws InterruptedException {
        try {
            while (this.frameReader.fillFrameBuffer()) {
                this.inputBuffer.clear();
                this.inputBuffer.put(this.frameBuffer, 0, this.frameReader.getFrameSize());
                this.inputBuffer.flip();
                this.outputBuffer.clear();
                this.outputBuffer.limit(this.channelCount * (int)Mp3Decoder.getSamplesPerFrame(this.frameBuffer, 0));
                int produced = this.mp3Decoder.decode(this.inputBuffer, this.outputBuffer);
                if (produced > 0) {
                    this.downstream.process(this.outputBuffer);
                }
                this.frameReader.nextFrame();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void seekToTimecode(long timecode) {
        try {
            long frameIndex = this.seeker.seekAndGetFrameIndex(timecode, this.inputStream);
            long actualTimecode = frameIndex * 1152L * 1000L / (long)this.sampleRate;
            this.downstream.seekPerformed(timecode, actualTimecode);
            this.frameReader.nextFrame();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSeekable() {
        return this.seeker.isSeekable();
    }

    public long getDuration() {
        return this.seeker.getDuration();
    }

    public String getIdv3Tag(String tagId) {
        return this.tags.get(tagId);
    }

    public void close() {
        if (this.downstream != null) {
            this.downstream.close();
        }
        this.mp3Decoder.close();
    }

    private void skipIdv3Tags() throws IOException {
        this.dataInput.readFully(this.tagHeaderBuffer, 0, 3);
        for (int i = 0; i < 3; ++i) {
            if (this.tagHeaderBuffer[i] == IDV3_TAG[i]) continue;
            this.frameReader.appendToScanBuffer(this.tagHeaderBuffer, 0, 3);
            return;
        }
        int majorVersion = this.dataInput.readByte() & 0xFF;
        this.dataInput.readByte();
        if (majorVersion < 2 || majorVersion > 5) {
            return;
        }
        int flags = this.dataInput.readByte() & 0xFF;
        int tagsSize = this.readSyncProofInteger();
        long tagsEndPosition = this.inputStream.getPosition() + (long)tagsSize;
        this.skipExtendedHeader(flags);
        if (majorVersion < 5) {
            this.parseIdv3Frames(majorVersion, tagsEndPosition);
        }
        this.inputStream.seek(tagsEndPosition);
    }

    private int readSyncProofInteger() throws IOException {
        return (this.dataInput.readByte() & 0xFF) << 21 | (this.dataInput.readByte() & 0xFF) << 14 | (this.dataInput.readByte() & 0xFF) << 7 | this.dataInput.readByte() & 0xFF;
    }

    private int readSyncProof3ByteInteger() throws IOException {
        return (this.dataInput.readByte() & 0xFF) << 14 | (this.dataInput.readByte() & 0xFF) << 7 | this.dataInput.readByte() & 0xFF;
    }

    private void skipExtendedHeader(int flags) throws IOException {
        if ((flags & 0x40) != 0) {
            int size = this.readSyncProofInteger();
            this.inputStream.seek(this.inputStream.getPosition() + (long)size - 4L);
        }
    }

    private void parseIdv3Frames(int version, long tagsEndPosition) throws IOException {
        FrameHeader header;
        while (this.inputStream.getPosition() + 10L <= tagsEndPosition && (header = this.readFrameHeader(version)) != null) {
            String text;
            long nextTagPosition = this.inputStream.getPosition() + (long)header.size;
            if (header.hasRawFormat() && knownTextExtensions.contains(header.id) && (text = this.parseIdv3TextContent(header.size)) != null) {
                this.tags.put(header.id, text);
            }
            this.inputStream.seek(nextTagPosition);
        }
    }

    private String parseIdv3TextContent(int size) throws IOException {
        int encoding = this.dataInput.readByte() & 0xFF;
        byte[] data = new byte[size - 1];
        this.dataInput.readFully(data);
        boolean shortTerminator = data.length > 0 && data[data.length - 1] == 0;
        boolean wideTerminator = data.length > 1 && data[data.length - 2] == 0 && shortTerminator;
        switch (encoding) {
            case 0: {
                return new String(data, 0, size - (shortTerminator ? 2 : 1), "ISO-8859-1");
            }
            case 1: {
                return new String(data, 0, size - (wideTerminator ? 3 : 1), "UTF-16");
            }
            case 2: {
                return new String(data, 0, size - (wideTerminator ? 3 : 1), "UTF-16BE");
            }
            case 3: {
                return new String(data, 0, size - (shortTerminator ? 2 : 1), "UTF-8");
            }
        }
        return null;
    }

    private String readId3v22TagName() throws IOException {
        this.dataInput.readFully(this.tagHeaderBuffer, 0, 3);
        if (this.tagHeaderBuffer[0] == 0) {
            return null;
        }
        String shortName = new String(this.tagHeaderBuffer, 0, 3, StandardCharsets.ISO_8859_1);
        if ("TT2".equals(shortName)) {
            return TITLE_TAG;
        }
        if ("TP1".equals(shortName)) {
            return ARTIST_TAG;
        }
        return shortName;
    }

    private String readTagName() throws IOException {
        this.dataInput.readFully(this.tagHeaderBuffer, 0, 4);
        if (this.tagHeaderBuffer[0] == 0) {
            return null;
        }
        return new String(this.tagHeaderBuffer, 0, 4, StandardCharsets.ISO_8859_1);
    }

    private FrameHeader readFrameHeader(int version) throws IOException {
        if (version == 2) {
            String tagName = this.readId3v22TagName();
            if (tagName != null) {
                return new FrameHeader(tagName, this.readSyncProof3ByteInteger(), 0);
            }
        } else {
            String tagName = this.readTagName();
            if (tagName != null) {
                int size = version == 3 ? this.dataInput.readInt() : this.readSyncProofInteger();
                return new FrameHeader(tagName, size, this.dataInput.readUnsignedShort());
            }
        }
        return null;
    }

    @Override
    public String getTitle() {
        return this.getIdv3Tag(TITLE_TAG);
    }

    @Override
    public String getAuthor() {
        return this.getIdv3Tag(ARTIST_TAG);
    }

    @Override
    public Long getLength() {
        return this.getDuration();
    }

    @Override
    public String getIdentifier() {
        return null;
    }

    @Override
    public String getUri() {
        return null;
    }

    @Override
    public String getArtworkUrl() {
        return null;
    }

    @Override
    public String getISRC() {
        return null;
    }

    private static class FrameHeader {
        private final String id;
        private final int size;
        private final boolean tagAlterPreservation;
        private final boolean fileAlterPreservation;
        private final boolean readOnly;
        private final boolean groupingIdentity;
        private final boolean compression;
        private final boolean encryption;
        private final boolean unsynchronization;
        private final boolean dataLengthIndicator;

        private FrameHeader(String id, int size, int flags) {
            this.id = id;
            this.size = size;
            this.tagAlterPreservation = (flags & 0x4000) != 0;
            this.fileAlterPreservation = (flags & 0x2000) != 0;
            this.readOnly = (flags & 0x1000) != 0;
            this.groupingIdentity = (flags & 0x40) != 0;
            this.compression = (flags & 8) != 0;
            this.encryption = (flags & 4) != 0;
            this.unsynchronization = (flags & 2) != 0;
            this.dataLengthIndicator = (flags & 1) != 0;
        }

        private boolean hasRawFormat() {
            return !this.compression && !this.encryption && !this.unsynchronization && !this.dataLengthIndicator;
        }
    }
}

