/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.wav;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.wav.WavFileInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.wav.WavTrackProvider;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class WavFileLoader {
    static final int[] WAV_RIFF_HEADER = new int[]{82, 73, 70, 70, -1, -1, -1, -1, 87, 65, 86, 69};
    private final SeekableInputStream inputStream;

    public WavFileLoader(SeekableInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public WavFileInfo parseHeaders() throws IOException {
        if (!MediaContainerDetection.checkNextBytes(this.inputStream, WAV_RIFF_HEADER, false)) {
            throw new IllegalStateException("Not a WAV header.");
        }
        InfoBuilder builder = new InfoBuilder();
        DataInputStream dataInput = new DataInputStream(this.inputStream);
        while (true) {
            String chunkName = this.readChunkName(dataInput);
            long chunkSize = Integer.toUnsignedLong(Integer.reverseBytes(dataInput.readInt()));
            if ("fmt ".equals(chunkName)) {
                this.readFormatChunk(builder, dataInput);
                if (chunkSize <= 16L) continue;
                this.inputStream.skipFully(chunkSize - 16L);
                continue;
            }
            if ("data".equals(chunkName)) {
                builder.sampleAreaSize = chunkSize;
                builder.startOffset = this.inputStream.getPosition();
                return builder.build();
            }
            this.inputStream.skipFully(chunkSize);
        }
    }

    private String readChunkName(DataInput dataInput) throws IOException {
        byte[] buffer = new byte[4];
        dataInput.readFully(buffer);
        return new String(buffer, StandardCharsets.US_ASCII);
    }

    private void readFormatChunk(InfoBuilder builder, DataInput dataInput) throws IOException {
        builder.audioFormat = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        builder.channelCount = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        builder.sampleRate = Integer.reverseBytes(dataInput.readInt());
        dataInput.readInt();
        builder.blockAlign = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        builder.bitsPerSample = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
    }

    public WavTrackProvider loadTrack(AudioProcessingContext context) throws IOException {
        return new WavTrackProvider(context, this.inputStream, this.parseHeaders());
    }

    private static class InfoBuilder {
        private int audioFormat;
        private int channelCount;
        private int sampleRate;
        private int bitsPerSample;
        private int blockAlign;
        private long sampleAreaSize;
        private long startOffset;

        private InfoBuilder() {
        }

        private WavFileInfo build() {
            this.validateFormat();
            this.validateAlignment();
            return new WavFileInfo(this.channelCount, this.sampleRate, this.bitsPerSample, this.blockAlign, this.sampleAreaSize / (long)this.blockAlign, this.startOffset);
        }

        private void validateFormat() {
            if (this.audioFormat != 1) {
                throw new IllegalStateException("Invalid audio format " + this.audioFormat + ", must be 1 (PCM)");
            }
            if (this.channelCount < 1 || this.channelCount > 16) {
                throw new IllegalStateException("Invalid channel count: " + this.channelCount);
            }
            if (this.sampleRate < 100 || this.sampleRate > 384000) {
                throw new IllegalStateException("Invalid sample rate: " + this.sampleRate);
            }
            if (this.bitsPerSample != 16 && this.bitsPerSample != 24) {
                throw new IllegalStateException("Unsupported bits per sample: " + this.bitsPerSample);
            }
        }

        private void validateAlignment() {
            int minimumBlockAlign = this.channelCount * (this.bitsPerSample >> 3);
            if (this.blockAlign < minimumBlockAlign || this.blockAlign > minimumBlockAlign + 32) {
                throw new IllegalStateException("Block align is not valid: " + this.blockAlign);
            }
            if (this.blockAlign % (this.bitsPerSample >> 3) != 0) {
                throw new IllegalStateException("Block align is not a multiple of bits per sample: " + this.blockAlign);
            }
            if (this.sampleAreaSize < 0L) {
                throw new IllegalStateException("Negative sample area size: " + this.sampleAreaSize);
            }
        }
    }
}

