/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.net.sourceforge.jaad.mp4.boxes;

import dev.felnull.imp.include.net.sourceforge.jaad.mp4.MP4Input;
import dev.felnull.imp.include.net.sourceforge.jaad.mp4.boxes.Box;
import dev.felnull.imp.include.net.sourceforge.jaad.mp4.boxes.BoxFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BoxImpl
implements Box {
    private final String name;
    protected long size;
    protected long type;
    protected long offset;
    protected Box parent;
    protected final List<Box> children;

    public BoxImpl(String name) {
        this.name = name;
        this.children = new ArrayList<Box>(4);
    }

    public void setParams(Box parent, long size, long type, long offset) {
        this.size = size;
        this.type = type;
        this.parent = parent;
        this.offset = offset;
    }

    protected long getLeft(MP4Input in) throws IOException {
        return this.offset + this.size - in.getOffset();
    }

    public void decode(MP4Input in) throws IOException {
    }

    @Override
    public long getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public Box getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " [" + BoxFactory.typeToString(this.type) + "]";
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public boolean hasChild(long type) {
        boolean b = false;
        for (Box box : this.children) {
            if (box.getType() != type) continue;
            b = true;
            break;
        }
        return b;
    }

    @Override
    public Box getChild(long type) {
        Box box = null;
        Box b = null;
        for (int i = 0; box == null && i < this.children.size(); ++i) {
            b = this.children.get(i);
            if (b.getType() != type) continue;
            box = b;
        }
        return box;
    }

    @Override
    public List<Box> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public List<Box> getChildren(long type) {
        ArrayList<Box> l = new ArrayList<Box>();
        for (Box box : this.children) {
            if (box.getType() != type) continue;
            l.add(box);
        }
        return l;
    }

    protected Box parseBox(MP4Input in) throws IOException {
        return BoxFactory.parseBox(this, in);
    }

    protected void readChildren(MP4Input in) throws IOException {
        while (in.getOffset() < this.offset + this.size) {
            Box box = this.parseBox(in);
            this.children.add(box);
        }
    }

    protected void readChildren(MP4Input in, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            Box box = this.parseBox(in);
            this.children.add(box);
        }
    }
}

