/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.resource;

import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class Music
implements ITAGSerializable,
IIMPComparable {
    private UUID uuid;
    private String name;
    private String author;
    private MusicSource source;
    private ImageInfo image;
    private UUID owner;
    private long createDate;

    public Music() {
    }

    public Music(UUID uuid, String name, String author, MusicSource source, ImageInfo image, UUID owner, long createDate) {
        this.uuid = uuid;
        this.name = name;
        this.author = author;
        this.source = source;
        this.image = image;
        this.owner = owner;
        this.createDate = createDate;
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128362_("UUID", this.uuid);
        tag.m_128359_("Name", this.name);
        tag.m_128359_("Author", this.author);
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"Source", (ITAGSerializable)this.source);
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"Image", (ITAGSerializable)this.image);
        tag.m_128362_("Owner", this.owner);
        tag.m_128356_("CreateDate", this.createDate);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.uuid = tag.m_128342_("UUID");
        this.name = tag.m_128461_("Name");
        this.author = tag.m_128461_("Author");
        this.source = (MusicSource)OENbtUtil.readSerializable((CompoundTag)tag, (String)"Source", (ITAGSerializable)new MusicSource());
        this.image = (ImageInfo)OENbtUtil.readSerializable((CompoundTag)tag, (String)"Image", (ITAGSerializable)new ImageInfo());
        this.owner = tag.m_128342_("Owner");
        this.createDate = tag.m_128454_("CreateDate");
    }

    public String getName() {
        return this.name;
    }

    public ImageInfo getImage() {
        return this.image;
    }

    public MusicSource getSource() {
        return this.source;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public long getCreateDate() {
        return this.createDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Music music = (Music)o;
        return this.createDate == music.createDate && Objects.equals(this.uuid, music.uuid) && Objects.equals(this.name, music.name) && Objects.equals(this.author, music.author) && Objects.equals(this.source, music.source) && Objects.equals(this.image, music.image) && Objects.equals(this.owner, music.owner);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.name, this.author, this.source, this.image, this.owner, this.createDate);
    }

    public String toString() {
        return "Music{uuid=" + this.uuid + ", name='" + this.name + "', author='" + this.author + "', source=" + this.source + ", image=" + this.image + ", owner=" + this.owner + ", createDate=" + this.createDate + "}";
    }

    @Override
    public String getCompareName() {
        return this.name;
    }

    @Override
    public String getComparePlayerName() {
        return this.owner.toString();
    }

    @Override
    public long getCompareDate() {
        return this.createDate;
    }
}

