/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.resource;

import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;

public class MusicSource
implements ITAGSerializable {
    public static final MusicSource EMPTY = new MusicSource("", "", 0L);
    private String loaderType;
    private String identifier;
    private long duration;

    public MusicSource() {
    }

    public MusicSource(String loaderType, String identifier, long duration) {
        this.loaderType = loaderType;
        this.identifier = identifier;
        this.duration = duration;
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("LoaderType", this.loaderType);
        tag.m_128359_("Identifier", this.identifier);
        tag.m_128356_("Duration", this.duration);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.loaderType = tag.m_128461_("LoaderType");
        this.identifier = tag.m_128461_("Identifier");
        this.duration = tag.m_128454_("Duration");
    }

    public long getDuration() {
        return this.duration;
    }

    public String getLoaderType() {
        return this.loaderType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isLive() {
        return this.duration < 0L;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.loaderType.isEmpty() && this.identifier.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MusicSource that = (MusicSource)o;
        return this.duration == that.duration && Objects.equals(this.loaderType, that.loaderType) && Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.loaderType, this.identifier, this.duration);
    }

    public String toString() {
        return "MusicSource{loaderType='" + this.loaderType + "', identifier='" + this.identifier + "', duration=" + this.duration + "}";
    }
}

