/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.tracker;

import dev.felnull.imp.music.MusicSpeakerFixedInfo;
import dev.felnull.imp.music.MusicSpeakerInfo;
import dev.felnull.imp.music.SpatialType;
import dev.felnull.imp.music.tracker.EntityMusicTracker;
import dev.felnull.imp.music.tracker.FixedMusicTracker;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.music.tracker.PlayerMusicTracker;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class IMPMusicTrackers {
    public static final ResourceLocation FIXED_TRACKER = new ResourceLocation("iammusicplayer", "fixed");
    public static final ResourceLocation ENTITY_TRACKER = new ResourceLocation("iammusicplayer", "entity");
    public static final ResourceLocation PLAYER_TRACKER = new ResourceLocation("iammusicplayer", "player");

    public static MusicTrackerEntry createFixedTracker(Vec3 position, float volume, float range, int channel, SpatialType spatialType) {
        return new MusicTrackerEntry(FIXED_TRACKER, new FixedMusicTracker(new MusicSpeakerInfo(position, volume, range, new MusicSpeakerFixedInfo(channel, spatialType))));
    }

    public static MusicTrackerEntry createFixedTracker(Vec3 position, float volume, float range) {
        return new MusicTrackerEntry(FIXED_TRACKER, new FixedMusicTracker(new MusicSpeakerInfo(position, volume, range, new MusicSpeakerFixedInfo(-1, SpatialType.ENTRUST))));
    }

    public static MusicTrackerEntry createEntityTracker(Entity entity, float volume, float range) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return IMPMusicTrackers.createPlayerTracker(player, volume, range);
        }
        return new MusicTrackerEntry(ENTITY_TRACKER, new EntityMusicTracker(entity, volume, range));
    }

    public static MusicTrackerEntry createPlayerTracker(Player player, float volume, float range) {
        return new MusicTrackerEntry(PLAYER_TRACKER, new PlayerMusicTracker(player, volume, range));
    }

    public static CompoundTag saveToTag(MusicTrackerEntry trackerEntry) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("trackerId", trackerEntry.location().toString());
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"tracker", (ITAGSerializable)trackerEntry.tracker());
        return tag;
    }
}

