/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.networking;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.client.handler.ClientMessageHandler;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.handler.ServerMessageHandler;
import dev.felnull.imp.util.IMPNbtUtil;
import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import dev.felnull.otyacraftengine.item.location.PlayerItemLocations;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import dev.felnull.otyacraftengine.networking.PacketMessage;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class IMPPackets {
    public static final ResourceLocation MUSIC_SYNC = new ResourceLocation("iammusicplayer", "music_sync");
    public static final ResourceLocation MUSIC_PLAYLIST_ADD = new ResourceLocation("iammusicplayer", "music_playlist_add");
    public static final ResourceLocation MUSIC_PLAYLIST_EDIT = new ResourceLocation("iammusicplayer", "music_playlist_edit");
    public static final ResourceLocation MUSIC_PLAYLIST_CHANGE_AUTHORITY = new ResourceLocation("iammusicplayer", "music_playlist_change_authority");
    public static final ResourceLocation MUSIC_ADD = new ResourceLocation("iammusicplayer", "music_add");
    public static final ResourceLocation MUSIC_EDIT = new ResourceLocation("iammusicplayer", "music_edit");
    public static final ResourceLocation MUSIC_OR_PLAYLIST_DELETE = new ResourceLocation("iammusicplayer", "music_or_playlist_delete");
    public static final ResourceLocation MUSIC_RING_READY = new ResourceLocation("iammusicplayer", "music_ring_ready");
    public static final ResourceLocation MUSIC_RING_READY_RESULT = new ResourceLocation("iammusicplayer", "music_ring_ready_result");
    public static final ResourceLocation MUSIC_RING_STATE = new ResourceLocation("iammusicplayer", "music_ring_state");
    public static final ResourceLocation MUSIC_RING_UPDATE_RESULT = new ResourceLocation("iammusicplayer", "music_ring_update_result");
    public static final ResourceLocation MULTIPLE_MUSIC_ADD = new ResourceLocation("iammusicplayer", "multiple_music_add");
    public static final ResourceLocation HAND_LID_CYCLE = new ResourceLocation("iammusicplayer", "hand_lid_cycle");

    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_SYNC, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicSyncRequestMessage(new MusicSyncRequestMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_PLAYLIST_ADD, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicPlayListAddMessage(new MusicPlayListMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_PLAYLIST_EDIT, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicPlayListEditMessage(new MusicPlayListMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_PLAYLIST_CHANGE_AUTHORITY, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicPlayListChangeAuthority(new MusicPlayListChangeAuthorityMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_ADD, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicAddMessage(new MusicMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_EDIT, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicEditMessage(new MusicMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_RING_READY_RESULT, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicReadyResultMessage(new MusicRingReadyResultMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_RING_UPDATE_RESULT, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicUpdateResultMessage(new MusicRingUpdateResultMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MUSIC_OR_PLAYLIST_DELETE, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicOrPlayListDeleteMessage(new MusicOrPlayListDeleteMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MULTIPLE_MUSIC_ADD, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMultipleMusicAdd(new MultipleMusicAddMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)HAND_LID_CYCLE, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onHandLidCycleMessage(new LidCycleMessage(friendlyByteBuf), packetContext));
    }

    public static void clientInit() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)MUSIC_SYNC, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onMusicSyncResponseMessage(new MusicSyncResponseMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)MUSIC_RING_READY, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onMusicRingReadyResponseMessage(new MusicReadyMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)MUSIC_RING_STATE, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onMusicRingStateResponseMessage(new MusicRingStateMessage(friendlyByteBuf), packetContext));
    }

    public record MusicRingStateMessage(UUID uuid, UUID waitId, MusicRingStateType stateType, long elapsed, CompoundTag tracker) implements PacketMessage
    {
        public MusicRingStateMessage(UUID uuid, UUID waitId, MusicRingStateType stateType) {
            this(uuid, waitId, stateType, 0L, new CompoundTag());
        }

        public MusicRingStateMessage(FriendlyByteBuf bf) {
            this(bf.m_130259_(), bf.m_130259_(), (MusicRingStateType)bf.m_130066_(MusicRingStateType.class), bf.readLong(), bf.m_130260_());
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.uuid);
            buf.m_130077_(this.waitId);
            buf.m_130068_((Enum)this.stateType);
            buf.writeLong(this.elapsed);
            buf.m_130079_(this.tracker);
            return buf;
        }
    }

    public record MusicReadyMessage(UUID waitId, UUID uuid, MusicSource source, CompoundTag tracker, long position) implements PacketMessage
    {
        public MusicReadyMessage(FriendlyByteBuf bf) {
            this(bf.m_130259_(), bf.m_130259_(), (MusicSource)OENbtUtil.readSerializable((CompoundTag)bf.m_130260_(), (String)"ms", (ITAGSerializable)new MusicSource()), bf.m_130260_(), bf.readLong());
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.waitId);
            buf.m_130077_(this.uuid);
            buf.m_130079_(OENbtUtil.writeSerializable((CompoundTag)new CompoundTag(), (String)"ms", (ITAGSerializable)this.source));
            buf.m_130079_(this.tracker);
            buf.writeLong(this.position);
            return buf;
        }
    }

    public static class MusicSyncResponseMessage
    implements PacketMessage {
        public final MusicSyncType syncType;
        public final UUID syncId;
        public final List<MusicPlayList> playLists;
        public final List<Music> musics;

        public MusicSyncResponseMessage(FriendlyByteBuf bf) {
            this.syncType = MusicSyncType.getById(bf.readInt());
            this.syncId = bf.m_130259_();
            this.playLists = new ArrayList<MusicPlayList>();
            IMPNbtUtil.readMusicPlayLists(bf.m_130260_(), "PlayLists", this.playLists);
            this.musics = new ArrayList<Music>();
            IMPNbtUtil.readMusics(bf.m_130260_(), "Musics", this.musics);
        }

        public MusicSyncResponseMessage(MusicSyncType syncType, UUID syncId, List<MusicPlayList> playLists, List<Music> musics) {
            this.syncType = syncType;
            this.syncId = syncId;
            this.playLists = playLists;
            this.musics = musics;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(this.syncType.ordinal());
            buf.m_130077_(this.syncId);
            buf.m_130079_(IMPNbtUtil.writeMusicPlayLists(new CompoundTag(), "PlayLists", this.playLists));
            buf.m_130079_(IMPNbtUtil.writeMusics(new CompoundTag(), "Musics", this.musics));
            return buf;
        }
    }

    public static class LidCycleMessage
    implements PacketMessage {
        public final UUID boomboxId;
        public final IPlayerItemLocation itemLocation;

        public LidCycleMessage(FriendlyByteBuf buf) {
            this.boomboxId = buf.m_130259_();
            this.itemLocation = PlayerItemLocations.create((ResourceLocation)buf.m_130281_(), (CompoundTag)buf.m_130260_());
        }

        public LidCycleMessage(UUID boomboxId, IPlayerItemLocation itemLocation) {
            this.boomboxId = boomboxId;
            this.itemLocation = itemLocation;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.boomboxId);
            buf.m_130085_(this.itemLocation.getResourceLocation());
            buf.m_130079_(this.itemLocation.toTag());
            return buf;
        }
    }

    public static class MultipleMusicAddMessage
    implements PacketMessage {
        public final UUID playlist;
        public final List<Music> musics;
        public final BlockEntityExistence blockEntityExistence;

        public MultipleMusicAddMessage(FriendlyByteBuf bf) {
            this.playlist = bf.m_130259_();
            this.musics = new ArrayList<Music>();
            IMPNbtUtil.readMusics(bf.m_130260_(), "Musics", this.musics);
            this.blockEntityExistence = BlockEntityExistence.readFBB((FriendlyByteBuf)bf);
        }

        public MultipleMusicAddMessage(UUID playlist, List<Music> musics, BlockEntityExistence blockEntityExistence) {
            this.playlist = playlist;
            this.musics = musics;
            this.blockEntityExistence = blockEntityExistence;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.playlist);
            buf.m_130079_(IMPNbtUtil.writeMusics(new CompoundTag(), "Musics", this.musics));
            this.blockEntityExistence.writeFBB(buf);
            return buf;
        }
    }

    public static class MusicOrPlayListDeleteMessage
    implements PacketMessage {
        public final UUID playListID;
        public final UUID musicID;
        public final BlockEntityExistence blockEntityExistence;
        public final boolean music;

        public MusicOrPlayListDeleteMessage(FriendlyByteBuf bf) {
            this.playListID = bf.m_130259_();
            this.musicID = bf.m_130259_();
            this.blockEntityExistence = BlockEntityExistence.readFBB((FriendlyByteBuf)bf);
            this.music = bf.readBoolean();
        }

        public MusicOrPlayListDeleteMessage(UUID playListID, UUID musicID, BlockEntityExistence blockEntityExistence, boolean music) {
            this.playListID = playListID;
            this.musicID = musicID;
            this.blockEntityExistence = blockEntityExistence;
            this.music = music;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.playListID);
            buf.m_130077_(this.musicID);
            this.blockEntityExistence.writeFBB(buf);
            buf.writeBoolean(this.music);
            return buf;
        }
    }

    public record MusicRingUpdateResultMessage(UUID uuid, UUID waitId, MusicRingResponseStateType ringResponseStateType) implements PacketMessage
    {
        public MusicRingUpdateResultMessage(FriendlyByteBuf bf) {
            this(bf.m_130259_(), bf.m_130259_(), (MusicRingResponseStateType)bf.m_130066_(MusicRingResponseStateType.class));
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.uuid);
            buf.m_130077_(this.waitId);
            buf.m_130068_((Enum)this.ringResponseStateType);
            return buf;
        }
    }

    public static class MusicRingReadyResultMessage
    implements PacketMessage {
        public final UUID waitID;
        public final UUID uuid;
        public final boolean result;
        public final boolean retry;
        public final long elapsed;

        public MusicRingReadyResultMessage(FriendlyByteBuf bf) {
            this.waitID = bf.m_130259_();
            this.uuid = bf.m_130259_();
            this.result = bf.readBoolean();
            this.retry = bf.readBoolean();
            this.elapsed = bf.readLong();
        }

        public MusicRingReadyResultMessage(UUID waitID, UUID uuid, boolean result, boolean retry, long elapsed) {
            this.waitID = waitID;
            this.uuid = uuid;
            this.result = result;
            this.retry = retry;
            this.elapsed = elapsed;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.waitID);
            buf.m_130077_(this.uuid);
            buf.writeBoolean(this.result);
            buf.writeBoolean(this.retry);
            buf.writeLong(this.elapsed);
            return buf;
        }
    }

    public static class MusicMessage
    implements PacketMessage {
        public final UUID uuid;
        public final UUID playlist;
        public final String name;
        public final String author;
        public final ImageInfo image;
        public final MusicSource source;
        public final BlockEntityExistence blockEntityExistence;

        public MusicMessage(FriendlyByteBuf bf) {
            this.uuid = bf.m_130259_();
            this.playlist = bf.m_130259_();
            this.name = bf.m_130277_();
            this.author = bf.m_130277_();
            this.image = (ImageInfo)OENbtUtil.readSerializable((CompoundTag)bf.m_130260_(), (String)"Image", (ITAGSerializable)new ImageInfo());
            this.source = (MusicSource)OENbtUtil.readSerializable((CompoundTag)bf.m_130260_(), (String)"Source", (ITAGSerializable)new MusicSource());
            this.blockEntityExistence = BlockEntityExistence.readFBB((FriendlyByteBuf)bf);
        }

        public MusicMessage(UUID playlist, String name, String author, ImageInfo image, MusicSource source, BlockEntityExistence blockEntityExistence) {
            this(UUID.randomUUID(), playlist, name, author, image, source, blockEntityExistence);
        }

        public MusicMessage(UUID uuid, UUID playlist, String name, String author, ImageInfo image, MusicSource source, BlockEntityExistence blockEntityExistence) {
            this.uuid = uuid;
            this.playlist = playlist;
            this.name = name;
            this.author = author;
            this.image = image;
            this.source = source;
            this.blockEntityExistence = blockEntityExistence;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.uuid);
            buf.m_130077_(this.playlist);
            buf.m_130070_(this.name);
            buf.m_130070_(this.author);
            buf.m_130079_(OENbtUtil.writeSerializable((CompoundTag)new CompoundTag(), (String)"Image", (ITAGSerializable)this.image));
            buf.m_130079_(OENbtUtil.writeSerializable((CompoundTag)new CompoundTag(), (String)"Source", (ITAGSerializable)this.source));
            this.blockEntityExistence.writeFBB(buf);
            return buf;
        }
    }

    public static class MusicPlayListChangeAuthorityMessage
    implements PacketMessage {
        public final UUID playlist;
        public final UUID player;
        public final AuthorityInfo.AuthorityType authorityType;
        public final BlockEntityExistence blockEntityExistence;

        public MusicPlayListChangeAuthorityMessage(FriendlyByteBuf bf) {
            this.playlist = bf.m_130259_();
            this.player = bf.m_130259_();
            this.authorityType = AuthorityInfo.AuthorityType.getByName(bf.m_130277_());
            this.blockEntityExistence = BlockEntityExistence.readFBB((FriendlyByteBuf)bf);
        }

        public MusicPlayListChangeAuthorityMessage(UUID playlist, UUID player, AuthorityInfo.AuthorityType authorityType, BlockEntityExistence blockEntityExistence) {
            this.playlist = playlist;
            this.player = player;
            this.authorityType = authorityType;
            this.blockEntityExistence = blockEntityExistence;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.playlist);
            buf.m_130077_(this.player);
            buf.m_130070_(this.authorityType.getName());
            this.blockEntityExistence.writeFBB(buf);
            return buf;
        }
    }

    public static class MusicPlayListMessage
    implements PacketMessage {
        public final UUID uuid;
        public final String name;
        public final ImageInfo image;
        public final boolean publiced;
        public final boolean initMember;
        public final List<UUID> invitePlayers;
        public final BlockEntityExistence blockEntityExistence;
        public final List<Music> importMusics;

        public MusicPlayListMessage(FriendlyByteBuf bf) {
            this.uuid = bf.m_130259_();
            this.name = bf.m_130277_();
            this.image = (ImageInfo)OENbtUtil.readSerializable((CompoundTag)bf.m_130260_(), (String)"Image", (ITAGSerializable)new ImageInfo());
            this.publiced = bf.readBoolean();
            this.initMember = bf.readBoolean();
            this.invitePlayers = new ArrayList<UUID>();
            OENbtUtil.readUUIDList((CompoundTag)bf.m_130260_(), (String)"InvitePlayers", this.invitePlayers);
            this.blockEntityExistence = BlockEntityExistence.readFBB((FriendlyByteBuf)bf);
            this.importMusics = new ArrayList<Music>();
            IMPNbtUtil.readMusics(bf.m_130260_(), "ImportMusics", this.importMusics);
        }

        public MusicPlayListMessage(String name, ImageInfo image, boolean publiced, boolean initMember, List<UUID> invitePlayers, BlockEntityExistence blockEntityExistence, List<Music> importMusics) {
            this(UUID.randomUUID(), name, image, publiced, initMember, invitePlayers, blockEntityExistence, importMusics);
        }

        public MusicPlayListMessage(UUID uuid, String name, ImageInfo image, boolean publiced, boolean initMember, List<UUID> invitePlayers, BlockEntityExistence blockEntityExistence, List<Music> importMusics) {
            this.uuid = uuid;
            this.name = name;
            this.image = image;
            this.publiced = publiced;
            this.initMember = initMember;
            this.invitePlayers = invitePlayers;
            this.blockEntityExistence = blockEntityExistence;
            this.importMusics = importMusics;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130077_(this.uuid);
            buf.m_130070_(this.name);
            buf.m_130079_(OENbtUtil.writeSerializable((CompoundTag)new CompoundTag(), (String)"Image", (ITAGSerializable)this.image));
            buf.writeBoolean(this.publiced);
            buf.writeBoolean(this.initMember);
            buf.m_130079_(OENbtUtil.writeUUIDList((CompoundTag)new CompoundTag(), (String)"InvitePlayers", this.invitePlayers));
            this.blockEntityExistence.writeFBB(buf);
            buf.m_130079_(IMPNbtUtil.writeMusics(new CompoundTag(), "ImportMusics", this.importMusics));
            return buf;
        }
    }

    public static class MusicSyncRequestMessage
    implements PacketMessage {
        public final MusicSyncType syncType;
        public final UUID syncId;

        public MusicSyncRequestMessage(FriendlyByteBuf bf) {
            this(MusicSyncType.getById(bf.readInt()), bf.m_130259_());
        }

        public MusicSyncRequestMessage(MusicSyncType syncType, UUID syncId) {
            this.syncType = syncType;
            this.syncId = syncId;
        }

        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(this.syncType.ordinal());
            buf.m_130077_(this.syncId);
            return buf;
        }
    }

    public static enum MusicRingResponseStateType {
        NONE,
        PLAYING,
        LOADING;

    }

    public static enum MusicRingStateType {
        NONE,
        PLAY,
        STOP,
        UPDATE;

    }

    public static enum MusicSyncType {
        NONE,
        PLAYLIST_CAN_JOIN,
        PLAYLIST_MY_LIST,
        MUSIC_BY_PLAYLIST,
        UPDATE;


        private static MusicSyncType getById(int id) {
            if (MusicSyncType.values().length > id) {
                return MusicSyncType.values()[id];
            }
            return NONE;
        }
    }
}

