/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class HangingSignBakedModel
implements IDynamicBakedModel {
    private final EnumMap<BlockProperties.SignAttachment, ImmutableList<BakedModel>> attachmentMap;
    private final BakedModel particle;
    private final BlockModelShaper blockModelShaper;

    public HangingSignBakedModel(BakedModel stick, BakedModel leftPost, BakedModel leftPalisade, BakedModel leftWall, BakedModel leftBeam, BakedModel leftStick, BakedModel rightPost, BakedModel rightPalisade, BakedModel rightWall, BakedModel rightBeam, BakedModel rightStick) {
        HashMap<BlockProperties.SignAttachment, ImmutableList> temp = new HashMap<BlockProperties.SignAttachment, ImmutableList>();
        for (BlockProperties.SignAttachment a : BlockProperties.SignAttachment.values()) {
            ImmutableList.Builder b = ImmutableList.builder();
            if (a != BlockProperties.SignAttachment.CEILING) {
                b.add((Object)stick);
                switch (a.left) {
                    case POST: {
                        b.add((Object)leftPost);
                        break;
                    }
                    case PALISADE: {
                        b.add((Object)leftPalisade);
                        break;
                    }
                    case WALL: {
                        b.add((Object)leftWall);
                        break;
                    }
                    case BEAM: {
                        b.add((Object)leftBeam);
                        break;
                    }
                    case STICK: {
                        b.add((Object)leftStick);
                    }
                }
                switch (a.right) {
                    case POST: {
                        b.add((Object)rightPost);
                        break;
                    }
                    case PALISADE: {
                        b.add((Object)rightPalisade);
                        break;
                    }
                    case WALL: {
                        b.add((Object)rightWall);
                        break;
                    }
                    case BEAM: {
                        b.add((Object)rightBeam);
                        break;
                    }
                    case STICK: {
                        b.add((Object)rightStick);
                    }
                }
            }
            temp.put(a, b.build());
        }
        this.attachmentMap = Maps.newEnumMap(temp);
        this.particle = stick;
        this.blockModelShaper = Minecraft.m_91087_().m_91289_().m_110907_();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Block block2;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state != null && (block2 = state.m_60734_()) instanceof HangingSignBlock) {
            HangingSignBlock hs = (HangingSignBlock)block2;
            try {
                BlockProperties.SignAttachment a = (BlockProperties.SignAttachment)((Object)state.m_61143_(HangingSignBlock.ATTACHMENT));
                this.attachmentMap.get((Object)a).forEach(b -> quads.addAll(b.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE)));
            }
            catch (Exception a) {
                // empty catch block
            }
            try {
                boolean fancy = Boolean.TRUE.equals(extraData.getData(BlockProperties.FANCY));
                if (!fancy) {
                    boolean ceiling;
                    BakedModel model = this.blockModelShaper.m_110881_().getModel(ClientRegistry.HANGING_SIGNS_BLOCK_MODELS.get(hs.woodType));
                    if (model.m_6160_() instanceof MissingTextureAtlasSprite) {
                        return quads;
                    }
                    List signQuads = model.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
                    boolean flipped = state.m_61143_(HangingSignBlock.AXIS) == Direction.Axis.X;
                    boolean bl = ceiling = state.m_61143_(HangingSignBlock.ATTACHMENT) == BlockProperties.SignAttachment.CEILING;
                    if (flipped || ceiling) {
                        for (BakedQuad q : signQuads) {
                            int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
                            Direction dir = q.m_111306_();
                            if (flipped) {
                                RendererUtil.rotateVerticesY(v, q.m_173410_(), Rotation.CLOCKWISE_90);
                                if (dir.m_122434_() != Direction.Axis.Y) {
                                    dir = dir.m_122427_();
                                }
                            }
                            if (ceiling) {
                                RendererUtil.moveVertices(v, 0.0f, 0.125f, 0.0f, q.m_173410_());
                            }
                            quads.add(new BakedQuad(v, q.m_111305_(), dir, q.m_173410_(), q.m_111307_()));
                        }
                    } else {
                        quads.addAll(signQuads);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particle.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

