/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.elements;

import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.util.WeakHashMap;
import net.minecraft.world.item.ItemStack;

public class AnimatedGuiElement
implements GuiElementInterface {
    protected final GuiElementInterface.ClickCallback callback;
    protected ItemStack[] items;
    protected int frame = 0;
    protected int tick = 0;
    protected final int changeEvery;
    protected final boolean random;
    protected WeakHashMap<GuiInterface, TickAndFrame> ticks = new WeakHashMap();

    public AnimatedGuiElement(ItemStack[] items, int interval, boolean random, GuiElementInterface.ClickCallback callback) {
        this.items = items;
        this.callback = callback;
        this.changeEvery = interval;
        this.random = random;
    }

    public AnimatedGuiElement(ItemStack[] items, int interval, boolean random, GuiElementInterface.ItemClickCallback callback) {
        this.items = items;
        this.callback = callback;
        this.changeEvery = interval;
        this.random = random;
    }

    public void setItemStacks(ItemStack[] itemStacks) {
        this.items = itemStacks;
    }

    @Override
    public ItemStack getItemStack() {
        return this.items[this.frame];
    }

    @Override
    public GuiElementInterface.ClickCallback getGuiCallback() {
        return this.callback;
    }

    @Override
    public ItemStack getItemStackForDisplay(GuiInterface gui) {
        int cFrame = this.frame++;
        ++this.tick;
        if (this.tick >= this.changeEvery) {
            this.tick = 0;
            if (this.frame >= this.items.length) {
                this.frame = 0;
            }
            if (this.random) {
                this.frame = (int)(Math.random() * (double)this.items.length);
            }
        }
        return this.items[cFrame].m_41777_();
    }

    protected static class TickAndFrame {
        public int tick;
        public int frame;

        protected TickAndFrame() {
        }
    }
}

