/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.elements;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.elements.AnimatedGuiElement;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class AnimatedGuiElementBuilder
implements GuiElementBuilderInterface<AnimatedGuiElementBuilder> {
    protected final Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    protected final List<ItemStack> itemStacks = new ArrayList<ItemStack>();
    protected Item item = Items.f_41905_;
    protected CompoundTag tag;
    protected int count = 1;
    protected Component name = null;
    protected List<Component> lore = new ArrayList<Component>();
    protected int damage = -1;
    protected GuiElementInterface.ClickCallback callback = GuiElement.EMPTY_CALLBACK;
    protected byte hideFlags = 0;
    protected int interval = 1;
    protected boolean random = false;

    public AnimatedGuiElementBuilder setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public AnimatedGuiElementBuilder setRandom(boolean value) {
        this.random = value;
        return this;
    }

    public AnimatedGuiElementBuilder saveItemStack() {
        this.itemStacks.add(this.asStack());
        this.item = Items.f_41905_;
        this.tag = null;
        this.count = 1;
        this.name = null;
        this.lore = new ArrayList<Component>();
        this.damage = -1;
        this.hideFlags = 0;
        this.enchantments.clear();
        return this;
    }

    public AnimatedGuiElementBuilder setItem(Item item) {
        this.item = item;
        return this;
    }

    public AnimatedGuiElementBuilder setName(Component name) {
        this.name = name.m_6881_();
        return this;
    }

    public AnimatedGuiElementBuilder setName(MutableComponent name) {
        return this.setName((Component)name);
    }

    public AnimatedGuiElementBuilder setCount(int count) {
        this.count = count;
        return this;
    }

    public AnimatedGuiElementBuilder setLore(List<Component> lore) {
        this.lore = lore;
        return this;
    }

    public AnimatedGuiElementBuilder addLoreLine(Component lore) {
        this.lore.add(lore);
        return this;
    }

    public AnimatedGuiElementBuilder setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public AnimatedGuiElementBuilder hideFlags() {
        this.hideFlags = (byte)127;
        return this;
    }

    public AnimatedGuiElementBuilder hideFlag(ItemStack.TooltipPart section) {
        this.hideFlags = (byte)(this.hideFlags | section.m_41809_());
        return this;
    }

    public AnimatedGuiElementBuilder hideFlags(byte value) {
        this.hideFlags = value;
        return this;
    }

    public AnimatedGuiElementBuilder enchant(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public AnimatedGuiElementBuilder glow() {
        this.enchantments.put(Enchantments.f_44953_, 1);
        return this.hideFlag(ItemStack.TooltipPart.ENCHANTMENTS);
    }

    public AnimatedGuiElementBuilder setCustomModelData(int value) {
        this.getOrCreateNbt().m_128405_("CustomModelData", value);
        return this;
    }

    public AnimatedGuiElementBuilder unbreakable() {
        this.getOrCreateNbt().m_128379_("Unbreakable", true);
        return this.hideFlag(ItemStack.TooltipPart.UNBREAKABLE);
    }

    public AnimatedGuiElementBuilder setSkullOwner(String value) {
        return this.setSkullOwner(value, null, null);
    }

    public AnimatedGuiElementBuilder setSkullOwner(GameProfile profile, @Nullable MinecraftServer server) {
        if (profile.getId() != null && server != null) {
            profile = server.m_129925_().fillProfileProperties(profile, false);
            this.getOrCreateNbt().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile));
        } else {
            this.getOrCreateNbt().m_128359_("SkullOwner", profile.getName());
        }
        return this;
    }

    public AnimatedGuiElementBuilder setSkullOwner(String value, @Nullable String signature, @Nullable UUID uuid) {
        CompoundTag skullOwner = new CompoundTag();
        CompoundTag properties = new CompoundTag();
        CompoundTag valueData = new CompoundTag();
        ListTag textures = new ListTag();
        valueData.m_128359_("Value", value);
        if (signature != null) {
            valueData.m_128359_("Signature", signature);
        }
        textures.add((Object)valueData);
        properties.m_128365_("textures", (Tag)textures);
        skullOwner.m_128365_("Id", (Tag)NbtUtils.m_129226_((UUID)(uuid != null ? uuid : Util.f_137441_)));
        skullOwner.m_128365_("Properties", (Tag)properties);
        this.getOrCreateNbt().m_128365_("SkullOwner", (Tag)skullOwner);
        return this;
    }

    @Override
    public AnimatedGuiElementBuilder setCallback(GuiElementInterface.ClickCallback callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public AnimatedGuiElementBuilder setCallback(GuiElementInterface.ItemClickCallback callback) {
        this.callback = callback;
        return this;
    }

    public ItemStack asStack() {
        ItemStack itemStack = new ItemStack((ItemLike)this.item, this.count);
        if (this.tag != null) {
            itemStack.m_41784_().m_128391_(this.tag);
        }
        if (this.name != null) {
            if (this.name instanceof MutableComponent) {
                ((MutableComponent)this.name).m_130938_(style -> style.m_131155_(Boolean.valueOf(style.m_131161_())));
            }
            itemStack.m_41714_(this.name);
        }
        if (this.item.m_41465_() && this.damage != -1) {
            itemStack.m_41721_(this.damage);
        }
        for (Map.Entry<Enchantment, Integer> entry : this.enchantments.entrySet()) {
            itemStack.m_41663_(entry.getKey(), entry.getValue().intValue());
        }
        if (this.lore.size() > 0) {
            CompoundTag display = itemStack.m_41698_("display");
            ListTag loreItems = new ListTag();
            for (Component l : this.lore) {
                if (l instanceof MutableComponent) {
                    ((MutableComponent)l).m_130938_(style -> style.m_131155_(Boolean.valueOf(style.m_131161_())));
                }
                loreItems.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)l)));
            }
            display.m_128365_("Lore", (Tag)loreItems);
        }
        if (this.hideFlags != 0) {
            itemStack.m_41784_().m_128344_("HideFlags", this.hideFlags);
        }
        return itemStack;
    }

    private CompoundTag getOrCreateNbt() {
        if (this.tag == null) {
            this.tag = new CompoundTag();
        }
        return this.tag;
    }

    @Override
    public AnimatedGuiElement build() {
        return new AnimatedGuiElement(this.itemStacks.toArray(new ItemStack[0]), this.interval, this.random, this.callback);
    }
}

