/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.elements;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GuiElementBuilder
implements GuiElementBuilderInterface<GuiElementBuilder> {
    protected final Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    protected Item item = Items.f_41905_;
    protected CompoundTag tag;
    protected int count = 1;
    protected Component name = null;
    protected List<Component> lore = new ArrayList<Component>();
    protected int damage = -1;
    protected GuiElementInterface.ClickCallback callback = GuiElementInterface.EMPTY_CALLBACK;
    protected byte hideFlags = 0;
    private static final int STRING = 8;

    public GuiElementBuilder() {
    }

    public GuiElementBuilder(Item item) {
        this.item = item;
    }

    public GuiElementBuilder(Item item, int count) {
        this.item = item;
        this.count = count;
    }

    public static GuiElementBuilder from(ItemStack stack) {
        GuiElementBuilder builder = new GuiElementBuilder(stack.m_41720_(), stack.m_41613_());
        CompoundTag tag = stack.m_41784_().m_6426_();
        if (stack.m_41788_()) {
            builder.setName((MutableComponent)stack.m_41786_());
            tag.m_128469_("display").m_128473_("Name");
        }
        if (tag.m_128441_("display") && tag.m_128469_("display").m_128441_("Lore")) {
            builder.setLore(GuiElementBuilder.getLore(stack));
            tag.m_128469_("display").m_128473_("Lore");
        }
        if (stack.m_41768_()) {
            builder.setDamage(stack.m_41773_());
            tag.m_128473_("Damage");
        }
        if (stack.m_41793_()) {
            for (Tag enc : stack.m_41785_()) {
                Registry.f_122825_.m_6612_(ResourceLocation.m_135820_((String)((CompoundTag)enc).m_128461_("id"))).ifPresent(enchantment -> builder.enchant((Enchantment)enchantment, ((CompoundTag)enc).m_128451_("lvl")));
            }
            tag.m_128473_("Enchantments");
        }
        if (stack.m_41784_().m_128441_("HideFlags")) {
            builder.hideFlags(stack.m_41784_().m_128445_("HideFlags"));
            tag.m_128473_("HideFlags");
        }
        builder.tag = tag;
        return builder;
    }

    public static List<Component> getLore(ItemStack stack) {
        return stack.m_41737_("display").m_128437_("Lore", 8).stream().map(tag -> Component.Serializer.m_130701_((String)tag.m_7916_())).collect(Collectors.toList());
    }

    public GuiElementBuilder setItem(Item item) {
        this.item = item;
        return this;
    }

    public GuiElementBuilder setName(Component name) {
        this.name = name.m_6881_();
        return this;
    }

    public GuiElementBuilder setName(MutableComponent name) {
        return this.setName((Component)name);
    }

    public GuiElementBuilder setCount(int count) {
        this.count = count;
        return this;
    }

    public GuiElementBuilder setLore(List<Component> lore) {
        this.lore = lore;
        return this;
    }

    public GuiElementBuilder addLoreLine(Component lore) {
        this.lore.add(lore);
        return this;
    }

    public GuiElementBuilder setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public GuiElementBuilder hideFlags() {
        this.hideFlags = (byte)127;
        return this;
    }

    public GuiElementBuilder hideFlag(ItemStack.TooltipPart section) {
        this.hideFlags = (byte)(this.hideFlags | section.m_41809_());
        return this;
    }

    public GuiElementBuilder hideFlags(byte value) {
        this.hideFlags = value;
        return this;
    }

    public GuiElementBuilder enchant(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public GuiElementBuilder glow() {
        this.enchantments.put(Enchantments.f_44953_, 1);
        return this.hideFlag(ItemStack.TooltipPart.ENCHANTMENTS);
    }

    public GuiElementBuilder setCustomModelData(int value) {
        this.getOrCreateTag().m_128405_("CustomModelData", value);
        return this;
    }

    public GuiElementBuilder unbreakable() {
        this.getOrCreateTag().m_128379_("Unbreakable", true);
        return this.hideFlag(ItemStack.TooltipPart.UNBREAKABLE);
    }

    public GuiElementBuilder setSkullOwner(GameProfile profile, @Nullable MinecraftServer server) {
        if (profile.getId() != null && server != null) {
            profile = server.m_129925_().fillProfileProperties(profile, false);
            this.getOrCreateTag().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile));
        } else {
            this.getOrCreateTag().m_128359_("SkullOwner", profile.getName());
        }
        return this;
    }

    public GuiElementBuilder setSkullOwner(String value) {
        return this.setSkullOwner(value, null, null);
    }

    public GuiElementBuilder setSkullOwner(String value, @Nullable String signature, @Nullable UUID uuid) {
        CompoundTag skullOwner = new CompoundTag();
        CompoundTag properties = new CompoundTag();
        CompoundTag valueData = new CompoundTag();
        ListTag textures = new ListTag();
        valueData.m_128359_("Value", value);
        if (signature != null) {
            valueData.m_128359_("Signature", signature);
        }
        textures.add((Object)valueData);
        properties.m_128365_("textures", (Tag)textures);
        skullOwner.m_128365_("Id", (Tag)NbtUtils.m_129226_((UUID)(uuid != null ? uuid : Util.f_137441_)));
        skullOwner.m_128365_("Properties", (Tag)properties);
        this.getOrCreateTag().m_128365_("SkullOwner", (Tag)skullOwner);
        return this;
    }

    @Override
    public GuiElementBuilder setCallback(GuiElementInterface.ClickCallback callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public GuiElementBuilder setCallback(GuiElementInterface.ItemClickCallback callback) {
        this.callback = callback;
        return this;
    }

    public ItemStack asStack() {
        ItemStack itemStack = new ItemStack((ItemLike)this.item, this.count);
        if (this.tag != null) {
            itemStack.m_41784_().m_128391_(this.tag);
        }
        if (this.name != null) {
            if (this.name instanceof MutableComponent) {
                ((MutableComponent)this.name).m_130938_(style -> style.m_131155_(Boolean.valueOf(style.m_131161_())));
            }
            itemStack.m_41714_(this.name);
        }
        if (this.item.m_41465_() && this.damage != -1) {
            itemStack.m_41721_(this.damage);
        }
        for (Map.Entry<Enchantment, Integer> entry : this.enchantments.entrySet()) {
            itemStack.m_41663_(entry.getKey(), entry.getValue().intValue());
        }
        if (this.lore.size() > 0) {
            CompoundTag display = itemStack.m_41698_("display");
            ListTag loreItems = new ListTag();
            for (Component l : this.lore) {
                if (l instanceof MutableComponent) {
                    ((MutableComponent)l).m_130938_(style -> style.m_131155_(Boolean.valueOf(style.m_131161_())));
                }
                loreItems.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)l)));
            }
            display.m_128365_("Lore", (Tag)loreItems);
        }
        if (this.hideFlags != 0) {
            itemStack.m_41784_().m_128344_("HideFlags", this.hideFlags);
        }
        return itemStack;
    }

    protected CompoundTag getOrCreateTag() {
        if (this.tag == null) {
            this.tag = new CompoundTag();
        }
        return this.tag;
    }

    @Override
    public GuiElement build() {
        return new GuiElement(this.asStack(), this.callback);
    }
}

