/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.gui;

import eu.pb4.sgui.api.ScreenProperty;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface GuiInterface {
    public void setTitle(Component var1);

    @Nullable
    public Component getTitle();

    public MenuType<?> getType();

    public ServerPlayer getPlayer();

    public int getSyncId();

    public boolean isOpen();

    public boolean open();

    public boolean getAutoUpdate();

    public void setAutoUpdate(boolean var1);

    @ApiStatus.Internal
    public void close(boolean var1);

    default public void close() {
        this.close(false);
    }

    @Deprecated
    default public void onUpdate(boolean firstUpdate) {
    }

    default public void onOpen() {
        this.onUpdate(true);
    }

    default public void onClose() {
    }

    default public void onTick() {
    }

    default public void sendProperty(ScreenProperty property, int value) {
        if (!property.validFor(this.getType())) {
            throw new IllegalArgumentException(String.format("The property '%s' is not valid for the handler '%s'", property.name(), Registry.f_122863_.m_7447_(this.getType())));
        }
        if (this.isOpen()) {
            this.getPlayer().f_8906_.m_141995_((Packet)new ClientboundContainerSetDataPacket(this.getSyncId(), property.id(), value));
        }
    }
}

