/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.gui;

import eu.pb4.sgui.api.ClickActionType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.BaseSlotGui;
import eu.pb4.sgui.virtual.hotbar.HotbarScreenHandler;
import eu.pb4.sgui.virtual.inventory.VirtualSlot;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class HotbarGui
extends BaseSlotGui {
    public static final int SIZE = 46;
    public static final int[] VANILLA_HOTBAR_SLOT_IDS = HotbarGui.createArrayFromTo(36, 44);
    public static final int[] VANILLA_BACKPACK_SLOT_IDS = HotbarGui.createArrayFromTo(9, 35);
    public static final int[] VANILLA_ARMOR_SLOT_IDS = HotbarGui.createArrayFromTo(5, 8);
    public static final int VANILLA_OFFHAND_SLOT_ID = 45;
    public static final int[] VANILLA_CRAFTING_IDS = new int[]{1, 2, 3, 4, 0};
    public static final int[] GUI_TO_VANILLA_IDS = HotbarGui.mergeArrays(VANILLA_HOTBAR_SLOT_IDS, {45}, VANILLA_BACKPACK_SLOT_IDS, VANILLA_ARMOR_SLOT_IDS, VANILLA_CRAFTING_IDS);
    public static final int[] VANILLA_TO_GUI_IDS = HotbarGui.rotateArray(GUI_TO_VANILLA_IDS);
    protected int selectedSlot = 0;
    protected boolean hasRedirects = false;
    private HotbarScreenHandler screenHandler;
    private int clicksPerTick;

    public HotbarGui(ServerPlayer player) {
        super(player, 46);
    }

    private static int[] rotateArray(int[] input) {
        int[] array = new int[input.length];
        for (int i = 0; i < array.length; ++i) {
            array[input[i]] = i;
        }
        return array;
    }

    private static int[] createArrayFromTo(int first, int last) {
        IntArrayList list = new IntArrayList(last - first);
        for (int i = first; i <= last; ++i) {
            list.add(i);
        }
        return list.toIntArray();
    }

    private static int[] mergeArrays(int[] ... idArrays) {
        IntArrayList list = new IntArrayList(46);
        int[][] nArray = idArrays;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] array;
            for (int i2 : array = nArray[i]) {
                list.add(i2);
            }
        }
        return list.toIntArray();
    }

    @Override
    public void setSlot(int index, GuiElementInterface element) {
        super.setSlot(index, element);
        if (this.open && this.autoUpdate && this.screenHandler != null) {
            this.screenHandler.setSlot(GUI_TO_VANILLA_IDS[index], new VirtualSlot(this.screenHandler.inventory, index, 0, 0));
        }
    }

    @Override
    public void setSlotRedirect(int index, Slot slot) {
        super.setSlotRedirect(index, slot);
        if (this.open && this.autoUpdate && this.screenHandler != null) {
            this.screenHandler.setSlot(GUI_TO_VANILLA_IDS[index], slot);
        }
        this.hasRedirects = true;
    }

    @Override
    public void clearSlot(int index) {
        super.clearSlot(index);
        if (this.open && this.autoUpdate && this.screenHandler != null) {
            this.screenHandler.setSlot(GUI_TO_VANILLA_IDS[index], new VirtualSlot(this.screenHandler.inventory, index, 0, 0));
        }
    }

    @Override
    public boolean click(int index, ClickActionType type, ClickType action) {
        return super.click(VANILLA_TO_GUI_IDS[index], type, action);
    }

    @Override
    public boolean open() {
        if (this.player.m_9232_() || this.open) {
            return false;
        }
        this.open = true;
        this.onOpen();
        if (this.player.f_36096_ != this.player.f_36095_ && this.player.f_36096_ != this.screenHandler) {
            this.player.m_6915_();
        }
        if (this.screenHandler == null) {
            this.screenHandler = new HotbarScreenHandler(null, 0, this, (Player)this.player);
        }
        this.player.f_36096_ = this.screenHandler;
        GuiHelpers.sendPlayerScreenHandler(this.player);
        this.player.f_8906_.m_141995_((Packet)new ClientboundSetCarriedItemPacket(this.selectedSlot));
        return true;
    }

    public boolean onSelectedSlotChange(int slot) {
        this.setSelectedSlot(slot);
        return true;
    }

    public void onClickItem() {
        if (this.player.m_6144_()) {
            this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_RIGHT_SHIFT, ClickType.QUICK_MOVE);
        } else {
            this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_RIGHT, ClickType.PICKUP);
        }
    }

    public boolean onHandSwing() {
        if (this.player.m_6144_()) {
            this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_LEFT_SHIFT, ClickType.QUICK_MOVE);
        } else {
            this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_LEFT, ClickType.PICKUP);
        }
        return false;
    }

    public boolean onClickBlock(BlockHitResult hitResult) {
        if (this.player.m_6144_()) {
            this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_RIGHT_SHIFT, ClickType.QUICK_MOVE);
        } else {
            this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_RIGHT, ClickType.PICKUP);
        }
        return false;
    }

    public boolean onPlayerAction(ServerboundPlayerActionPacket.Action action, Direction direction) {
        switch (action) {
            case DROP_ITEM: {
                this.tickLimitedClick(this.selectedSlot, ClickActionType.DROP, ClickType.THROW);
                break;
            }
            case DROP_ALL_ITEMS: {
                this.tickLimitedClick(this.selectedSlot, ClickActionType.CTRL_DROP, ClickType.THROW);
                break;
            }
            case STOP_DESTROY_BLOCK: {
                if (this.player.m_6144_()) {
                    this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_LEFT_SHIFT, ClickType.QUICK_MOVE);
                    break;
                }
                this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_LEFT, ClickType.PICKUP);
                break;
            }
            case SWAP_ITEM_WITH_OFFHAND: {
                this.tickLimitedClick(this.selectedSlot, ClickActionType.OFFHAND_SWAP, ClickType.SWAP);
            }
        }
        return false;
    }

    public boolean onClickEntity(int entityId, EntityInteraction type, boolean isSneaking, @Nullable Vec3 interactionPos) {
        if (type == EntityInteraction.ATTACK) {
            if (isSneaking) {
                this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_LEFT_SHIFT, ClickType.QUICK_MOVE);
            } else {
                this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_LEFT, ClickType.PICKUP);
            }
        } else if (isSneaking) {
            this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_RIGHT_SHIFT, ClickType.QUICK_MOVE);
        } else {
            this.tickLimitedClick(this.selectedSlot, ClickActionType.MOUSE_RIGHT, ClickType.PICKUP);
        }
        return false;
    }

    public void setSelectedSlot(int value) {
        this.selectedSlot = Mth.m_14045_((int)value, (int)0, (int)8);
        if (this.open) {
            this.player.f_8906_.m_141995_((Packet)new ClientboundSetCarriedItemPacket(this.selectedSlot));
        }
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @ApiStatus.Internal
    private void tickLimitedClick(int selectedSlot, ClickActionType type, ClickType actionType) {
        if (this.clicksPerTick == 0) {
            this.click(GUI_TO_VANILLA_IDS[selectedSlot], type, actionType);
        }
        ++this.clicksPerTick;
    }

    @Override
    public void onTick() {
        this.clicksPerTick = 0;
        super.onTick();
    }

    @Override
    public void close(boolean screenHandlerIsClosed) {
        if (this.open && !this.reOpen) {
            this.open = false;
            this.reOpen = false;
            if (!screenHandlerIsClosed && this.player.f_36096_ == this.screenHandler) {
                this.player.m_6915_();
            }
            this.onClose();
            this.player.f_8906_.m_141995_((Packet)new ClientboundSetCarriedItemPacket(this.player.m_150109_().f_35977_));
            GuiHelpers.sendPlayerInventory(this.getPlayer());
        } else {
            this.reOpen = false;
        }
    }

    @Override
    public boolean isIncludingPlayer() {
        return true;
    }

    @Override
    public int getVirtualSize() {
        return 46;
    }

    @Override
    public boolean isRedirectingSlots() {
        return this.hasRedirects;
    }

    @Override
    public int getSyncId() {
        return 0;
    }

    @Override
    public int getSize() {
        return 46;
    }

    @Override
    @Deprecated
    public int getHeight() {
        return 4;
    }

    @Override
    @Deprecated
    public int getWidth() {
        return 9;
    }

    @Override
    @Deprecated
    public MenuType<?> getType() {
        return null;
    }

    @Override
    @Deprecated
    public boolean getLockPlayerInventory() {
        return true;
    }

    @Override
    @Deprecated
    public void setLockPlayerInventory(boolean value) {
    }

    @Override
    @Deprecated
    @Nullable
    public Component getTitle() {
        return null;
    }

    @Override
    @Deprecated
    public void setTitle(Component title) {
    }

    public static enum EntityInteraction {
        INTERACT,
        ATTACK,
        INTERACT_AT;

    }
}

