/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.gui;

import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.SlotHolder;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class SimpleGuiBuilder
implements SlotHolder {
    private final int size;
    private final int width;
    private final int height;
    private final MenuType<?> type;
    private final GuiElementInterface[] elements;
    private final Slot[] slotRedirects;
    private final boolean includePlayer;
    private final int sizeCont;
    private boolean lockPlayerInventory = false;
    private boolean hasRedirects = false;
    private Component title = null;

    public SimpleGuiBuilder(MenuType<?> type, boolean manipulatePlayerSlots) {
        this.height = GuiHelpers.getHeight(type);
        this.width = GuiHelpers.getWidth(type);
        this.type = type;
        int tmp = manipulatePlayerSlots ? 36 : 0;
        this.size = this.width * this.height + tmp;
        this.sizeCont = this.width * this.height;
        this.elements = new GuiElementInterface[this.size];
        this.slotRedirects = new Slot[this.size];
        this.includePlayer = manipulatePlayerSlots;
    }

    public SimpleGui build(ServerPlayer player) {
        SimpleGui gui = new SimpleGui(this.type, player, this.includePlayer);
        gui.setTitle(this.title);
        gui.setLockPlayerInventory(true);
        int pos = 0;
        for (GuiElementInterface guiElementInterface : this.elements) {
            if (guiElementInterface != null) {
                gui.setSlot(pos, guiElementInterface);
            }
            ++pos;
        }
        pos = 0;
        for (GuiElementInterface guiElementInterface : this.slotRedirects) {
            if (guiElementInterface != null) {
                gui.setSlotRedirect(pos, (Slot)guiElementInterface);
            }
            ++pos;
        }
        return gui;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setSlot(int index, GuiElementInterface element) {
        this.elements[index] = element;
    }

    @Override
    public void addSlot(GuiElementInterface element) {
        this.setSlot(this.getFirstEmptySlot(), element);
    }

    @Override
    public void setSlot(int index, ItemStack itemStack) {
        this.setSlot(index, new GuiElement(itemStack, GuiElementInterface.EMPTY_CALLBACK));
    }

    @Override
    public void addSlot(ItemStack itemStack) {
        this.setSlot(this.getFirstEmptySlot(), itemStack);
    }

    @Override
    public void setSlot(int index, GuiElementBuilderInterface<?> element) {
        this.setSlot(index, element.build());
    }

    @Override
    public void addSlot(GuiElementBuilderInterface<?> element) {
        this.setSlot(this.getFirstEmptySlot(), element.build());
    }

    @Override
    public void setSlot(int index, ItemStack itemStack, GuiElementInterface.ClickCallback callback) {
        this.setSlot(index, new GuiElement(itemStack, callback));
    }

    @Override
    public void setSlot(int index, ItemStack itemStack, GuiElementInterface.ItemClickCallback callback) {
        this.setSlot(index, new GuiElement(itemStack, callback));
    }

    @Override
    public void addSlot(ItemStack itemStack, GuiElementInterface.ClickCallback callback) {
        this.setSlot(this.getFirstEmptySlot(), new GuiElement(itemStack, callback));
    }

    @Override
    public void addSlot(ItemStack itemStack, GuiElementInterface.ItemClickCallback callback) {
        this.setSlot(this.getFirstEmptySlot(), new GuiElement(itemStack, callback));
    }

    @Override
    public void setSlotRedirect(int index, Slot slot) {
        this.elements[index] = null;
        this.slotRedirects[index] = slot;
        this.hasRedirects = true;
    }

    @Override
    public void addSlotRedirect(Slot slot) {
        this.setSlotRedirect(this.getFirstEmptySlot(), slot);
    }

    @Override
    public int getFirstEmptySlot() {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] != null || this.slotRedirects[i] != null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void clearSlot(int index) {
        this.elements[index] = null;
        this.slotRedirects[index] = null;
    }

    @Override
    public boolean isIncludingPlayer() {
        return this.includePlayer;
    }

    @Override
    public int getVirtualSize() {
        return this.sizeCont;
    }

    @Override
    public GuiElementInterface getSlot(int index) {
        if (index >= 0 && index < this.size) {
            return this.elements[index];
        }
        return null;
    }

    @Override
    public Slot getSlotRedirect(int index) {
        if (index >= 0 && index < this.size) {
            return this.slotRedirects[index];
        }
        return null;
    }

    @Override
    public boolean isRedirectingSlots() {
        return this.hasRedirects;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public MenuType<?> getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public boolean getLockPlayerInventory() {
        return this.lockPlayerInventory || this.includePlayer;
    }

    public void setLockPlayerInventory(boolean value) {
        this.lockPlayerInventory = value;
    }
}

