/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.mixin;

import eu.pb4.sgui.api.ClickActionType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.gui.HotbarGui;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import eu.pb4.sgui.virtual.VirtualScreenHandlerInterface;
import eu.pb4.sgui.virtual.hotbar.HotbarScreenHandler;
import eu.pb4.sgui.virtual.inventory.VirtualScreenHandler;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerPlayNetworkHandlerMixin {
    @Unique
    private AbstractContainerMenu sgui_previousScreen = null;
    @Shadow
    public ServerPlayer f_9743_;

    @Shadow
    public abstract void m_141995_(Packet<?> var1);

    @Shadow
    public abstract void m_9831_(Packet<?> var1, @Nullable GenericFutureListener<? extends Future<? super Void>> var2);

    @Inject(method={"handleContainerClick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER)}, cancellable=true)
    private void sgui_handleGuiClicks(ServerboundContainerClickPacket packet, CallbackInfo ci) {
        AbstractContainerMenu abstractContainerMenu = this.f_9743_.f_36096_;
        if (abstractContainerMenu instanceof VirtualScreenHandler) {
            VirtualScreenHandler handler = (VirtualScreenHandler)abstractContainerMenu;
            try {
                SlotGuiInterface gui = handler.getGui();
                int slot = packet.m_133962_();
                int button = packet.m_133963_();
                ClickActionType type = ClickActionType.toClickType(packet.m_133966_(), button, slot);
                boolean ignore = gui.onAnyClick(slot, type, packet.m_133966_());
                if (ignore && !handler.getGui().getLockPlayerInventory() && (slot >= handler.getGui().getSize() || slot < 0 || handler.getGui().getSlotRedirect(slot) != null)) {
                    if (type == ClickActionType.MOUSE_DOUBLE_CLICK || type.isDragging && type.value == 2) {
                        GuiHelpers.sendPlayerScreenHandler(this.f_9743_);
                    }
                    return;
                }
                boolean allow = gui.click(slot, type, packet.m_133966_());
                if (handler.getGui().isOpen() && !allow) {
                    if (slot >= 0 && slot < handler.getGui().getSize()) {
                        this.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(handler.f_38840_, handler.m_182425_(), slot, handler.m_38853_(slot).m_7993_()));
                    }
                    GuiHelpers.sendSlotUpdate(this.f_9743_, -1, -1, this.f_9743_.f_36096_.m_142621_(), handler.m_182424_());
                    if (type.numKey) {
                        int x = type.value + handler.f_38839_.size() - 10;
                        GuiHelpers.sendSlotUpdate(this.f_9743_, handler.f_38840_, x, handler.m_38853_(x).m_7993_(), handler.m_182425_());
                    } else if (type == ClickActionType.MOUSE_DOUBLE_CLICK || type == ClickActionType.MOUSE_LEFT_SHIFT || type == ClickActionType.MOUSE_RIGHT_SHIFT || type.isDragging && type.value == 2) {
                        GuiHelpers.sendPlayerScreenHandler(this.f_9743_);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ci.cancel();
            }
            ci.cancel();
        }
    }

    @Inject(method={"handleContainerClick"}, at={@At(value="TAIL")})
    private void sgui_resyncGui(ServerboundContainerClickPacket packet, CallbackInfo ci) {
        if (this.f_9743_.f_36096_ instanceof VirtualScreenHandler) {
            try {
                int slot = packet.m_133962_();
                int button = packet.m_133963_();
                ClickActionType type = ClickActionType.toClickType(packet.m_133966_(), button, slot);
                if (type == ClickActionType.MOUSE_DOUBLE_CLICK || type.isDragging && type.value == 2 || type.shift) {
                    GuiHelpers.sendPlayerScreenHandler(this.f_9743_);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Inject(method={"handleContainerClose"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE)})
    private void sgui_storeScreenHandler(ServerboundContainerClosePacket packet, CallbackInfo info) {
        if (this.f_9743_.f_36096_ instanceof VirtualScreenHandlerInterface) {
            this.sgui_previousScreen = this.f_9743_.f_36096_;
        }
    }

    @Inject(method={"handleContainerClose"}, at={@At(value="TAIL")})
    private void sgui_executeClosing(ServerboundContainerClosePacket packet, CallbackInfo info) {
        try {
            AbstractContainerMenu abstractContainerMenu;
            if (this.sgui_previousScreen != null && (abstractContainerMenu = this.sgui_previousScreen) instanceof VirtualScreenHandlerInterface) {
                VirtualScreenHandlerInterface screenHandler = (VirtualScreenHandlerInterface)abstractContainerMenu;
                screenHandler.getGui().close(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sgui_previousScreen = null;
    }

    @Inject(method={"handlePlaceRecipe"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE)}, cancellable=true)
    private void sgui_catchRecipeRequests(ServerboundPlaceRecipePacket packet, CallbackInfo ci) {
        VirtualScreenHandler handler;
        Object object = this.f_9743_.f_36096_;
        if (object instanceof VirtualScreenHandler && (object = (handler = (VirtualScreenHandler)object).getGui()) instanceof SimpleGui) {
            SimpleGui gui = (SimpleGui)object;
            try {
                gui.onCraftRequest(packet.m_134252_(), packet.m_134253_());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Inject(method={"handleSetCarriedItem"}, at={@At(value="INVOKE", shift=At.Shift.AFTER)}, cancellable=true)
    private void sgui_catchUpdateSelectedSlot(ServerboundSetCarriedItemPacket packet, CallbackInfo ci) {
        AbstractContainerMenu abstractContainerMenu = this.f_9743_.f_36096_;
        if (abstractContainerMenu instanceof HotbarScreenHandler) {
            HotbarScreenHandler handler = (HotbarScreenHandler)abstractContainerMenu;
            if (!handler.getGui().onSelectedSlotChange(packet.m_134498_())) {
                this.m_141995_((Packet<?>)new ClientboundSetCarriedItemPacket(handler.getGui().getSelectedSlot()));
            }
            ci.cancel();
        }
    }

    @Inject(method={"handleSetCreativeModeSlot"}, at={@At(value="INVOKE", shift=At.Shift.AFTER)}, cancellable=true)
    private void sgui_cancelCreativeAction(ServerboundSetCreativeModeSlotPacket packet, CallbackInfo ci) {
        if (this.f_9743_.f_36096_ instanceof VirtualScreenHandlerInterface) {
            ci.cancel();
        }
    }

    @Inject(method={"handleAnimate"}, at={@At(value="INVOKE", shift=At.Shift.AFTER)}, cancellable=true)
    private void sgui_clickHandSwing(ServerboundSwingPacket packet, CallbackInfo ci) {
        HotbarScreenHandler screenHandler;
        HotbarGui gui;
        AbstractContainerMenu abstractContainerMenu = this.f_9743_.f_36096_;
        if (abstractContainerMenu instanceof HotbarScreenHandler && !(gui = (screenHandler = (HotbarScreenHandler)abstractContainerMenu).getGui()).onHandSwing()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleUseItem"}, at={@At(value="INVOKE", shift=At.Shift.AFTER)}, cancellable=true)
    private void sgui_clickWithItem(ServerboundUseItemPacket packet, CallbackInfo ci) {
        AbstractContainerMenu abstractContainerMenu = this.f_9743_.f_36096_;
        if (abstractContainerMenu instanceof HotbarScreenHandler) {
            HotbarScreenHandler screenHandler = (HotbarScreenHandler)abstractContainerMenu;
            HotbarGui gui = screenHandler.getGui();
            if (screenHandler.slotsOld != null) {
                screenHandler.slotsOld.set(gui.getSelectedSlot() + 36, (Object)ItemStack.f_41583_);
                screenHandler.slotsOld.set(45, (Object)ItemStack.f_41583_);
            }
            gui.onClickItem();
            ci.cancel();
        }
    }

    @Inject(method={"handleUseItemOn"}, at={@At(value="INVOKE", shift=At.Shift.AFTER)}, cancellable=true)
    private void sgui_clickOnBlock(ServerboundUseItemOnPacket packet, CallbackInfo ci) {
        HotbarScreenHandler screenHandler;
        HotbarGui gui;
        AbstractContainerMenu abstractContainerMenu = this.f_9743_.f_36096_;
        if (abstractContainerMenu instanceof HotbarScreenHandler && !(gui = (screenHandler = (HotbarScreenHandler)abstractContainerMenu).getGui()).onClickBlock(packet.m_134706_())) {
            BlockPos pos = packet.m_134706_().m_82425_();
            if (screenHandler.slotsOld != null) {
                screenHandler.slotsOld.set(gui.getSelectedSlot() + 36, (Object)ItemStack.f_41583_);
                screenHandler.slotsOld.set(45, (Object)ItemStack.f_41583_);
            }
            this.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.f_9743_.f_19853_.m_8055_(pos)));
            pos = pos.m_142300_(packet.m_134706_().m_82434_());
            this.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.f_9743_.f_19853_.m_8055_(pos)));
            ci.cancel();
        }
    }

    @Inject(method={"handlePlayerAction"}, at={@At(value="INVOKE", shift=At.Shift.AFTER)}, cancellable=true)
    private void sgui_onPlayerAction(ServerboundPlayerActionPacket packet, CallbackInfo ci) {
        HotbarScreenHandler screenHandler;
        HotbarGui gui;
        AbstractContainerMenu abstractContainerMenu = this.f_9743_.f_36096_;
        if (abstractContainerMenu instanceof HotbarScreenHandler && !(gui = (screenHandler = (HotbarScreenHandler)abstractContainerMenu).getGui()).onPlayerAction(packet.m_134285_(), packet.m_134284_())) {
            BlockPos pos = packet.m_134281_();
            if (screenHandler.slotsOld != null) {
                screenHandler.slotsOld.set(gui.getSelectedSlot() + 36, (Object)ItemStack.f_41583_);
                screenHandler.slotsOld.set(45, (Object)ItemStack.f_41583_);
            }
            this.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.f_9743_.f_19853_.m_8055_(pos)));
            pos = pos.m_142300_(packet.m_134284_());
            this.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.f_9743_.f_19853_.m_8055_(pos)));
            ci.cancel();
        }
    }

    @Inject(method={"handleInteract"}, at={@At(value="INVOKE", shift=At.Shift.AFTER)}, cancellable=true)
    private void sgui_clickOnEntity(ServerboundInteractPacket packet, CallbackInfo ci) {
        AbstractContainerMenu abstractContainerMenu = this.f_9743_.f_36096_;
        if (abstractContainerMenu instanceof HotbarScreenHandler) {
            HotbarScreenHandler screenHandler = (HotbarScreenHandler)abstractContainerMenu;
            HotbarGui gui = screenHandler.getGui();
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_5779_(buf);
            int entityId = buf.m_130242_();
            HotbarGui.EntityInteraction type = (HotbarGui.EntityInteraction)buf.m_130066_(HotbarGui.EntityInteraction.class);
            Vec3 interactionPos = null;
            switch (type) {
                case INTERACT: {
                    buf.m_130242_();
                    break;
                }
                case INTERACT_AT: {
                    interactionPos = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
                    buf.m_130242_();
                }
            }
            boolean isSneaking = buf.readBoolean();
            if (!gui.onClickEntity(entityId, type, isSneaking, interactionPos)) {
                if (screenHandler.slotsOld != null) {
                    screenHandler.slotsOld.set(gui.getSelectedSlot() + 36, (Object)ItemStack.f_41583_);
                    screenHandler.slotsOld.set(45, (Object)ItemStack.f_41583_);
                }
                ci.cancel();
            }
        }
    }
}

