/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.data.provider;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import iskallia.auxiliaryblocks.data.ModBlockLoot;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;

public class ModBlockLootProvider
implements DataProvider {
    List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> subProviders;
    private final DataGenerator generator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ModBlockLootProvider(DataGenerator dataGenerator) {
        this.generator = dataGenerator;
        this.subProviders = List.of(Pair.of(ModBlockLoot::new, (Object)LootContextParamSets.f_81421_));
    }

    public void m_6865_(@NotNull HashCache hashCache) {
        Path path = this.generator.m_123916_();
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(pair -> ((Consumer)((Supplier)pair.getFirst()).get()).accept((resourceLocation, builder) -> {
            if (map.put(resourceLocation, builder.m_79165_((LootContextParamSet)pair.getSecond()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(resourceLocation));
            }
        }));
        map.forEach((location, lootTable) -> {
            Path path2 = ModBlockLootProvider.createPath(path, location);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)hashCache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public String m_6055_() {
        return "ModLootTables";
    }

    private static Path createPath(Path path, ResourceLocation resourceLocation) {
        return path.resolve("data/" + resourceLocation.m_135827_() + "/loot_tables/" + resourceLocation.m_135815_() + ".json");
    }
}

