/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.data.provider;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.auxiliaryblocks.init.ModBlocks;
import iskallia.auxiliaryblocks.init.ModRegistries;
import iskallia.auxiliaryblocks.tags.ModTags;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator dataGenerator;

    public ModRecipeProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
        this.dataGenerator = dataGenerator;
    }

    private void addRecipes(Consumer<FinishedRecipe> consumer) {
        ModRecipeProvider.registerStonecutterRecipes(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.ASPHALT.get()), (int)4).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_126209_((ItemLike)Blocks.f_50069_).m_142284_(ModRecipeProvider.getHas(ModTags.CONCRETE_POWDER), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike(ModTags.CONCRETE_POWDER)).m_176500_(consumer, ModBlocks.ASPHALT.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.LAB_LIGHT_GRAY.get()), (int)4).m_126211_((ItemLike)Blocks.f_50069_, 2).m_126211_((ItemLike)Blocks.f_50470_, 2).m_142284_(ModRecipeProvider.getHas((ItemLike)Blocks.f_50470_), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)Blocks.f_50470_)).m_176500_(consumer, ModBlocks.LAB_LIGHT_GRAY.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.CONCRETE.get()), (int)4).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_142284_(ModRecipeProvider.getHas(ModTags.CONCRETE_POWDER), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike(ModTags.CONCRETE_POWDER)).m_176500_(consumer, ModBlocks.CONCRETE.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.SHEET_METAL.get()), (int)4).m_126209_((ItemLike)Blocks.f_50069_).m_126211_((ItemLike)Blocks.f_50183_, 3).m_142284_(ModRecipeProvider.getHas((ItemLike)Blocks.f_50183_), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)Blocks.f_50183_)).m_176500_(consumer, ModBlocks.SHEET_METAL.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.GRAY_PASTEL.get()), (int)4).m_126211_((ItemLike)Blocks.f_49992_, 3).m_126209_((ItemLike)Items.f_42490_).m_142284_(ModRecipeProvider.getHas((ItemLike)Blocks.f_49992_), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)Blocks.f_49992_)).m_176500_(consumer, ModBlocks.GRAY_PASTEL.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.PLASTIC.get()), (int)4).m_126211_((ItemLike)Blocks.f_49992_, 3).m_126209_((ItemLike)Items.f_41904_).m_142284_(ModRecipeProvider.getHas((ItemLike)Blocks.f_49992_), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)Blocks.f_49992_)).m_176500_(consumer, ModBlocks.PLASTIC.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.COBBLED_SANDSTONE.get()), (int)4).m_126211_((ItemLike)Blocks.f_49992_, 2).m_126211_((ItemLike)Blocks.f_50062_, 2).m_142284_(ModRecipeProvider.getHas((ItemLike)Blocks.f_50062_), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)Blocks.f_50062_)).m_176500_(consumer, ModBlocks.COBBLED_SANDSTONE.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.WHITE_CRYSTAL.get()), (int)4).m_126211_((ItemLike)Items.f_151049_, 3).m_126209_((ItemLike)Items.f_41904_).m_142284_(ModRecipeProvider.getHas((ItemLike)Items.f_151049_), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)Items.f_151049_)).m_176500_(consumer, ModBlocks.WHITE_CRYSTAL.getId().m_135815_());
        this.buildGlassRecipe(consumer, ModBlocks.BLACK_FRAMELESS_GLASS, (ItemLike)Blocks.f_50215_);
        this.buildGlassRecipe(consumer, ModBlocks.BLUE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50211_);
        this.buildGlassRecipe(consumer, ModBlocks.BROWN_FRAMELESS_GLASS, (ItemLike)Blocks.f_50212_);
        this.buildGlassRecipe(consumer, ModBlocks.CYAN_FRAMELESS_GLASS, (ItemLike)Blocks.f_50209_);
        this.buildGlassRecipe(consumer, ModBlocks.GRAY_FRAMELESS_GLASS, (ItemLike)Blocks.f_50207_);
        this.buildGlassRecipe(consumer, ModBlocks.GREEN_FRAMELESS_GLASS, (ItemLike)Blocks.f_50213_);
        this.buildGlassRecipe(consumer, ModBlocks.LIGHT_BLUE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50203_);
        this.buildGlassRecipe(consumer, ModBlocks.LIGHT_GRAY_FRAMELESS_GLASS, (ItemLike)Blocks.f_50208_);
        this.buildGlassRecipe(consumer, ModBlocks.LIME_FRAMELESS_GLASS, (ItemLike)Blocks.f_50205_);
        this.buildGlassRecipe(consumer, ModBlocks.MAGENTA_FRAMELESS_GLASS, (ItemLike)Blocks.f_50202_);
        this.buildGlassRecipe(consumer, ModBlocks.ORANGE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50148_);
        this.buildGlassRecipe(consumer, ModBlocks.PINK_FRAMELESS_GLASS, (ItemLike)Blocks.f_50206_);
        this.buildGlassRecipe(consumer, ModBlocks.PURPLE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50210_);
        this.buildGlassRecipe(consumer, ModBlocks.RED_FRAMELESS_GLASS, (ItemLike)Blocks.f_50214_);
        this.buildGlassRecipe(consumer, ModBlocks.WHITE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50147_);
        this.buildGlassRecipe(consumer, ModBlocks.YELLOW_FRAMELESS_GLASS, (ItemLike)Blocks.f_50204_);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.RED_GELATIN.get()), (int)4).m_126211_((ItemLike)Items.f_42204_, 2).m_126209_((ItemLike)Items.f_42023_).m_126209_((ItemLike)Items.f_42054_).m_142284_(ModRecipeProvider.getHas((ItemLike)Items.f_42204_), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)Items.f_42204_)).m_176500_(consumer, ModBlocks.RED_GELATIN.getId().m_135815_());
        this.buildStair(consumer, ModBlocks.GLOOMY_DIRT_STAIR, (ItemLike)ModBlocks.GLOOMY_DIRT.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_GRAVEL_STAIR, (ItemLike)ModBlocks.GLOOMY_GRAVEL.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_STONE_STAIR, (ItemLike)ModBlocks.GLOOMY_STONE.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_COBBLESTONE_STAIR, (ItemLike)ModBlocks.GLOOMY_COBBLESTONE.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_BRICKS_STAIR, (ItemLike)ModBlocks.GLOOMY_BRICKS.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_CRACKED_BRICKS_STAIR, (ItemLike)ModBlocks.GLOOMY_CRACKED_BRICKS.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_ANDESITE_STAIR, (ItemLike)ModBlocks.GLOOMY_ANDESITE.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_DARK_ANDESITE_STAIR, (ItemLike)ModBlocks.GLOOMY_DARK_ANDESITE.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_DARK_STONE_STAIR, (ItemLike)ModBlocks.GLOOMY_DARK_STONE_STAIR.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_DARK_COBBLESTONE_STAIR, (ItemLike)ModBlocks.GLOOMY_DARK_COBBLESTONE.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_CRUSHED_ROCKS_STAIR, (ItemLike)ModBlocks.GLOOMY_CRUSHED_ROCKS.get());
        this.buildStair(consumer, ModBlocks.GLOOMY_STAIRS, (ItemLike)ModBlocks.GLOOMY_PLANKS.get());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.GLOOMY_PLANKS.get()), (int)4).m_126209_((ItemLike)ModBlocks.GLOOMY_LOG.get()).m_142284_(ModRecipeProvider.getHas((ItemLike)ModBlocks.GLOOMY_LOG.get()), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)ModBlocks.GLOOMY_LOG.get())).m_176500_(consumer, ModBlocks.GLOOMY_PLANKS.getId().m_135815_());
        this.buildSlab(consumer, ModBlocks.GLOOMY_DIRT_SLAB, (ItemLike)ModBlocks.GLOOMY_DIRT.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_GRAVEL_SLAB, (ItemLike)ModBlocks.GLOOMY_GRAVEL.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_STONE_SLAB, (ItemLike)ModBlocks.GLOOMY_STONE.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_COBBLESTONE_SLAB, (ItemLike)ModBlocks.GLOOMY_COBBLESTONE.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_BRICKS_SLAB, (ItemLike)ModBlocks.GLOOMY_BRICKS.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_CRACKED_BRICKS_SLAB, (ItemLike)ModBlocks.GLOOMY_CRACKED_BRICKS.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_ANDESITE_SLAB, (ItemLike)ModBlocks.GLOOMY_ANDESITE.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_DARK_ANDESITE_SLAB, (ItemLike)ModBlocks.GLOOMY_DARK_ANDESITE.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_DARK_STONE_SLAB, (ItemLike)ModBlocks.GLOOMY_DARK_STONE_STAIR.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_DARK_COBBLESTONE_SLAB, (ItemLike)ModBlocks.GLOOMY_DARK_COBBLESTONE.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_CRUSHED_ROCKS_SLAB, (ItemLike)ModBlocks.GLOOMY_CRUSHED_ROCKS.get());
        this.buildSlab(consumer, ModBlocks.GLOOMY_SLAB, (ItemLike)ModBlocks.GLOOMY_PLANKS.get());
        ModRecipeProvider.m_176678_((ItemLike)((ItemLike)ModBlocks.GLOOMY_FENCE.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.GLOOMY_PLANKS.get()})).m_142284_(ModRecipeProvider.getHas((ItemLike)ModBlocks.GLOOMY_PLANKS.get()), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)ModBlocks.GLOOMY_PLANKS.get())).m_176498_(consumer);
        ModRecipeProvider.m_176684_((ItemLike)((ItemLike)ModBlocks.GLOOMY_FENCE_GATE.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.GLOOMY_PLANKS.get()})).m_142284_(ModRecipeProvider.getHas((ItemLike)ModBlocks.GLOOMY_PLANKS.get()), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)ModBlocks.GLOOMY_PLANKS.get())).m_176498_(consumer);
        ModRecipeProvider.m_176720_((ItemLike)((ItemLike)ModBlocks.GLOOMY_TRAPDOOR.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.GLOOMY_PLANKS.get()})).m_142284_(ModRecipeProvider.getHas((ItemLike)ModBlocks.GLOOMY_PLANKS.get()), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike((ItemLike)ModBlocks.GLOOMY_PLANKS.get())).m_176498_(consumer);
    }

    private void buildStair(Consumer<FinishedRecipe> consumer, RegistryObject<StairBlock> result, ItemLike ingredient) {
        ModRecipeProvider.m_176710_((ItemLike)((ItemLike)result.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).m_142284_(ModRecipeProvider.getHas(ingredient), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike(ingredient)).m_176500_(consumer, result.getId().m_135815_());
        ModRecipeProvider.m_176735_(consumer, (ItemLike)((ItemLike)result.get()), (ItemLike)ingredient);
    }

    private void buildSlab(Consumer<FinishedRecipe> consumer, RegistryObject<SlabBlock> result, ItemLike ingredient) {
        ModRecipeProvider.m_176704_((ItemLike)((ItemLike)result.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).m_142284_(ModRecipeProvider.getHas(ingredient), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike(ingredient)).m_176500_(consumer, result.getId().m_135815_());
        ModRecipeProvider.m_176546_(consumer, (ItemLike)((ItemLike)result.get()), (ItemLike)ingredient, (int)2);
    }

    private void buildGlassRecipe(Consumer<FinishedRecipe> consumer, RegistryObject<Block> result, ItemLike ingredient) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)8).m_126127_(Character.valueOf('g'), ingredient).m_126130_("ggg").m_126130_("g g").m_126130_("ggg").m_142284_(ModRecipeProvider.getHas(ingredient), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike(ingredient)).m_176500_(consumer, result.getId().m_135815_());
    }

    public static void registerStonecutterRecipes(Consumer<FinishedRecipe> consumer) {
        ModRegistries.BLOCK_CATEGORIES.forEach((resourceLocation, category) -> category.getVariations().forEach(variation -> ModRecipeProvider.getStonecutterRecipe(consumer, (ItemLike)variation.get(), (ItemLike)((RegistryObject)category.getBase()).get())));
    }

    private static void getStonecutterRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike ingredient) {
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (ItemLike)result).m_142284_(ModRecipeProvider.getHas(ingredient), (CriterionTriggerInstance)ModRecipeProvider.hasItemLike(ingredient)).m_176500_(consumer, ModRecipeProvider.getConversionName(result, ingredient));
    }

    public void m_6865_(@NotNull HashCache hashCache) {
        Path path = this.dataGenerator.m_123916_();
        HashSet set = Sets.newHashSet();
        this.addRecipes(finishedRecipe -> {
            if (!set.add(finishedRecipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(finishedRecipe.m_6445_()));
            }
            JsonObject recipe = finishedRecipe.m_125966_();
            ModRecipeProvider.saveRecipe(hashCache, recipe, path.resolve("data/auxiliaryblocks/recipes/" + finishedRecipe.m_6445_().m_135815_() + ".json"));
            JsonObject jsonObject = finishedRecipe.m_5860_();
            if (jsonObject != null) {
                this.saveAdv(hashCache, jsonObject, path.resolve("data/auxiliaryblocks/advancements/" + Objects.requireNonNull(finishedRecipe.m_6448_()).m_135815_() + ".json"));
            }
        });
    }

    private static void saveRecipe(HashCache hashCache, JsonObject jsonObject, Path path) {
        ModRecipeProvider.save(hashCache, jsonObject, path);
    }

    private void saveAdv(HashCache hashCache, JsonObject jsonObject, Path path) {
        ModRecipeProvider.save(hashCache, jsonObject, path);
    }

    private static void save(HashCache hashCache, JsonObject jsonObject, Path path) {
        try {
            String jsonString = GSON.toJson((JsonElement)jsonObject);
            String hashed = f_123918_.hashUnencodedChars((CharSequence)jsonString).toString();
            if (!Objects.equals(hashCache.m_123938_(path), hashed) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);
                try {
                    bufferedWriter.write(jsonString);
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            hashCache.m_123940_(path, hashed);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getConversionName(ItemLike result, ItemLike ingredient) {
        String resultName = ModRecipeProvider.getItem(result);
        return resultName + "_from_" + ModRecipeProvider.getItem(ingredient);
    }

    private static String getHas(ItemLike item) {
        return "has_" + ModRecipeProvider.getItem(item);
    }

    private static String getHas(TagKey<Item> tag) {
        return "has_" + tag.f_203868_().m_135815_();
    }

    protected static InventoryChangeTrigger.TriggerInstance hasItemLike(TagKey<Item> arg) {
        return ModRecipeProvider.inventoryTriggerInstance(ItemPredicate.Builder.m_45068_().m_204145_(arg).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance hasItemLike(ItemLike itemLike) {
        return ModRecipeProvider.inventoryTriggerInstance(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemLike}).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance inventoryTriggerInstance(ItemPredicate ... itemPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, itemPredicates);
    }

    private static String getItem(ItemLike itemLike) {
        return Registry.f_122827_.m_7981_((Object)itemLike.m_5456_()).m_135815_();
    }
}

