/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.init;

import iskallia.auxiliaryblocks.AuxiliaryBlocks;
import iskallia.auxiliaryblocks.entity.GingerbreadManEntity;
import iskallia.auxiliaryblocks.entity.SnowdoodEntity;
import iskallia.auxiliaryblocks.entity.model.GingerbreadManModel;
import iskallia.auxiliaryblocks.entity.model.SnowdoodModel;
import iskallia.auxiliaryblocks.entity.projectile.StrongSnowball;
import iskallia.auxiliaryblocks.init.ModModelLayers;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntities {
    private static final Map<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>> ATTRIBUTE_BUILDERS = new HashMap<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>();
    public static EntityType<GingerbreadManEntity> GINGERBREAD_MAN;
    public static EntityType<GingerbreadManEntity> GINGERBREAD_MAN_SMALL;
    public static EntityType<GingerbreadManEntity> GINGERBREAD_MAN_GIANT;
    public static EntityType<SnowdoodEntity> SNOWDOOD;
    public static EntityType<StrongSnowball> STRONG_SNOWBALL;

    public static void register(RegistryEvent.Register<EntityType<?>> event) {
        GINGERBREAD_MAN = ModEntities.registerLiving("gingerbread_man", EntityType.Builder.m_20704_(GingerbreadManEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f), () -> Zombie.m_34328_().m_22268_(Attributes.f_22279_, (double)0.28f), event);
        GINGERBREAD_MAN_SMALL = ModEntities.registerLiving("gingerbread_man_small", EntityType.Builder.m_20704_(GingerbreadManEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.3f, 0.975f), () -> Zombie.m_34328_().m_22268_(Attributes.f_22279_, (double)0.38f), event);
        GINGERBREAD_MAN_GIANT = ModEntities.registerLiving("gingerbread_man_giant", EntityType.Builder.m_20704_(GingerbreadManEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.5f, 4.875f), () -> Zombie.m_34328_().m_22268_(Attributes.f_22279_, (double)0.18f), event);
        SNOWDOOD = ModEntities.registerLiving("snowdood", EntityType.Builder.m_20704_(SnowdoodEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.0f), () -> Zombie.m_34328_().m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22283_, 1.0), event);
        STRONG_SNOWBALL = ModEntities.register("strong_snowball", EntityType.Builder.m_20704_(StrongSnowball::new, (MobCategory)MobCategory.MISC), event);
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        ATTRIBUTE_BUILDERS.forEach((e, b) -> event.put(e, ((AttributeSupplier.Builder)b.get()).m_22265_()));
        ATTRIBUTE_BUILDERS.clear();
    }

    private static <T extends LivingEntity> EntityType<T> registerLiving(String name, EntityType.Builder<T> builder, Supplier<AttributeSupplier.Builder> attributes, RegistryEvent.Register<EntityType<?>> event) {
        EntityType<T> entityType = ModEntities.register(name, builder, event);
        if (attributes != null) {
            ATTRIBUTE_BUILDERS.put(entityType, attributes);
        }
        return entityType;
    }

    private static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> builder, RegistryEvent.Register<EntityType<?>> event) {
        EntityType entityType = builder.m_20712_(AuxiliaryBlocks.id(name).toString());
        event.getRegistry().register((IForgeRegistryEntry)((EntityType)entityType.setRegistryName(AuxiliaryBlocks.id(name))));
        return entityType;
    }

    public static class Models {
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(ModModelLayers.GINGERBREAD_MAN, GingerbreadManModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.SNOWDOOD, SnowdoodModel::createBodyLayer);
        }
    }
}

