/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.mixin;

import iskallia.auxiliaryblocks.mixin.plugin.WaterloggingHelper;
import iskallia.auxiliaryblocks.tags.ModTags;
import iskallia.auxiliaryblocks.util.FluidStateHelper;
import iskallia.auxiliaryblocks.util.ModBlockStateProperties;
import iskallia.auxiliaryblocks.util.WaterColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BigDripleafBlock.class})
public class BigDripleafBlockMixin {
    @Inject(method={"createBlockStateDefinition"}, at={@At(value="RETURN")})
    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        builder.m_61104_(new Property[]{ModBlockStateProperties.WATER_COLOR});
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="RETURN")}, cancellable=true)
    public void getStateForPlacement(BlockPlaceContext context, CallbackInfoReturnable<BlockState> cir) {
        WaterloggingHelper.applyWaterColorState(context, cir);
    }

    @Inject(method={"getFluidState"}, at={@At(value="RETURN")}, cancellable=true)
    public void getFluidState(BlockState state, CallbackInfoReturnable<FluidState> cir) {
        cir.setReturnValue((Object)FluidStateHelper.getFluidState(state));
    }

    @Redirect(method={"updateShape"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;scheduleTick(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/Fluid;I)V"))
    public void updateShape(LevelAccessor level, BlockPos currentPos, Fluid fluid, int tickDelay) {
        level.m_186469_(currentPos, fluid, fluid.m_6718_((LevelReader)level));
    }

    @Inject(method={"canReplace"}, at={@At(value="RETURN")}, cancellable=true)
    private static void canReplace(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (state.m_60819_().m_205070_(ModTags.COLORED_WATER_SOURCE)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private static void place(LevelAccessor level, BlockPos pos, FluidState state, Direction facing, CallbackInfoReturnable<Boolean> cir) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)Blocks.f_152545_.m_49966_().m_61124_((Property)ModBlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.m_76170_()))).m_61124_((Property)BigDripleafBlock.f_54117_, (Comparable)facing)).m_61124_(ModBlockStateProperties.WATER_COLOR, (Comparable)((Object)WaterColor.valueOf(state.m_76152_().getAttributes().getColor())));
        cir.cancel();
        cir.setReturnValue((Object)level.m_7731_(pos, blockstate, 3));
    }
}

