/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.create;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BlockEntityIntegrationPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BasinIntegration
extends BlockEntityIntegrationPeripheral<BasinBlockEntity> {
    public BasinIntegration(BlockEntity entity) {
        super(entity);
    }

    @NotNull
    public String getType() {
        return "basin";
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getInputFluids() {
        ArrayList<Object> tanks = new ArrayList<Object>();
        for (SmartFluidTankBehaviour.TankSegment tank : ((SmartFluidTankBehaviour)((BasinBlockEntity)this.blockEntity).getTanks().getFirst()).getTanks()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("amount", tank.getRenderedFluid().getAmount());
            data.put("fluid", tank.getRenderedFluid().getFluid().getRegistryName().toString());
            tanks.add(data);
        }
        return tanks;
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getOutputFluids() {
        ArrayList<Object> tanks = new ArrayList<Object>();
        for (SmartFluidTankBehaviour.TankSegment tank : ((SmartFluidTankBehaviour)((BasinBlockEntity)this.blockEntity).getTanks().getSecond()).getTanks()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("amount", tank.getRenderedFluid().getAmount());
            data.put("fluid", tank.getRenderedFluid().getFluid().getRegistryName().toString());
            tanks.add(data);
        }
        return tanks;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getFilter() {
        return LuaConverter.stackToObject(((BasinBlockEntity)this.blockEntity).getFilter().getFilter());
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getInventory() {
        Optional handlerOptional = ((BasinBlockEntity)this.blockEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (handlerOptional.isEmpty()) {
            return null;
        }
        IItemHandler handler = (IItemHandler)handlerOptional.get();
        ArrayList<Object> items = new ArrayList<Object>();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            items.add(LuaConverter.stackToObject(handler.getStackInSlot(slot)));
        }
        return items;
    }
}

