/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.entity.Deer;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class DeerModel
extends AnimatedGeoModel<Deer> {
    public ResourceLocation getModelLocation(Deer deer) {
        return new ResourceLocation("naturalist", "geo/deer.geo.json");
    }

    public ResourceLocation getTextureLocation(Deer deer) {
        if (deer.m_6162_()) {
            return new ResourceLocation("naturalist", "textures/entity/fawn.png");
        }
        return new ResourceLocation("naturalist", "textures/entity/deer.png");
    }

    public ResourceLocation getAnimationFileLocation(Deer deer) {
        return new ResourceLocation("naturalist", "animations/deer.animation.json");
    }

    public void setLivingAnimations(Deer deer, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)deer, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        List extraDataOfType = customPredicate.getExtraDataOfType(EntityModelData.class);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone left_antler = this.getAnimationProcessor().getBone("left_antler");
        IBone right_antler = this.getAnimationProcessor().getBone("right_antler");
        if (deer.m_6162_()) {
            head.setScaleX(1.6f);
            head.setScaleY(1.6f);
            head.setScaleZ(1.6f);
        }
        left_antler.setHidden(deer.m_6162_());
        right_antler.setHidden(deer.m_6162_());
        if (!deer.isEating()) {
            head.setRotationX(((EntityModelData)extraDataOfType.get((int)0)).headPitch * ((float)Math.PI / 180));
            head.setRotationY(((EntityModelData)extraDataOfType.get((int)0)).netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

