/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.ai.goal.FollowAdultGoal;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Bird
extends ShoulderRidingEntity
implements FlyingAnimal,
IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private BirdAvoidEntityGoal<Player> avoidPlayersGoal;
    private static final Ingredient TAME_FOOD = Ingredient.m_204132_(NaturalistTags.ItemTags.BIRD_FOOD_ITEMS);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;

    public Bird(EntityType<? extends ShoulderRidingEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BirdTemptGoal(this, 1.0, TAME_FOOD, true));
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.5, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(4, (Goal)new BirdWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new BirdFlockGoal(this, 1.0, 6.0f, 12.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.8f).m_22268_(Attributes.f_22279_, 0.2);
    }

    public static boolean checkBirdSpawnRules(EntityType<Bird> entityType, LevelAccessor state, MobSpawnType type, BlockPos pos, Random random) {
        return state.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184232_) && Bird.m_186209_((BlockAndTintGetter)state, (BlockPos)pos);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public boolean m_6162_() {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.6f;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return false;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (!this.m_21824_() && TAME_FOOD.test(stack)) {
            if (!pPlayer.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), NaturalistSoundEvents.BIRD_EAT.get(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
            }
            if (!this.f_19853_.f_46443_) {
                if (this.f_19796_.nextInt(10) == 0) {
                    this.m_21828_(pPlayer);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)pPlayer)) {
            if (TAME_FOOD.test(stack) && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_5634_(1.0f);
                if (this.m_21223_() == this.m_21233_()) {
                    this.m_21834_(true);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.m_142592_()) {
                if (!this.f_19853_.f_46443_) {
                    this.m_21839_(!this.m_21827_());
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21839_(false);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6898_(ItemStack pStack) {
        return false;
    }

    protected void m_5849_() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new BirdAvoidEntityGoal<Player>(this, Player.class, 16.0f, 2.0, 2.0);
        }
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        if (!this.m_21824_()) {
            this.f_21345_.m_25352_(2, this.avoidPlayersGoal);
        }
    }

    public boolean m_142592_() {
        return !this.m_20096_();
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.f_19861_ && !this.m_20159_() ? 4 : -1) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.m_5496_(NaturalistSoundEvents.BIRD_FLY.get(), 0.15f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7324_(Entity pEntity) {
        if (!(pEntity instanceof Player)) {
            super.m_7324_(pEntity);
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return NaturalistSoundEvents.BIRD_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return NaturalistSoundEvents.BIRD_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_6095_().equals(NaturalistEntityTypes.BLUEJAY.get())) {
            return NaturalistSoundEvents.BIRD_AMBIENT_BLUEJAY.get();
        }
        if (this.m_6095_().equals(NaturalistEntityTypes.CANARY.get())) {
            return NaturalistSoundEvents.BIRD_AMBIENT_CANARY.get();
        }
        if (this.m_6095_().equals(NaturalistEntityTypes.CARDINAL.get())) {
            return NaturalistSoundEvents.BIRD_AMBIENT_CARDINAL.get();
        }
        return NaturalistSoundEvents.BIRD_AMBIENT_ROBIN.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("bird.sit", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_142592_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("bird.fly", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class BirdTemptGoal
    extends TemptGoal {
        @Nullable
        private Player selectedPlayer;
        private final Bird bird;

        public BirdTemptGoal(Bird bird, double speedModifier, Ingredient temptItems, boolean canScare) {
            super((PathfinderMob)bird, speedModifier, temptItems, canScare);
            this.bird = bird;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.selectedPlayer == null && this.f_25924_.m_21187_().nextInt(this.m_183277_(600)) == 0) {
                this.selectedPlayer = this.f_25925_;
            } else if (this.f_25924_.m_21187_().nextInt(this.m_183277_(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean m_7497_() {
            return this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.f_25925_) ? false : super.m_7497_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.bird.m_21824_();
        }
    }

    static class BirdWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        private final Bird bird;

        public BirdWanderGoal(Bird mob, double speedModifier) {
            super((PathfinderMob)mob, speedModifier);
            this.bird = mob;
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 vec3 = null;
            if (this.f_25725_.m_20069_()) {
                vec3 = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)15);
            }
            if (this.f_25725_.m_21187_().nextFloat() >= this.f_25985_) {
                vec3 = this.getTreePos();
            }
            return vec3 == null ? super.m_7037_() : vec3;
        }

        @Nullable
        private Vec3 getTreePos() {
            BlockPos mobPos = this.f_25725_.m_142538_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos mutable1 = new BlockPos.MutableBlockPos();
            for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.f_25725_.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() + 3.0)))) {
                BlockState blockstate;
                boolean flag;
                if (mobPos.equals((Object)pos) || !(flag = (blockstate = this.f_25725_.f_19853_.m_8055_((BlockPos)mutable1.m_122159_((Vec3i)pos, Direction.DOWN))).m_60734_() instanceof LeavesBlock || blockstate.m_204336_(BlockTags.f_13106_)) || !this.f_25725_.f_19853_.m_46859_(pos) || !this.f_25725_.f_19853_.m_46859_((BlockPos)mutable.m_122159_((Vec3i)pos, Direction.UP))) continue;
                return Vec3.m_82539_((Vec3i)pos);
            }
            return null;
        }

        public boolean m_8036_() {
            return !this.bird.m_21824_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.bird.m_21824_() && super.m_8045_();
        }
    }

    static class BirdFlockGoal
    extends FollowAdultGoal {
        private final Bird bird;

        public BirdFlockGoal(Bird pMob, double pSpeedModifier, float pStopDistance, float pAreaSize) {
            super((Mob)pMob, pSpeedModifier, pStopDistance, pAreaSize);
            this.bird = pMob;
        }

        @Override
        public boolean m_8036_() {
            return !this.bird.m_21824_() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return !this.bird.m_21824_() && super.m_8045_();
        }
    }

    static class BirdAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Bird bird;

        public BirdAvoidEntityGoal(Bird bird, Class<T> toAvoid, float maxDistance, double walkSpeed, double sprintSpeed) {
            super((PathfinderMob)bird, toAvoid, maxDistance, walkSpeed, sprintSpeed, EntitySelector.f_20406_::test);
            this.bird = bird;
        }

        public boolean m_8036_() {
            return !this.bird.m_21824_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.bird.m_21824_() && super.m_8045_();
        }
    }
}

