/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.forge;

import com.starfish_studios.naturalist.Naturalist;
import com.starfish_studios.naturalist.entity.Bear;
import com.starfish_studios.naturalist.entity.Bird;
import com.starfish_studios.naturalist.entity.Boar;
import com.starfish_studios.naturalist.entity.Butterfly;
import com.starfish_studios.naturalist.entity.Caterpillar;
import com.starfish_studios.naturalist.entity.Deer;
import com.starfish_studios.naturalist.entity.Elephant;
import com.starfish_studios.naturalist.entity.Firefly;
import com.starfish_studios.naturalist.entity.Giraffe;
import com.starfish_studios.naturalist.entity.Hippo;
import com.starfish_studios.naturalist.entity.Lion;
import com.starfish_studios.naturalist.entity.Rhino;
import com.starfish_studios.naturalist.entity.Snail;
import com.starfish_studios.naturalist.entity.Snake;
import com.starfish_studios.naturalist.entity.Vulture;
import com.starfish_studios.naturalist.platform.forge.CommonPlatformHelperImpl;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistMobCategories;
import com.starfish_studios.naturalist.registry.forge.NaturalistConfigForge;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="naturalist")
@Mod.EventBusSubscriber(modid="naturalist")
public class NaturalistForge {
    public NaturalistForge() {
        Naturalist.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NaturalistConfigForge.COMMON_CONFIG);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CommonPlatformHelperImpl.BLOCKS.register(bus);
        CommonPlatformHelperImpl.ITEMS.register(bus);
        CommonPlatformHelperImpl.SOUND_EVENTS.register(bus);
        CommonPlatformHelperImpl.ENTITY_TYPES.register(bus);
        CommonPlatformHelperImpl.POTIONS.register(bus);
        bus.addListener(this::setup);
        bus.addListener(this::createAttributes);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Naturalist.registerBrewingRecipes();
            Naturalist.registerCompostables();
            Naturalist.registerSpawnPlacements();
        });
    }

    private void createAttributes(EntityAttributeCreationEvent event) {
        event.put(NaturalistEntityTypes.SNAIL.get(), Snail.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BEAR.get(), Bear.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BUTTERFLY.get(), Butterfly.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.FIREFLY.get(), Firefly.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.SNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CORAL_SNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.RATTLESNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.DEER.get(), Deer.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BLUEJAY.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CANARY.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CARDINAL.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ROBIN.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CATERPILLAR.get(), Caterpillar.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.RHINO.get(), Rhino.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.LION.get(), Lion.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ELEPHANT.get(), Elephant.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ZEBRA.get(), AbstractHorse.m_30627_().m_22265_());
        event.put(NaturalistEntityTypes.GIRAFFE.get(), Giraffe.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.HIPPO.get(), Hippo.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.VULTURE.get(), Vulture.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BOAR.get(), Boar.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.TAIGA), MobCategory.CREATURE, NaturalistEntityTypes.BEAR.get(), (Integer)NaturalistConfigForge.BEAR_SPAWN_WEIGHT.get(), 1, 2);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST), MobCategory.CREATURE, NaturalistEntityTypes.DEER.get(), (Integer)NaturalistConfigForge.DEER_SPAWN_WEIGHT.get(), 1, 3);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.SWAMP, Biome.BiomeCategory.SAVANNA, Biome.BiomeCategory.RIVER, Biome.BiomeCategory.EXTREME_HILLS, Biome.BiomeCategory.MUSHROOM, Biome.BiomeCategory.UNDERGROUND, Biome.BiomeCategory.MOUNTAIN), MobCategory.CREATURE, NaturalistEntityTypes.SNAIL.get(), (Integer)NaturalistConfigForge.SNAIL_SPAWN_WEIGHT.get(), 1, 3);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.SWAMP, Biome.BiomeCategory.MUSHROOM), NaturalistMobCategories.getFireflyCategory(), NaturalistEntityTypes.FIREFLY.get(), (Integer)NaturalistConfigForge.FIREFLY_SPAWN_WEIGHT.get(), 2, 3);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.PLAINS), MobCategory.CREATURE, NaturalistEntityTypes.BUTTERFLY.get(), (Integer)NaturalistConfigForge.BUTTERFLY_SPAWN_WEIGHT.get(), 1, 3);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.SWAMP), MobCategory.CREATURE, NaturalistEntityTypes.SNAKE.get(), (Integer)NaturalistConfigForge.SNAKE_SPAWN_WEIGHT.get(), 1, 1);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.MESA, Biome.BiomeCategory.SAVANNA, Biome.BiomeCategory.DESERT), MobCategory.CREATURE, NaturalistEntityTypes.RATTLESNAKE.get(), (Integer)NaturalistConfigForge.RATTLESNAKE_SPAWN_WEIGHT.get(), 1, 1);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.JUNGLE, Biome.BiomeCategory.BEACH, Biome.BiomeCategory.RIVER), MobCategory.CREATURE, NaturalistEntityTypes.CORAL_SNAKE.get(), (Integer)NaturalistConfigForge.CORAL_SNAKE_SPAWN_WEIGHT.get(), 1, 1);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.TAIGA, Biome.BiomeCategory.EXTREME_HILLS, Biome.BiomeCategory.ICY), MobCategory.CREATURE, NaturalistEntityTypes.BLUEJAY.get(), (Integer)NaturalistConfigForge.BLUEJAY_SPAWN_WEIGHT.get(), 1, 4);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.EXTREME_HILLS, Biome.BiomeCategory.MOUNTAIN), MobCategory.CREATURE, NaturalistEntityTypes.CANARY.get(), (Integer)NaturalistConfigForge.CANARY_SPAWN_WEIGHT.get(), 1, 4);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.SWAMP, Biome.BiomeCategory.SAVANNA, Biome.BiomeCategory.DESERT), MobCategory.CREATURE, NaturalistEntityTypes.CARDINAL.get(), (Integer)NaturalistConfigForge.CARDINAL_SPAWN_WEIGHT.get(), 1, 4);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.MOUNTAIN), MobCategory.CREATURE, NaturalistEntityTypes.ROBIN.get(), (Integer)NaturalistConfigForge.ROBIN_SPAWN_WEIGHT.get(), 1, 4);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST), MobCategory.CREATURE, EntityType.f_20517_, (Integer)NaturalistConfigForge.FOREST_RABBIT_SPAWN_WEIGHT.get(), 2, 3);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.FOREST), MobCategory.CREATURE, EntityType.f_20452_, (Integer)NaturalistConfigForge.FOREST_FOX_SPAWN_WEIGHT.get(), 2, 4);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA), MobCategory.CREATURE, NaturalistEntityTypes.RHINO.get(), (Integer)NaturalistConfigForge.RHINO_SPAWN_WEIGHT.get(), 1, 3);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA), MobCategory.CREATURE, NaturalistEntityTypes.LION.get(), (Integer)NaturalistConfigForge.LION_SPAWN_WEIGHT.get(), 3, 5);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA), MobCategory.CREATURE, NaturalistEntityTypes.ELEPHANT.get(), (Integer)NaturalistConfigForge.ELEPHANT_SPAWN_WEIGHT.get(), 2, 3);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA), MobCategory.CREATURE, NaturalistEntityTypes.ZEBRA.get(), (Integer)NaturalistConfigForge.ZEBRA_SPAWN_WEIGHT.get(), 2, 3);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA), MobCategory.CREATURE, NaturalistEntityTypes.GIRAFFE.get(), (Integer)NaturalistConfigForge.GIRAFFE_SPAWN_WEIGHT.get(), 2, 4);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA, Biome.BiomeCategory.JUNGLE), MobCategory.CREATURE, NaturalistEntityTypes.HIPPO.get(), (Integer)NaturalistConfigForge.HIPPO_SPAWN_WEIGHT.get(), 3, 4);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA, Biome.BiomeCategory.DESERT), MobCategory.CREATURE, NaturalistEntityTypes.VULTURE.get(), (Integer)NaturalistConfigForge.VULTURE_SPAWN_WEIGHT.get(), 2, 4);
        NaturalistForge.addMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA), MobCategory.CREATURE, NaturalistEntityTypes.BOAR.get(), (Integer)NaturalistConfigForge.BOAR_SPAWN_WEIGHT.get(), 4, 4);
        if (((Boolean)NaturalistConfigForge.REMOVE_SAVANNA_FARM_ANIMALS.get()).booleanValue()) {
            NaturalistForge.removeMobSpawn(event, List.of(Biome.BiomeCategory.SAVANNA), List.of(EntityType.f_20520_, EntityType.f_20510_, EntityType.f_20555_, EntityType.f_20557_));
        }
    }

    private static void addMobSpawn(BiomeLoadingEvent event, List<Biome.BiomeCategory> categories, MobCategory spawnGroup, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (categories.contains(event.getCategory())) {
            event.getSpawns().m_48376_(spawnGroup, new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize));
        }
    }

    private static void removeMobSpawn(BiomeLoadingEvent event, List<Biome.BiomeCategory> categories, List<EntityType<?>> entityTypes) {
        if (categories.contains(event.getCategory())) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).removeIf(entry -> entityTypes.contains(entry.f_48404_));
        }
    }
}

