/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.Context;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LItemStack
extends LStack<Item> {
    public static final String IDENTIFIER = "itemStack";
    public static final String KEY_ITEM = "item";
    public static final String KEY_NBT = "nbt";
    public static final String KEY_CAP = "cap";
    public static final String KEY_F_META = "fMeta";
    public static final String KEY_F_CAP = "fCap";
    public static final String KEY_F_NBT = "fNbt";
    Item item;
    CompoundTag nbt;
    CompoundTag cap;
    boolean fMeta;
    boolean fNbt;
    boolean fCap;
    transient ItemStack rep;

    public LItemStack(ItemStack is) {
        super(is.m_41613_(), false);
        this.init(is.m_41720_(), LItemStack.getCap(is), is.m_41783_(), false, false, false);
    }

    public LItemStack(CompoundTag tag) {
        super(tag);
        String id = tag.m_128461_(KEY_ITEM);
        Optional i = Registry.f_122827_.m_6612_(new ResourceLocation(id));
        if (i.isEmpty()) {
            throw new ILabel.Serializer.SerializationException("Item " + id + " cannot be resolved, ignoring");
        }
        this.init((Item)i.get(), tag.m_128441_(KEY_CAP) ? tag.m_128469_(KEY_CAP) : null, tag.m_128441_(KEY_NBT) ? tag.m_128469_(KEY_NBT) : null, tag.m_128471_(KEY_F_META), tag.m_128471_(KEY_F_CAP), tag.m_128471_(KEY_F_NBT));
    }

    @Override
    public Item get() {
        return this.item;
    }

    @Override
    public Context<Item> getContext() {
        return Context.ITEM;
    }

    private LItemStack(LItemStack lis) {
        super(lis);
        this.item = lis.item;
        this.nbt = lis.nbt == null ? null : lis.nbt.m_6426_();
        this.cap = lis.cap == null ? null : lis.cap.m_6426_();
        this.fMeta = lis.fMeta;
        this.fNbt = lis.fNbt;
        this.fCap = lis.fCap;
        this.rep = lis.rep;
    }

    private void init(@Nullable Item item, @Nullable CompoundTag cap, @Nullable CompoundTag nbt, boolean fMeta, boolean fCap, boolean fNbt) {
        Objects.requireNonNull(item);
        this.item = item;
        this.cap = cap;
        this.nbt = nbt;
        this.fMeta = fMeta;
        this.fCap = fCap;
        this.fNbt = fNbt;
        this.rep = Utilities.createItemStackWithCap(item, 1, this.cap);
        this.rep.m_41751_(this.nbt);
    }

    @Nullable
    private static CompoundTag getCap(ItemStack is) {
        return Utilities.getCap(is);
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LItemStack) {
            LItemStack lisA = (LItemStack)a;
            if (b instanceof LItemStack) {
                LItemStack lisB = (LItemStack)b;
                if (lisA.rep.m_41773_() != lisB.rep.m_41773_() && !lisA.fMeta && !lisB.fMeta) {
                    return false;
                }
                if (!lisA.fNbt && !lisB.fNbt && (lisA.nbt == null ? lisB.nbt != null : lisB.nbt == null || !lisA.nbt.equals((Object)lisB.nbt))) {
                    return false;
                }
                if (!lisA.fCap && !lisB.fCap && (lisA.cap == null ? lisB.cap != null : lisB.cap == null || !lisA.cap.equals((Object)lisB.cap))) {
                    return false;
                }
                return lisA.item == lisB.item;
            }
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable Class<?> context) {
        if (iss.size() == 0) {
            return new ArrayList<ILabel>();
        }
        for (ILabel i : iss) {
            if (i instanceof LItemStack) continue;
            return new ArrayList<ILabel>();
        }
        LItemStack lis = (LItemStack)iss.get(0);
        boolean fMeta = false;
        boolean fNbt = false;
        boolean fCap = false;
        for (ILabel i : iss) {
            LItemStack ii = (LItemStack)i;
            if (ii.item != lis.item) {
                return new ArrayList<ILabel>();
            }
            if (ii.rep.m_41773_() != lis.rep.m_41773_() || ii.fMeta) {
                fMeta = true;
            }
            if (!Objects.equals(ii.nbt, lis.nbt)) {
                fNbt = true;
            }
            if (Objects.equals(ii.cap, lis.cap)) continue;
            fCap = true;
        }
        if (fMeta || fNbt || fCap) {
            return Collections.singletonList(lis.copy().setFCap(fCap).setFMeta(fMeta).setFNbt(fNbt));
        }
        return new ArrayList<ILabel>();
    }

    public static List<ILabel> fallback(List<ILabel> iss, @Nullable Class<?> context) {
        ArrayList<ILabel> ret = new ArrayList<ILabel>();
        if (iss.size() == 1) {
            ILabel label = iss.get(0);
            if (!(label instanceof LItemStack)) {
                return ret;
            }
            LItemStack lis = (LItemStack)label;
            if (lis.fCap || lis.fNbt || lis.fMeta) {
                return new ArrayList<ILabel>();
            }
            ret.add(lis.copy().setFMeta(true));
            ret.add(lis.copy().setFNbt(true));
            ret.add(lis.copy().setFCap(true));
            ret.add(lis.copy().setFMeta(true).setFNbt(true).setFCap(true));
        }
        return ret;
    }

    public LItemStack setFMeta(boolean f) {
        this.fMeta = f;
        return this;
    }

    public LItemStack setFNbt(boolean f) {
        this.fNbt = f;
        return this;
    }

    public LItemStack setFCap(boolean f) {
        this.fCap = f;
        return this;
    }

    @Override
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        if (this.fMeta) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_meta", new Object[0]));
        }
        if (this.fNbt) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_nbt", new Object[0]));
        }
        if (this.fCap) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_cap", new Object[0]));
        }
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.item));
    }

    public ItemStack getRepresentation() {
        return this.rep;
    }

    @Override
    public String getDisplayName() {
        return this.rep.m_41786_().getString();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LItemStack) {
            LItemStack lis = (LItemStack)l;
            return Objects.equals(this.nbt, lis.nbt) && Objects.equals(this.cap, lis.cap) && this.item == lis.item && this.fNbt == lis.fNbt && super.matches(l) && this.fCap == lis.fCap && this.fMeta == lis.fMeta;
        }
        return false;
    }

    @Override
    public LItemStack copy() {
        return new LItemStack(this);
    }

    @Override
    public CompoundTag toNbt() {
        ResourceLocation rl = Registry.f_122827_.m_7981_((Object)this.item);
        if (rl == null) {
            return ILabel.EMPTY.toNbt();
        }
        CompoundTag ret = super.toNbt();
        ret.m_128359_(KEY_ITEM, rl.toString());
        if (this.nbt != null) {
            ret.m_128365_(KEY_NBT, (Tag)this.nbt);
        }
        if (this.cap != null) {
            ret.m_128365_(KEY_CAP, (Tag)this.cap);
        }
        if (this.fMeta) {
            ret.m_128379_(KEY_F_META, true);
        }
        if (this.fNbt) {
            ret.m_128379_(KEY_F_NBT, true);
        }
        if (this.fCap) {
            ret.m_128379_(KEY_F_CAP, true);
        }
        return ret;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawLabel(int xPos, int yPos, JecaGui gui, boolean hand) {
        gui.drawItemStack(xPos, yPos, this.rep, false, hand);
        if (this.fCap || this.fNbt || this.fMeta) {
            gui.drawResource(Resource.LBL_FRAME, xPos, yPos);
        }
        if (this.fCap) {
            gui.drawResource(Resource.LBL_FR_LL, xPos, yPos);
        }
        if (this.fNbt) {
            gui.drawResource(Resource.LBL_FR_UL, xPos, yPos);
        }
        if (this.fMeta) {
            gui.drawResource(Resource.LBL_FR_UR, xPos, yPos);
        }
    }

    @Override
    public int hashCode() {
        return (this.nbt == null ? 0 : this.nbt.hashCode()) ^ (this.cap == null ? 0 : this.cap.hashCode()) ^ this.item.m_5524_().hashCode() ^ super.hashCode();
    }
}

