/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.IRecord;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RecordCraft
implements IRecord {
    public static final String KEY_RECENTS = "recents";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_INVENTORY = "inventory";
    public static final String KEY_MODE = "mode";
    public static final String KEY_OVERLAY_OPEN = "overlayOpen";
    public static final String KEY_OVERLAY_X = "overlayPositionX";
    public static final String KEY_OVERLAY_Y = "overlayPositionY";
    public static final String KEY_OVERLAY_DEPTH = "overlayDepth";
    Utilities.Recent<ILabel> record = new Utilities.Recent<ILabel>((a, b) -> a == ILabel.EMPTY || a.equals(b), 9);
    public String amount;
    public boolean inventory;
    public Mode mode;
    public boolean overlayOpen;
    public int overlayPositionX;
    public int overlayPositionY;
    public int overlayDepth;

    public RecordCraft(CompoundTag nbt) {
        List ls = nbt.m_128437_(KEY_RECENTS, 10).stream().filter(n -> n instanceof CompoundTag).map(n -> ILabel.SERIALIZER.deserialize((CompoundTag)n)).collect(Collectors.toList());
        new Utilities.ReversedIterator(ls).forEachRemaining(l -> this.record.push((ILabel)l, false));
        this.amount = nbt.m_128461_(KEY_AMOUNT);
        this.inventory = nbt.m_128471_(KEY_INVENTORY);
        String s = nbt.m_128461_(KEY_MODE);
        this.mode = Mode.INPUT;
        for (Mode m : Mode.values()) {
            if (!s.equals(m.toString().toLowerCase())) continue;
            this.mode = m;
        }
        this.overlayOpen = nbt.m_128471_(KEY_OVERLAY_OPEN);
        this.overlayPositionX = nbt.m_128451_(KEY_OVERLAY_X);
        this.overlayPositionY = nbt.m_128451_(KEY_OVERLAY_Y);
        this.overlayDepth = nbt.m_128451_(KEY_OVERLAY_DEPTH);
    }

    public boolean push(ILabel label, boolean replace) {
        return this.record.push(label, replace);
    }

    public ILabel getLatest() {
        return this.record.size() == 0 ? ILabel.EMPTY : this.record.toList().get(0);
    }

    public List<ILabel> getHistory() {
        return this.record.size() > 1 ? this.record.toList().subList(1, this.record.size()) : new ArrayList<ILabel>();
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag ret = new CompoundTag();
        ret.m_128379_(KEY_INVENTORY, this.inventory);
        ret.m_128359_(KEY_AMOUNT, this.amount);
        ListTag recent = new ListTag();
        this.record.toList().forEach(l -> recent.add((Object)ILabel.SERIALIZER.serialize((ILabel)l)));
        ret.m_128365_(KEY_RECENTS, (Tag)recent);
        ret.m_128359_(KEY_MODE, this.mode.toString().toLowerCase());
        ret.m_128379_(KEY_OVERLAY_OPEN, this.overlayOpen);
        ret.m_128405_(KEY_OVERLAY_X, this.overlayPositionX);
        ret.m_128405_(KEY_OVERLAY_Y, this.overlayPositionY);
        ret.m_128405_(KEY_OVERLAY_DEPTH, this.overlayDepth);
        return ret;
    }

    public static enum Mode {
        INPUT,
        OUTPUT,
        CATALYST,
        STEPS;

    }
}

