/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.events;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.events.GuiScreenOverlayHandler;
import me.towdium.jecalculation.events.InventorySummary;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.utils.wrappers.Trio;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class GuiScreenEventHandler {
    protected GuiScreenOverlayHandler overlayHandler = null;
    protected JecaGui gui = null;
    protected InventorySummary cachedInventory;
    protected Trio<List<? extends ClientTooltipComponent>, Integer, Integer> cachedTooltipEvent;

    public GuiScreenEventHandler() {
        this.registerEvents();
    }

    private void registerEvents() {
        ClientGuiEvent.SET_SCREEN.register(this::onGuiOpen);
        ClientTooltipEvent.RENDER_PRE.register(this::onTooltip);
        ClientGuiEvent.RENDER_POST.register(this::onDrawForeground);
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register(this::onMouseScroll);
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register(this::onMouseClicked);
        ClientScreenInputEvent.MOUSE_DRAGGED_PRE.register(this::onMouseDragged);
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register(this::onMouseReleased);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::onKeyPressed);
        ClientScreenInputEvent.KEY_RELEASED_PRE.register(this::onKeyReleased);
        ClientScreenInputEvent.CHAR_TYPED_PRE.register(this::onCharTyped);
    }

    public CompoundEventResult<Screen> onGuiOpen(Screen screen) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !(screen instanceof AbstractContainerScreen)) {
            return CompoundEventResult.pass();
        }
        this.overlayHandler = new GuiScreenOverlayHandler(player.m_150109_());
        this.gui = new JecaGui(null, false, this.overlayHandler, true);
        this.gui.m_6575_(Minecraft.m_91087_(), screen.f_96543_, screen.f_96544_);
        this.overlayHandler.setGui(this.gui);
        return CompoundEventResult.pass();
    }

    protected boolean isScreenValidForOverlay(Screen screen) {
        return screen instanceof AbstractContainerScreen && !(screen instanceof JecaGui);
    }

    public void onDrawForeground(Screen screen, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return;
        }
        Inventory inventory = player.m_150109_();
        if (this.didInventoryChange(inventory)) {
            this.overlayHandler = new GuiScreenOverlayHandler(inventory);
            this.gui = new JecaGui(null, false, this.overlayHandler, true);
            this.gui.m_6575_(Minecraft.m_91087_(), screen.f_96543_, screen.f_96544_);
            this.overlayHandler.setGui(this.gui);
        } else if (screen.f_96543_ != this.gui.f_96543_ || screen.f_96544_ != this.gui.f_96544_) {
            this.gui.m_6575_(Minecraft.m_91087_(), screen.f_96543_, screen.f_96544_);
        }
        this.gui.setMatrix(poseStack);
        mouseX = this.gui.getGlobalMouseX();
        mouseY = this.gui.getGlobalMouseY();
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.gui.getGuiLeft(), (double)this.gui.getGuiTop(), 0.0);
        this.overlayHandler.onDraw(this.gui, mouseX, mouseY);
        poseStack.m_85849_();
        ArrayList<String> tooltip = new ArrayList<String>();
        this.overlayHandler.onTooltip(this.gui, mouseX, mouseY, tooltip);
        this.gui.drawHoveringText(poseStack, tooltip, mouseX + this.gui.getGuiLeft(), mouseY + this.gui.getGuiTop(), minecraft.f_91062_);
        if (this.cachedTooltipEvent != null) {
            this.gui.m_169383_(poseStack, (List)this.cachedTooltipEvent.one, (Integer)this.cachedTooltipEvent.two, (Integer)this.cachedTooltipEvent.three);
            this.cachedTooltipEvent = null;
        }
    }

    public EventResult onTooltip(PoseStack poseStack, List<? extends ClientTooltipComponent> components, int x, int y) {
        if (this.overlayHandler == null || this.cachedTooltipEvent != null || !this.overlayHandler.hasAnyWindow()) {
            return EventResult.pass();
        }
        boolean overlap = this.overlayHandler.onTooltip(this.gui, x - this.gui.getGuiLeft(), y - this.gui.getGuiTop(), new ArrayList<String>());
        if (!overlap) {
            this.cachedTooltipEvent = new Trio<List<? extends ClientTooltipComponent>, Integer, Integer>(components, x, y);
        }
        return EventResult.interruptFalse();
    }

    public EventResult onMouseScroll(Minecraft client, Screen screen, double mouseX, double mouseY, double amount) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return amount != 0.0 && this.overlayHandler.onMouseScroll(this.gui, this.gui.getGlobalMouseX(), this.gui.getGlobalMouseY(), (int)amount) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onMouseClicked(Minecraft client, Screen screen, double mouseX, double mouseY, int button) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        int xMouse = this.gui.getGlobalMouseX();
        int yMouse = this.gui.getGlobalMouseY();
        this.overlayHandler.onMouseFocused(this.gui, xMouse, yMouse, button);
        return this.overlayHandler.onMouseClicked(this.gui, xMouse, yMouse, button) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onMouseReleased(Minecraft minecraft, Screen screen, double mouseX, double mouseY, int button) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onMouseReleased(this.gui, this.gui.getGlobalMouseX(), this.gui.getGlobalMouseY(), button) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onMouseDragged(Minecraft client, Screen screen, double mouseX1, double mouseY1, int button, double mouseX2, double mouseY2) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onMouseDragged(this.gui, this.gui.getGlobalMouseX(), this.gui.getGlobalMouseY(), (int)mouseX2, (int)mouseY2) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onKeyPressed(Minecraft client, Screen screen, int keyCode, int scanCode, int modifiers) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onKeyPressed(this.gui, keyCode, modifiers) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onKeyReleased(Minecraft client, Screen screen, int keyCode, int scanCode, int modifiers) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onKeyReleased(this.gui, keyCode, modifiers) ? EventResult.interruptFalse() : EventResult.pass();
    }

    public EventResult onCharTyped(Minecraft minecraft, Screen screen, char codePoint, int modifiers) {
        if (this.overlayHandler == null || !this.isScreenValidForOverlay(screen)) {
            return EventResult.pass();
        }
        return this.overlayHandler.onChar(this.gui, codePoint, modifiers) ? EventResult.interruptFalse() : EventResult.pass();
    }

    private boolean didInventoryChange(Inventory inventory) {
        if (this.cachedInventory == null) {
            this.cachedInventory = new InventorySummary(inventory);
            return false;
        }
        InventorySummary newSummery = new InventorySummary(inventory);
        if (newSummery.equals(this.cachedInventory)) {
            return false;
        }
        this.cachedInventory = newSummery;
        return true;
    }

    public List<Rect2i> getGuiAreas() {
        if (this.overlayHandler != null && this.gui != null && this.isScreenValidForOverlay(Minecraft.m_91087_().f_91080_)) {
            return this.overlayHandler.getGuiExtraAreas(this.gui.getGuiLeft(), this.gui.getGuiTop());
        }
        return Collections.emptyList();
    }
}

