/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.utils;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.BreakIterator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.compat.ModCompat;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.RecordPlayer;
import me.towdium.jecalculation.utils.forge.UtilitiesImpl;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Logger;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Utilities {
    public static char[] suffix = new char[]{'K', 'M', 'B', 'G', 'T', 'P'};
    public static DecimalFormat[] format = new DecimalFormat[]{new DecimalFormat("#."), new DecimalFormat("#.#"), new DecimalFormat("#.##"), new DecimalFormat("#.###"), new DecimalFormat("#.####")};
    public static TagKey<Item> IRON_INGOTS = Utilities.tag(Registry.f_122904_, Platform.isForge() ? "ingots/iron" : "iron_ingots");

    public static String cutNumber(float f, int size) {
        BiFunction<Float, Integer, String> form = (fl, len) -> format[len - 1 - (int)Math.log10(fl.floatValue())].format(fl);
        int scale = (int)Math.log10(f) / 3;
        if (scale == 0) {
            return form.apply(Float.valueOf(f), size);
        }
        return form.apply(Float.valueOf(f / (float)Math.pow(1000.0, scale)), size - 1) + suffix[scale - 1];
    }

    public static <T> Stream<T> stream(Optional<T> o) {
        return o.stream();
    }

    public static <T> Supplier<T> fake(Runnable r) {
        return () -> {
            r.run();
            return null;
        };
    }

    public static String repeat(String s, int n) {
        return s.repeat(Math.max(0, n));
    }

    public static boolean equals(TagKey<?> t1, TagKey<?> t2) {
        return Objects.equals(t1.f_203867_(), t2.f_203867_()) && Objects.equals(t1.f_203868_(), t2.f_203868_());
    }

    public static <T> Stream<Pair<TagKey<T>, Stream<T>>> getTags(Registry<T> registry) {
        return registry.m_203612_().map(pair -> new Pair<TagKey, Stream<Object>>((TagKey)pair.getFirst(), ((HolderSet.Named)pair.getSecond()).m_203614_().map(Holder::m_203334_)));
    }

    public static void showRecipe(ILabel label) {
        ModCompat.showRecipe(label);
    }

    public static ILabel getLabelUnderMouse() {
        return ModCompat.getLabelUnderMouse();
    }

    public static boolean isRecipeScreen(Screen screen) {
        return ModCompat.isRecipeScreen(screen);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FluidStack createFluidStackFromJeiIngredient(Object object) {
        return UtilitiesImpl.createFluidStackFromJeiIngredient(object);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClientMode() {
        return UtilitiesImpl.isClientMode();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecordPlayer getRecord(Player player) {
        return UtilitiesImpl.getRecord(player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean areCapsCompatible(ItemStack itemStack, ItemStack itemStack1) {
        void var1_1;
        return UtilitiesImpl.areCapsCompatible(itemStack, (ItemStack)var1_1);
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CompoundTag getCap(ItemStack itemStack) {
        return UtilitiesImpl.getCap(itemStack);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack createItemStackWithCap(Item item, int count, CompoundTag cap) {
        void var2_2;
        void var1_1;
        return UtilitiesImpl.createItemStackWithCap(item, (int)var1_1, (CompoundTag)var2_2);
    }

    public static <T> TagKey<T> tag(ResourceKey<? extends Registry<T>> key, String tag) {
        return TagKey.m_203882_(key, (ResourceLocation)new ResourceLocation(Utilities.getTagNamespace(), tag));
    }

    public static String getTagNamespace() {
        return Platform.isForge() ? "forge" : "c";
    }

    static <T> Optional<String> getModNameInternal(Registry<T> registry, T t) {
        return Optional.ofNullable(registry.m_7981_(t)).map(ResourceLocation::m_135827_).map(s -> "minecraft".equals(s) ? "Minecraft" : Utilities.getModName(s));
    }

    static String getModName(String id) {
        return Platform.getOptionalMod((String)id).map(Mod::getName).orElseGet(() -> WordUtils.capitalize((String)id.replace("_", " ")));
    }

    public static String getModName(Item item) {
        return Utilities.getModNameInternal(Registry.f_122827_, item).orElse("Unknown");
    }

    public static String getModName(Fluid fluid) {
        return Utilities.getModNameInternal(Registry.f_122822_, fluid).orElseGet(() -> Utilities.getModNameFromTexture(fluid));
    }

    static String getModNameFromTexture(Fluid fluid) {
        FluidStack fs = FluidStack.create((Fluid)fluid, (long)1000L);
        String name = fs.getName().getString();
        if (name.equals("lava") || name.equals("water")) {
            return "Minecraft";
        }
        TextureAtlasSprite texture = FluidStackHooks.getStillTexture((Fluid)fluid);
        if (texture == null) {
            return "Unknown";
        }
        return Utilities.getModName(texture.m_118413_().m_135827_());
    }

    public static File config() {
        return Platform.getConfigFolder().resolve("jecalculation").toFile();
    }

    public static CompoundTag getTag(ItemStack is) {
        return is.m_41698_("jecalculation");
    }

    public static LocalPlayer getPlayer() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
    }

    public static class OffsetStack
    extends Stack<Pair<Integer, Integer>> {
        public int x() {
            return this.size() == 0 ? 0 : (Integer)((Pair)this.peek()).one;
        }

        public int y() {
            return this.size() == 0 ? 0 : (Integer)((Pair)this.peek()).two;
        }

        public void push(int x, int y) {
            this.push(new Pair<Integer, Integer>(this.x() + x, this.y() + y));
        }
    }

    public static class Greetings {
        static final String[] MODS = new String[]{"jecharacters", "jecalculation"};
        static final Set<String> SENT = new HashSet<String>();
        static final Map<String, String> FRIENDS = new HashMap<String, String>(){
            {
                this.put("kiwi", "Snownee");
                this.put("i18nupdatemod", "TartaricAcid");
                this.put("touhou_little_maid", "TartaricAcid");
            }
        };

        public static void send(Logger logger, String self) {
            boolean master = true;
            for (String i : MODS) {
                if (!Platform.isModLoaded((String)i)) continue;
                if (i.equals(self)) break;
                master = false;
                break;
            }
            if (master) {
                for (Map.Entry entry : FRIENDS.entrySet()) {
                    if (!Platform.isModLoaded((String)((String)entry.getKey())) || SENT.contains(entry.getValue())) continue;
                    logger.info("Good to see you, {}", entry.getValue());
                    SENT.add((String)entry.getValue());
                }
            }
        }
    }

    public static class Json {
        @Nullable
        public static CompoundTag read(File f) {
            try {
                String s = FileUtils.readFileToString((File)f, (String)"UTF-8");
                return Json.read(s);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Nullable
        public static CompoundTag read(String s) {
            try {
                return TagParser.m_129359_((String)s);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void write(CompoundTag nbt, File f) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(Json.write(nbt).getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public static String write(CompoundTag nbt) {
            Writer w = new Writer();
            Json.write((Tag)nbt, w);
            w.enter();
            return w.build();
        }

        private static void write(Tag nbt, Writer w) {
            if (nbt instanceof CompoundTag) {
                CompoundTag tags = (CompoundTag)nbt;
                boolean wrap = tags.m_128431_().size() > 1;
                boolean first = true;
                w.sb.append('{');
                if (wrap) {
                    ++w.indent;
                }
                for (String i : tags.m_128431_()) {
                    if (first) {
                        first = false;
                    } else {
                        w.sb.append(',');
                    }
                    if (wrap) {
                        w.enter();
                    }
                    w.sb.append('\"');
                    w.sb.append(i);
                    w.sb.append("\": ");
                    Json.write(tags.m_128423_(i), w);
                }
                if (wrap) {
                    --w.indent;
                    w.enter();
                }
                w.sb.append('}');
            } else if (nbt instanceof ListTag) {
                ListTag tags = (ListTag)nbt;
                boolean wrap = tags.size() > 1;
                boolean first = true;
                w.sb.append('[');
                if (wrap) {
                    ++w.indent;
                }
                for (Tag i : tags) {
                    if (first) {
                        first = false;
                    } else {
                        w.sb.append(',');
                    }
                    if (wrap) {
                        w.enter();
                    }
                    Json.write(i, w);
                }
                if (wrap) {
                    --w.indent;
                    w.enter();
                }
                w.sb.append(']');
            } else {
                w.sb.append(nbt);
            }
        }

        private static class Writer {
            public int indent = 0;
            StringBuilder sb = new StringBuilder();

            private Writer() {
            }

            public void enter() {
                this.sb.append('\n');
                char[] tmp = new char[4 * this.indent];
                Arrays.fill(tmp, ' ');
                this.sb.append(tmp);
            }

            public String build() {
                return this.sb.toString();
            }
        }
    }

    public static class Recent<T> {
        LinkedList<T> data = new LinkedList();
        BiPredicate<T, T> tester;
        int limit;

        public Recent(BiPredicate<T, T> tester, int limit) {
            this.tester = tester;
            this.limit = limit;
        }

        public Recent(int limit) {
            this.limit = limit;
        }

        public boolean push(T obj, boolean replace) {
            if (replace) {
                this.data.pop();
            }
            boolean ret = this.data.removeIf(t -> this.tester != null ? this.tester.test(t, obj) : t.equals(obj));
            this.data.addFirst(obj);
            if (this.data.size() > this.limit) {
                this.data.removeLast();
            }
            return ret;
        }

        public List<T> toList() {
            return new ArrayList<T>(this.data);
        }

        public void clear() {
            this.data.clear();
        }

        public int size() {
            return this.data.size();
        }
    }

    public static class I18n {
        public static boolean contains(String s1, String s2) {
            return s1.contains(s2);
        }

        public static Pair<String, Boolean> search(String translateKey, Object ... parameters) {
            Pair<Object, Object> ret = new Pair<Object, Object>(null, null);
            String buffer = net.minecraft.client.resources.language.I18n.m_118938_((String)(translateKey = "jecalculation." + (String)translateKey), (Object[])parameters);
            ret.two = !buffer.equals(translateKey);
            buffer = I18n.unescape(buffer);
            ret.one = buffer.replace("\t", "    ");
            return ret;
        }

        public static String unescape(String s) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                int nc;
                char c = s.charAt(i);
                if (c != '\\' || i + 1 >= s.length()) {
                    sb.append(c);
                    continue;
                }
                int ec = nc = s.charAt(i + 1);
                if (nc == 117 && i + 5 < s.length()) {
                    String u = s.substring(i + 2, i + 6);
                    ec = (char)Integer.parseInt(u, 16);
                    i += 4;
                } else if (nc >= 48 && nc <= 55) {
                    char nnc = s.charAt(i + 2);
                    boolean duo = nnc >= '0' && nnc <= '7';
                    String o = s.substring(i + 1, i + (duo ? 3 : 2));
                    ec = (char)Integer.parseInt(o, 8);
                    if (duo) {
                        ++i;
                    }
                } else if (nc == 114) {
                    ec = 13;
                } else if (nc == 116) {
                    ec = 9;
                } else if (nc == 98) {
                    ec = 8;
                } else if (nc == 102) {
                    ec = 12;
                } else if (nc == 110) {
                    ec = 10;
                }
                ++i;
                sb.append((char)ec);
            }
            return sb.toString();
        }

        public static String get(String translateKey, Object ... parameters) {
            return (String)I18n.search((String)translateKey, (Object[])parameters).one;
        }

        public static List<String> wrap(String s, int width) {
            return new TextWrapper().wrap(s, I18n.getLocale(), i -> TextWrapper.renderer.m_92895_(String.valueOf(i)), width);
        }

        public static Locale getLocale() {
            String code = Minecraft.m_91087_().m_91102_().m_118983_().getCode();
            String[] splitLangCode = code.split("_", 2);
            return splitLangCode.length == 1 ? new Locale(code) : new Locale(splitLangCode[0], splitLangCode[1]);
        }

        static class TextWrapper {
            static Font renderer = Minecraft.m_91087_().f_91062_;
            String str;
            BreakIterator it;
            List<String> temp = new ArrayList<String>();
            Function<Character, Integer> func;
            float section;
            float space;
            float width;
            int start;
            int cursor;
            int end;

            TextWrapper() {
            }

            private void cut() {
                char c = this.str.charAt(this.cursor);
                if (c == '\f') {
                    ++this.cursor;
                }
                this.temp.add(this.str.substring(this.start, this.cursor));
                if (c == ' ' || c == '\u3000' || c == '\n') {
                    ++this.cursor;
                }
                this.start = this.cursor;
                this.end = this.cursor;
                this.space = this.width;
                this.section = this.func.apply(Character.valueOf(this.str.charAt(this.cursor))).intValue();
            }

            private void move() {
                this.temp.add(this.str.substring(this.start, this.end));
                this.start = this.end;
                this.space = this.width;
            }

            private List<String> wrap(String s, Locale l, Function<Character, Integer> func, int width) {
                this.temp.clear();
                this.start = 0;
                this.end = 0;
                this.cursor = 0;
                this.space = width;
                this.str = s;
                this.it = BreakIterator.getLineInstance(l);
                this.it.setText(s);
                this.width = width;
                this.func = func;
                int i = this.it.next();
                while (i != -1) {
                    this.cursor = this.end;
                    while (this.cursor < i) {
                        char ch = this.str.charAt(this.cursor);
                        this.section += (float)func.apply(Character.valueOf(this.str.charAt(this.cursor))).intValue();
                        if (ch == '\n' || ch == '\f') {
                            this.cut();
                        } else if (this.section > this.space) {
                            if (this.start == this.end) {
                                this.cut();
                            } else {
                                this.move();
                            }
                        }
                        ++this.cursor;
                    }
                    this.space -= this.section;
                    this.section = 0.0f;
                    this.end = this.cursor;
                    i = this.it.next();
                }
                this.move();
                return this.temp;
            }
        }
    }

    public static class ReversedIterator<T>
    implements Iterator<T> {
        ListIterator<T> i;

        public ReversedIterator(List<T> l) {
            this.i = l.listIterator(l.size());
        }

        @Override
        public boolean hasNext() {
            return this.i.hasPrevious();
        }

        @Override
        public T next() {
            return this.i.previous();
        }

        public Stream<T> stream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
        }
    }

    public static class Circulator {
        int total;
        int current;

        public Circulator(int total) {
            this(total, 0);
        }

        public Circulator(int total, int current) {
            this.total = total;
            this.current = current;
        }

        public int next() {
            return this.current + 1 == this.total ? 0 : this.current + 1;
        }

        public int prev() {
            return this.current == 0 ? this.total - 1 : this.current - 1;
        }

        public Circulator move(int steps) {
            this.current += steps;
            this.current = this.current < 0 ? (this.current += (this.total - this.current - 1) / this.total * this.total) : (this.current %= this.total);
            return this;
        }

        public int current() {
            return this.current;
        }

        public Circulator set(int index) {
            if (index < 0 || index >= this.total) {
                throw new RuntimeException(String.format("Expected: [0, %d), given: %d.", this.total, index));
            }
            this.current = index;
            return this;
        }

        public Circulator copy() {
            return new Circulator(this.total).set(this.current);
        }
    }

    public static class Timer {
        long time = System.currentTimeMillis();
        boolean running = false;

        public void setState(boolean b) {
            if (!b && this.running) {
                this.running = false;
            }
            if (b && !this.running) {
                this.running = true;
                this.time = System.currentTimeMillis();
            }
        }

        public long getTime() {
            return this.running ? System.currentTimeMillis() - this.time : 0L;
        }
    }

    public static class Relation<K, V> {
        public HashMap<Pair<K, K>, V> data = new HashMap();

        public void put(K a, K b, V v) {
            Pair<K, K> pair = new Pair<K, K>(a, b);
            V tmp = this.data.get(pair);
            this.data.put(tmp == null ? new Pair<K, K>(b, a) : pair, v);
        }

        @Nullable
        public V get(K a, K b) {
            V ret = this.data.get(new Pair<K, K>(a, b));
            if (ret == null) {
                ret = this.data.get(new Pair<K, K>(b, a));
            }
            return ret;
        }
    }
}

