/*
 * Decompiled with CFR 0.152.
 */
package net.stardustlabs.terralith.utils;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.cristellib.CristelLibExpectPlatform;
import net.stardustlabs.terralith.Terralith;

public class PreLoadTerralithBiomes {
    public static String getBiomeName(Path path) {
        String[] parts = path.toString().split("biome/");
        String biomeString = parts[parts.length - 1];
        return biomeString.split("\\.")[0];
    }

    public static Set<String> getBiomeFiles() {
        HashSet<String> paths = new HashSet<String>();
        try {
            PreLoadTerralithBiomes.walk(CristelLibExpectPlatform.getResourceDirectory((String)Terralith.HIGHEST_MOD_ID, (String)"data/terralith/worldgen/biome"), x$0 -> Files.exists(x$0, new LinkOption[0]), (path, file) -> {
                if (Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".json")) {
                    paths.add(PreLoadTerralithBiomes.getBiomeName(file));
                }
                return true;
            }, true, Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return paths;
    }

    public static void walk(Path root, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) throws IOException {
        if (root == null || !Files.exists(root, new LinkOption[0]) || !rootFilter.test(root)) {
            return;
        }
        if (processor != null) {
            try (Stream<Path> stream = Files.walk(root, maxDepth, new FileVisitOption[0]);){
                Iterator itr = stream.iterator();
                while (itr.hasNext()) {
                    boolean keepGoing = processor.apply(root, (Path)itr.next());
                    if (visitAllFiles || keepGoing) continue;
                    return;
                }
            }
        }
    }
}

