/*
 * Decompiled with CFR 0.152.
 */
package net.stardustlabs.terralith.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.cristellib.CristelLibExpectPlatform;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.stardustlabs.terralith.Terralith;
import net.stardustlabs.terralith.TerralithRL;
import net.stardustlabs.terralith.terrablender.TerralithRegion;
import net.stardustlabs.terralith.terrablender.TerralithSkylandRegion;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class TerrablenderUtil {
    private static final String OVERWORLD = "data/minecraft/dimension/overworld.json";
    private static final String NOISE = "data/minecraft/worldgen/noise_settings/overworld.json";

    public static SurfaceRules.RuleSource readSurfaceRulesFromNoise() {
        SurfaceRules.RuleSource ruleSource;
        InputStream im;
        try {
            Path path = CristelLibExpectPlatform.getResourceDirectory((String)Terralith.HIGHEST_MOD_ID, (String)NOISE);
            if (path == null) {
                throw new RuntimeException();
            }
            im = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            Terralith.LOGGER.error("Couldn't read data/minecraft/worldgen/noise_settings/overworld.json, crashing instead");
            throw new RuntimeException(e);
        }
        InputStreamReader reader = new InputStreamReader(im);
        try {
            JsonElement load = JsonParser.parseReader((Reader)reader);
            JsonElement element = load.getAsJsonObject().get("surface_rule");
            ruleSource = (SurfaceRules.RuleSource)TerrablenderUtil.readConfig(element, SurfaceRules.RuleSource.f_189682_, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception errorMsg) {
                throw new IllegalArgumentException("Couldn't parse data/minecraft/worldgen/noise_settings/overworld.json, crashing instead.");
            }
        }
        reader.close();
        return ruleSource;
    }

    public static <T> T readConfig(JsonElement load, Codec<T> codec, DynamicOps<JsonElement> ops) {
        DataResult decode = codec.decode(ops, (Object)load);
        Optional error = decode.error();
        if (error.isPresent()) {
            throw new IllegalArgumentException("Couldn't read " + load.toString() + ", crashing instead.");
        }
        return (T)((Pair)decode.result().orElseThrow()).getFirst();
    }

    public static List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> readParameterPoints(boolean doCurse) {
        ArrayList<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> arrayList;
        InputStream im;
        try {
            Path path = CristelLibExpectPlatform.getResourceDirectory((String)Terralith.HIGHEST_MOD_ID, (String)OVERWORLD);
            if (path == null) {
                throw new RuntimeException();
            }
            im = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            Terralith.LOGGER.error("Couldn't read data/minecraft/dimension/overworld.json, crashing instead");
            throw new RuntimeException(e);
        }
        InputStreamReader reader = new InputStreamReader(im);
        try {
            JsonElement el = JsonParser.parseReader((Reader)reader);
            if (!el.isJsonObject()) {
                throw new RuntimeException("Input stream is on JsonElement");
            }
            ArrayList<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> list = new ArrayList<Pair<Climate.ParameterPoint, ResourceKey<Biome>>>();
            JsonObject o = el.getAsJsonObject();
            JsonArray jsonArray = o.get("generator").getAsJsonObject().get("biome_source").getAsJsonObject().get("biomes").getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                ResourceLocation location;
                JsonObject e = jsonArray.get(i).getAsJsonObject();
                String b = e.get("biome").getAsString();
                if (!b.contains("skyland") && doCurse || (location = new ResourceLocation(b)).m_135827_().equals("minecraft") && (!b.contains("ocean") || Terralith.CURSED == Terralith.Cursed.SOME)) continue;
                ResourceKey r = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)location);
                JsonObject jo = e.get("parameters").getAsJsonObject();
                Climate.ParameterPoint point = (Climate.ParameterPoint)TerrablenderUtil.readConfig((JsonElement)jo, Climate.ParameterPoint.f_186862_, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
                Pair pair = new Pair((Object)point, (Object)r);
                list.add((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)pair);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                Terralith.LOGGER.error("Couldn't find data/minecraft/dimension/overworld.json, crashing instead");
                throw new RuntimeException(e);
            }
            catch (JsonSyntaxException | IOException e) {
                Terralith.LOGGER.error("Couldn't parse data/minecraft/dimension/overworld.json, crashing instead");
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return arrayList;
    }

    public static void readOverworldSurfaceRules() {
        SurfaceRules.RuleSource s = TerrablenderUtil.readSurfaceRulesFromNoise();
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"terralith", (SurfaceRules.RuleSource)s);
    }

    public static void registerRegions() {
        Regions.register((Region)new TerralithRegion(new TerralithRL("overworld"), 10));
        if (Terralith.CURSED == Terralith.Cursed.VERY) {
            Regions.register((Region)new TerralithSkylandRegion(new TerralithRL("skylands"), 2));
        }
    }
}

