/*
 * Decompiled with CFR 0.152.
 */
package net.stardustlabs.terralith.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.stardustlabs.terralith.Terralith;
import net.stardustlabs.terralith.config.ConfigUtil;

public class Util {
    public static Terralith.Mode getMode() {
        ConfigUtil.createConfig();
        if (!Terralith.isTerrablenderLoaded()) {
            Terralith.LOGGER.info("Overriding config for '{}': {} (Terrablender not installed)", (Object)"terrablender_compatibility", (Object)"FALSE");
            return Terralith.Mode.DEFAULT;
        }
        boolean mode = ConfigUtil.readConfigMode();
        try {
            Terralith.LOGGER.info("Loading config for '{}': {}", (Object)"terrablender_compatibility", (Object)Boolean.toString(mode).toUpperCase());
            if (mode) {
                return Terralith.Mode.TERRABLENDER;
            }
            return Terralith.Mode.DEFAULT;
        }
        catch (IllegalArgumentException e) {
            Terralith.LOGGER.warn("Invalid Mode '{}' for option '{}'", (Object)mode, (Object)"mode");
            return Terralith.Mode.TERRABLENDER;
        }
    }

    public static Terralith.Cursed getCursed() {
        ConfigUtil.createConfig();
        if (!Terralith.isTerrablenderLoaded()) {
            Terralith.LOGGER.info("Overriding config for '{}': {} (Terrablender not installed)", (Object)"cursed_skylands", (Object)"NONE");
            return Terralith.Cursed.NONE;
        }
        String cursed = ConfigUtil.readConfigCursed();
        try {
            Terralith.LOGGER.info("Loading config for '{}': {}", (Object)"cursed_skylands", (Object)cursed.toUpperCase());
            if (cursed.equals("some")) {
                return Terralith.Cursed.SOME;
            }
            if (cursed.equals("very")) {
                return Terralith.Cursed.VERY;
            }
            return Terralith.Cursed.NONE;
        }
        catch (IllegalArgumentException e) {
            Terralith.LOGGER.warn("Invalid Mode '{}' for option '{}'", (Object)cursed, (Object)"cursed");
            return Terralith.Cursed.NONE;
        }
    }

    public static void createDirectoriesSafe(Path path) throws IOException {
        Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
    }
}

