/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.init;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.gui.TieredConstructorScreen;
import com.YTrollman.CableTiers.gui.TieredDestructorScreen;
import com.YTrollman.CableTiers.gui.TieredDiskManipulatorScreen;
import com.YTrollman.CableTiers.gui.TieredExporterScreen;
import com.YTrollman.CableTiers.gui.TieredImporterScreen;
import com.YTrollman.CableTiers.gui.TieredRequesterScreen;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.model.BakedModelCableCover;
import com.refinedmods.refinedstorage.render.model.FullbrightBakedModel;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientEventHandler {
    private static final BakedModelOverrideRegistry bakedModelOverrideRegistry = new BakedModelOverrideRegistry();

    public ClientEventHandler() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
    }

    public void init(FMLClientSetupEvent event) {
        for (CableTier tier : CableTier.VALUES) {
            for (ContentType<?, ?, ?, ?> type : ContentType.CONTENT_TYPES) {
                ItemBlockRenderTypes.setRenderLayer(type.getBlock(tier), (RenderType)RenderType.m_110463_());
            }
            MenuScreens.m_96206_(ContentType.EXPORTER.getContainerType(tier), TieredExporterScreen::new);
            MenuScreens.m_96206_(ContentType.IMPORTER.getContainerType(tier), TieredImporterScreen::new);
            MenuScreens.m_96206_(ContentType.CONSTRUCTOR.getContainerType(tier), TieredConstructorScreen::new);
            MenuScreens.m_96206_(ContentType.DESTRUCTOR.getContainerType(tier), TieredDestructorScreen::new);
            MenuScreens.m_96206_(ContentType.DISK_MANIPULATOR.getContainerType(tier), TieredDiskManipulatorScreen::new);
            MenuScreens.m_96206_(ContentType.REQUESTER.getContainerType(tier), TieredRequesterScreen::new);
            bakedModelOverrideRegistry.add(new ResourceLocation("cabletiers", ContentType.EXPORTER.getName(tier)), (base, registry) -> new BakedModelCableCover(base));
            bakedModelOverrideRegistry.add(new ResourceLocation("cabletiers", ContentType.IMPORTER.getName(tier)), (base, registry) -> new BakedModelCableCover(base));
            bakedModelOverrideRegistry.add(new ResourceLocation("cabletiers", ContentType.CONSTRUCTOR.getName(tier)), (base, registry) -> new BakedModelCableCover(base));
            bakedModelOverrideRegistry.add(new ResourceLocation("cabletiers", ContentType.DESTRUCTOR.getName(tier)), (base, registry) -> new BakedModelCableCover(base));
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        FullbrightBakedModel.invalidateCache();
        for (ResourceLocation id : e.getModelRegistry().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = bakedModelOverrideRegistry.get(new ResourceLocation(id.m_135827_(), id.m_135815_()));
            if (factory == null) continue;
            e.getModelRegistry().put(id, factory.create((BakedModel)e.getModelRegistry().get(id), e.getModelRegistry()));
        }
    }
}

