/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.node;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.blockentity.TieredConstructorBlockEntity;
import com.YTrollman.CableTiers.config.CableConfig;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TieredConstructorNetworkNode
extends TieredNetworkNode<TieredConstructorNetworkNode>
implements IComparable,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_DROP = "Drop";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 20;
    private static final int SPEED_INCREASE = 4;
    private int currentSlot;
    private final BaseItemHandler itemFilters;
    private final FluidInventory fluidFilters;
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, this.CheckTierUpgrade()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private int compare = 1;
    private int type = 0;
    private boolean drop = false;
    private CoverManager coverManager = new CoverManager((NetworkNode)this);

    public TieredConstructorNetworkNode(Level level, BlockPos pos, CableTier tier) {
        super(level, pos, ContentType.CONSTRUCTOR, tier);
        this.itemFilters = new BaseItemHandler(1 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
        this.fluidFilters = new FluidInventory(1 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    }

    private UpgradeItem.Type[] CheckTierUpgrade() {
        if (this.getTier() == CableTier.ELITE) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK, UpgradeItem.Type.CRAFTING};
        }
        if (this.getTier() == CableTier.ULTRA) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.CRAFTING};
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.CRAFTING};
        }
        return null;
    }

    public int getEnergyUsage() {
        if (this.getTier() == CableTier.ELITE) {
            return 4 * (RS.SERVER_CONFIG.getConstructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ELITE_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 4 * (RS.SERVER_CONFIG.getConstructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ULTRA_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 4 * (RS.SERVER_CONFIG.getConstructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.CREATIVE_ENERGY_COST.get();
        }
        return 0;
    }

    public void update() {
        int baseSpeed;
        int speed;
        super.update();
        if (!(this.canUpdate() && this.level.m_46749_(this.pos) && this.level.m_46749_(this.pos.m_142300_(this.getDirection())))) {
            return;
        }
        if (this.getTier() != CableTier.CREATIVE && (speed = Math.max(1, this.upgrades.getSpeed(baseSpeed = 20 / this.getSpeedMultiplier(), 4))) > 1 && this.ticks % speed != 0) {
            return;
        }
        if (++this.currentSlot >= 1 * this.getTier().getSlotsMultiplier()) {
            this.currentSlot = 0;
        }
        if (this.type == 0 && !this.itemFilters.getStackInSlot(this.currentSlot).m_41619_()) {
            ItemStack stack = this.itemFilters.getStackInSlot(this.currentSlot);
            if (this.drop) {
                this.extractAndDropItem(stack);
            } else if (stack.m_41720_() == Items.f_42688_) {
                this.extractAndSpawnFireworks(stack);
            } else if (stack.m_41720_() instanceof BlockItem) {
                this.extractAndPlaceBlock(stack);
            }
        } else if (this.type == 1 && !this.fluidFilters.getFluid(this.currentSlot).isEmpty()) {
            this.extractAndPlaceFluid(this.fluidFilters.getFluid(this.currentSlot));
        }
    }

    private int getSpeedMultiplier() {
        switch (this.getTier()) {
            case ELITE: {
                return (Integer)CableConfig.ELITE_CONSTRUCTOR_SPEED.get();
            }
            case ULTRA: {
                return (Integer)CableConfig.ULTRA_CONSTRUCTOR_SPEED.get();
            }
        }
        throw new RuntimeException("illegal tier " + this.getTier());
    }

    private boolean interactWithStacks() {
        return this.getTier() != CableTier.ELITE || this.upgrades.hasUpgrade(UpgradeItem.Type.STACK);
    }

    private void extractAndPlaceFluid(FluidStack stack) {
        BlockPos front = this.pos.m_142300_(this.getDirection());
        for (int x = 0; x < this.network.extractFluid(stack, 1000, this.compare, Action.SIMULATE).getAmount(); ++x) {
            if (this.network.extractFluid(stack, 1000, this.compare, Action.SIMULATE).getAmount() < 1000) {
                if (!this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) continue;
                this.network.getCraftingManager().request((Object)this, stack, 1000);
                continue;
            }
            if (this.level.m_8055_(front).m_60819_().m_76170_()) continue;
            FluidUtil.tryPlaceFluid((Player)LevelUtils.getFakePlayer((ServerLevel)((ServerLevel)this.level), (UUID)this.getOwner()), (Level)this.level, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)front, (IFluidHandler)new NetworkFluidHandler(StackUtils.copy((FluidStack)stack, (int)1000)), (FluidStack)stack);
        }
    }

    private void extractAndPlaceBlock(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, 1, this.compare, Action.SIMULATE);
        if (!took.m_41619_()) {
            ItemStack tookCopy = took.m_41777_();
            TieredConstructorBlockItemUseContext ctx = new TieredConstructorBlockItemUseContext(this.level, (Player)LevelUtils.getFakePlayer((ServerLevel)((ServerLevel)this.level), (UUID)this.getOwner()), InteractionHand.MAIN_HAND, took, new BlockHitResult(Vec3.f_82478_, this.getDirection(), this.pos, false));
            InteractionResult result = ForgeHooks.onPlaceItemIntoWorld((UseOnContext)ctx);
            if (result.m_19077_()) {
                this.network.extractItem(tookCopy, 1, Action.PERFORM);
            }
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
            this.network.getCraftingManager().request((Object)this, stack, 1);
        }
    }

    private void extractAndDropItem(ItemStack stack) {
        int interactionCount = this.interactWithStacks() ? stack.m_41741_() : 1;
        ItemStack took = this.network.extractItem(stack, interactionCount, this.compare, Action.PERFORM);
        if (!took.m_41619_()) {
            DefaultDispenseItemBehavior.m_123378_((Level)this.level, (ItemStack)took, (int)6, (Direction)this.getDirection(), (Position)new PositionImpl(this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ()));
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
            this.network.getCraftingManager().request((Object)this, stack, 1);
        }
    }

    private void extractAndSpawnFireworks(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, 1, this.compare, Action.PERFORM);
        if (!took.m_41619_()) {
            this.level.m_7967_((Entity)new FireworkRocketEntity(this.level, this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ(), took));
        }
    }

    private double getDispensePositionX() {
        return (double)this.pos.m_123341_() + 0.5 + 0.8 * (double)this.getDirection().m_122429_();
    }

    private double getDispensePositionY() {
        return (double)this.pos.m_123342_() + (this.getDirection() == Direction.DOWN ? 0.45 : 0.5) + 0.8 * (double)this.getDirection().m_122430_();
    }

    private double getDispensePositionZ() {
        return (double)this.pos.m_123343_() + 0.5 + 0.8 * (double)this.getDirection().m_122431_();
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_TYPE, this.type);
        tag.m_128379_(NBT_DROP, this.drop);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        if (tag.m_128441_(NBT_DROP)) {
            this.drop = tag.m_128471_(NBT_DROP);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)TieredConstructorBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    private class NetworkFluidHandler
    implements IFluidHandler {
        private final FluidStack resource;

        public NetworkFluidHandler(FluidStack resource) {
            this.resource = resource;
        }

        public int getTanks() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            throw new UnsupportedOperationException();
        }

        public int getTankCapacity(int tank) {
            throw new UnsupportedOperationException();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            throw new UnsupportedOperationException();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return TieredConstructorNetworkNode.this.network.extractFluid(resource, resource.getAmount(), TieredConstructorNetworkNode.this.compare, action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return TieredConstructorNetworkNode.this.network.extractFluid(this.resource, this.resource.getAmount(), TieredConstructorNetworkNode.this.compare, action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
        }
    }

    private static class TieredConstructorBlockItemUseContext
    extends BlockPlaceContext {
        public TieredConstructorBlockItemUseContext(Level level, @Nullable Player player, InteractionHand hand, ItemStack stack, BlockHitResult rayTraceResult) {
            super(level, player, hand, stack, rayTraceResult);
        }
    }
}

