/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.modernstartupqol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MSQConfig {
    static final Logger LOGGER = LogManager.getLogger((String)"ModernStartupQOL/Config");
    public static final File DOT_MINECRAFT = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).toFile().getParentFile();
    public static final File TIMES_FILE = new File(DOT_MINECRAFT, "config/modernstartupqol/startup_times.json");
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        LOGGER.debug("Config has been loaded: {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        LOGGER.debug("Config has been reloaded: {}", (Object)configEvent.getConfig().getFileName());
    }

    public static long getTimeEstimates() {
        try {
            JsonArray ja;
            JsonObject jo;
            JsonReader jr;
            JsonElement jp;
            TIMES_FILE.getParentFile().mkdirs();
            if (!TIMES_FILE.exists()) {
                TIMES_FILE.createNewFile();
            }
            if ((jp = JsonParser.parseReader((JsonReader)(jr = new JsonReader((Reader)new FileReader(TIMES_FILE))))).isJsonObject() && (jo = jp.getAsJsonObject()).has("times") && jo.get("times").isJsonArray() && (ja = jo.get("times").getAsJsonArray()).size() > 0) {
                long sum = 0L;
                for (int i = 0; i < ja.size(); ++i) {
                    sum += ja.get(i).getAsLong();
                }
                return sum /= (long)ja.size();
            }
            jr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static void addStartupTime(long startupTime) {
        try {
            JsonObject jo;
            TIMES_FILE.getParentFile().mkdirs();
            if (!TIMES_FILE.exists()) {
                TIMES_FILE.createNewFile();
            }
            long[] times = new long[]{};
            JsonReader jr = new JsonReader((Reader)new FileReader(TIMES_FILE));
            JsonElement jp = JsonParser.parseReader((JsonReader)jr);
            if (jp.isJsonObject() && (jo = jp.getAsJsonObject()).has("times") && jo.get("times").isJsonArray()) {
                JsonArray ja = jo.get("times").getAsJsonArray();
                times = new long[ja.size()];
                for (int i = 0; i < ja.size(); ++i) {
                    times[i] = ja.get(i).getAsLong();
                }
            }
            jr.close();
            JsonWriter jw = new JsonWriter((Writer)new FileWriter(TIMES_FILE));
            jw.setIndent("  ");
            jw.beginObject();
            jw.name("times");
            jw.beginArray();
            if (times.length > 2) {
                for (int i = times.length - 2; i < times.length; ++i) {
                    jw.value(times[i]);
                }
            } else {
                for (long time : times) {
                    jw.value(time);
                }
            }
            jw.value(startupTime);
            jw.endArray();
            jw.endObject();
            jw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue fadeOutTime;
        public final ForgeConfigSpec.IntValue fadeInTime;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Startup Settings").push("startup");
            this.fadeOutTime = builder.comment("How long should the timer take to fade out? (in ticks)").defineInRange("fadeOutTime", 1000, 0, 10000);
            this.fadeInTime = builder.comment("How long should the timer take to fade in? (in ticks)").defineInRange("fadeInTime", 500, 0, 10000);
        }
    }
}

