/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.modernstartupqol.events;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.mja00.modernstartupqol.MSQConfig;
import java.awt.Color;
import java.lang.management.ManagementFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PlayerEvents {
    static final Logger LOGGER = LogManager.getLogger((String)"ModernStartupQOL/PlayerEvents");
    public static long expectedTime = 0L;
    public static long doneTime = 0L;
    static boolean triggered = false;
    public static boolean trueFullscreen;
    static long startupTime;
    static boolean hasBeenMainMenu;
    static boolean hasLeftMainMenu;

    @SubscribeEvent
    public static void onGuiDraw(ScreenEvent.DrawScreenEvent event) {
        if (!hasLeftMainMenu && event.getScreen() instanceof TitleScreen) {
            hasBeenMainMenu = true;
            long minutes = startupTime / 1000L / 60L;
            long seconds = startupTime / 1000L % 60L;
            long ex_mins = expectedTime / 1000L / 60L;
            long ex_secs = expectedTime / 1000L % 60L;
            float guiScale = (float)Minecraft.m_91087_().m_91268_().m_85449_();
            if (guiScale <= 0.0f) {
                guiScale = 1.0f;
            }
            String txt = "Startup took " + minutes + "m " + seconds + "s | Last 3 avg: " + ex_mins + "m " + ex_secs + "s";
            float pX = (float)Minecraft.m_91087_().m_91268_().m_85441_() / 2.0f / guiScale - (float)Minecraft.m_91087_().f_91062_.m_92895_(txt) / 2.0f;
            float pY = (float)Minecraft.m_91087_().m_91268_().m_85442_() / guiScale - 20.0f;
            int color = startupTime < 90000L ? Color.GREEN.getRGB() : (startupTime < 120000L ? Color.YELLOW.getRGB() : Color.RED.getRGB());
            Minecraft.m_91087_().f_91062_.m_92750_(new PoseStack(), txt, pX, pY, color);
        } else if (hasBeenMainMenu) {
            hasLeftMainMenu = true;
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenOpenEvent event) {
        if (!triggered && event.getScreen() instanceof TitleScreen) {
            triggered = true;
            Minecraft.m_91087_().f_91066_.f_92052_ = trueFullscreen;
            if (Minecraft.m_91087_().f_91066_.f_92052_ && !Minecraft.m_91087_().m_91268_().m_85440_()) {
                Minecraft.m_91087_().m_91268_().m_85438_();
                Minecraft.m_91087_().f_91066_.f_92052_ = Minecraft.m_91087_().m_91268_().m_85440_();
            }
            startupTime = ManagementFactory.getRuntimeMXBean().getUptime();
            LOGGER.info("Startup took " + startupTime + "ms");
            doneTime = startupTime;
            MSQConfig.addStartupTime(startupTime);
        }
    }

    static {
        hasBeenMainMenu = false;
        hasLeftMainMenu = false;
    }
}

