/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.ensorcellation.enchantment.SoulboundEnchantment;
import cofh.ensorcellation.init.EnsorcEnchantments;
import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.Utils;
import java.util.Iterator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class SoulboundEvents {
    private SoulboundEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerDropsEvent(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (Utils.isFakePlayer((Entity)player) || player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            Iterator iter = event.getDrops().iterator();
            while (iter.hasNext()) {
                ItemStack stack = ((ItemEntity)iter.next()).m_32055_();
                if (Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)EnsorcEnchantments.SOULBOUND.get()), (ItemStack)stack) <= 0 || !Utils.addToPlayerInventory((Player)player, (ItemStack)stack)) continue;
                iter.remove();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerCloneEvent(PlayerEvent.Clone event) {
        int encSoulbound;
        ItemStack stack;
        int i;
        if (!event.isWasDeath()) {
            return;
        }
        Player player = event.getPlayer();
        Player oldPlayer = event.getOriginal();
        if (Utils.isFakePlayer((Entity)player) || player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        EnchantmentCoFH soulbound = (EnchantmentCoFH)EnsorcEnchantments.SOULBOUND.get();
        for (i = 0; i < oldPlayer.f_36093_.f_35975_.size(); ++i) {
            stack = (ItemStack)oldPlayer.f_36093_.f_35975_.get(i);
            encSoulbound = Utils.getItemEnchantmentLevel((Enchantment)soulbound, (ItemStack)stack);
            if (encSoulbound <= 0) continue;
            if (SoulboundEnchantment.permanent) {
                if (encSoulbound > 1) {
                    Utils.removeEnchantment((ItemStack)stack, (Enchantment)soulbound);
                    Utils.addEnchantment((ItemStack)stack, (Enchantment)soulbound, (int)1);
                }
            } else if (player.f_19853_.f_46441_.nextInt(1 + encSoulbound) == 0) {
                Utils.removeEnchantment((ItemStack)stack, (Enchantment)soulbound);
                if (encSoulbound > 1) {
                    Utils.addEnchantment((ItemStack)stack, (Enchantment)soulbound, (int)(encSoulbound - 1));
                }
            }
            if (!Utils.addToPlayerInventory((Player)player, (ItemStack)stack)) continue;
            oldPlayer.f_36093_.f_35975_.set(i, (Object)ItemStack.f_41583_);
        }
        for (i = 0; i < oldPlayer.f_36093_.f_35974_.size(); ++i) {
            stack = (ItemStack)oldPlayer.f_36093_.f_35974_.get(i);
            encSoulbound = Utils.getItemEnchantmentLevel((Enchantment)soulbound, (ItemStack)stack);
            if (encSoulbound <= 0) continue;
            if (SoulboundEnchantment.permanent) {
                if (encSoulbound > 1) {
                    Utils.removeEnchantment((ItemStack)stack, (Enchantment)soulbound);
                    Utils.addEnchantment((ItemStack)stack, (Enchantment)soulbound, (int)1);
                }
            } else if (player.f_19853_.f_46441_.nextInt(1 + encSoulbound) == 0) {
                Utils.removeEnchantment((ItemStack)stack, (Enchantment)soulbound);
                if (encSoulbound > 1) {
                    Utils.addEnchantment((ItemStack)stack, (Enchantment)soulbound, (int)(encSoulbound - 1));
                }
            }
            if (!Utils.addToPlayerInventory((Player)player, (ItemStack)stack)) continue;
            oldPlayer.f_36093_.f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
    }
}

